/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.rule;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.datamining.ComparisonOperator;
import javax.datamining.JDMException;
import javax.datamining.algorithm.kmeans.ClusteringDistanceFunction;
import javax.datamining.rule.BooleanOperator;
import javax.datamining.rule.CompoundPredicate;
import javax.datamining.rule.Predicate;
import javax.datamining.rule.Rule;
import javax.datamining.rule.RuleTranslationFormat;
import javax.datamining.rule.SimplePredicate;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.rule.OraCompoundPredicate;
import oracle.dmt.jdm.rule.OraPredicate;
import oracle.dmt.jdm.rule.OraSimplePredicate;
import oracle.dmt.jdm.transform.OraTransformation;

public class OraRule
extends OraDMObject
implements Rule {
    protected static final String attribute_name = "attribute_name";
    protected static final String cond_op = "cond_op";
    protected static final String predictor_val = "predictor_val";
    protected static final String attribute_support = "attribute_support";
    protected static final String attr_conf = "attr_conf";
    public static final int MODEL_TYPE_KMEANS = 0;
    public static final int MODEL_TYPE_OCLUSTER = 1;
    public static final int MODEL_TYPE_TREE = 2;
    public static final int MODEL_TYPE_ABN = 3;
    protected String m_modelName;
    protected int m_modelType = 0;
    protected int m_clusterId;
    protected int m_ruleId;
    protected double m_support;
    protected double m_confidence;
    protected long m_absoluteSupport;
    protected OraPredicate m_antecedent = null;
    protected OraPredicate m_consequent = null;
    protected OraTransformation m_Transform = null;
    protected ClusteringDistanceFunction m_distanceFunction = null;

    protected OraRule(OraConnection dmeConn, String modelName, int modelType, int clusterId, int ruleId, double ruleSupport, double ruleConfidence, OraTransformation transform, ClusteringDistanceFunction distanceFunction) throws JDMException {
        super(dmeConn, null);
        this.m_modelName = modelName;
        this.m_modelType = modelType;
        this.m_clusterId = clusterId;
        this.m_ruleId = ruleId;
        this.m_support = ruleSupport;
        this.m_confidence = ruleConfidence;
        this.m_distanceFunction = distanceFunction;
        this.m_Transform = transform;
    }

    public OraRule(OraConnection dmeConn, int ruleId, OraPredicate antecedent, OraPredicate consequent, double ruleSupport, double ruleConfidence, long absoluteSupport) throws JDMException {
        super(dmeConn, null);
        this.m_modelType = 2;
        this.m_ruleId = ruleId;
        this.m_support = ruleSupport;
        this.m_confidence = ruleConfidence;
        this.m_absoluteSupport = absoluteSupport;
        this.m_antecedent = antecedent;
        this.m_consequent = consequent;
    }

    public OraRule(OraConnection dmeConn, String modelName, int ruleId, double ruleSupport, double ruleConfidence, OraTransformation transform) throws JDMException {
        super(dmeConn, null);
        this.m_modelType = 3;
        this.m_modelName = modelName;
        this.m_ruleId = ruleId;
        this.m_support = ruleSupport;
        this.m_confidence = ruleConfidence;
        this.m_Transform = transform;
    }

    public double getSupport() {
        return this.m_support;
    }

    public long getAbsoluteSupport() {
        return this.m_absoluteSupport;
    }

    public double getConfidence() {
        return this.m_confidence;
    }

    public Predicate getAntecedent() {
        if (this.m_antecedent != null) {
            return this.m_antecedent;
        }
        return this.m_antecedent;
    }

    protected CompoundPredicate getPredicate(String query) throws JDMException {
        return this.getPredicate(query, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompoundPredicate getPredicate(String query, boolean isOnlyTopElement) throws JDMException {
        Connection dbConn = this.getDatabaseConnection();
        Vector<OraSimplePredicate> tempSimplePredicates = new Vector<OraSimplePredicate>();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        try {
            pStmt = dbConn.prepareStatement(query);
            pStmt.setString(ind++, this.m_modelName);
            pStmt.setInt(ind++, this.m_ruleId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                String antAttributeName = rs.getString(attribute_name);
                String antCondOperator = rs.getString(cond_op);
                String antPredictorValue = rs.getString(predictor_val);
                Double antNumValue = null;
                String antAttributeStrValue = null;
                if (antPredictorValue != null) {
                    try {
                        antNumValue = new Double(antPredictorValue);
                    }
                    catch (NumberFormatException e) {
                        antAttributeStrValue = antPredictorValue;
                    }
                }
                OraSimplePredicate predicate = null;
                try {
                    String[] stringArray;
                    OraConnection oraConnection = this.getConnection();
                    ComparisonOperator comparisonOperator = OraPLSQLMappings.getComparisonOperator(antCondOperator);
                    if (antAttributeStrValue != null) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = antAttributeStrValue;
                    } else {
                        stringArray = null;
                    }
                    predicate = new OraSimplePredicate(oraConnection, antAttributeName, comparisonOperator, antNumValue, stringArray);
                }
                catch (Exception e) {
                    predicate = null;
                }
                if (predicate != null) {
                    tempSimplePredicates.add(predicate);
                }
                if (!isOnlyTopElement) continue;
                break;
            }
        }
        catch (Exception sqlExp) {
            tempSimplePredicates = null;
            this.getConnection().createRuntimeException("2002", new Object[]{this.m_modelName}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return new OraCompoundPredicate(this.getConnection(), (Predicate[])(tempSimplePredicates != null ? tempSimplePredicates.toArray(new SimplePredicate[tempSimplePredicates.size()]) : null), BooleanOperator.and);
    }

    public Predicate getConsequent() {
        if (this.m_consequent != null) {
            return this.m_consequent;
        }
        return this.m_consequent;
    }

    public int getRuleIdentifier() {
        return this.m_ruleId;
    }

    public String translate() throws JDMException {
        return null;
    }

    public String translate(RuleTranslationFormat format) throws JDMException {
        return null;
    }
}

