/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.datamining.ComparisonOperator;
import javax.datamining.JDMException;
import javax.datamining.rule.BooleanOperator;
import javax.datamining.rule.CompoundPredicate;
import javax.datamining.rule.Predicate;
import javax.datamining.rule.SimplePredicate;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.rule.OraPredicate;
import oracle.dmt.jdm.rule.OraSimplePredicate;

public class OraCompoundPredicate
extends OraPredicate
implements CompoundPredicate {
    private Predicate[] m_predicates;
    private BooleanOperator m_booleanOperator = null;

    public BooleanOperator getOperator() {
        return this.m_booleanOperator;
    }

    public Predicate[] getPredicates() {
        return this.m_predicates;
    }

    public OraCompoundPredicate(OraConnection dmeConn, Predicate[] predicates, BooleanOperator booleanOp) throws JDMException {
        super(dmeConn);
        this.getValidationHandler().validateArray(predicates, "predicates");
        this.getValidationHandler().validateNotNull(booleanOp, "booleanOp");
        if (booleanOp.equals((Object)BooleanOperator.not)) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new Object[]{"BooleanOperator", booleanOp.name()}, null);
        }
        this.m_predicates = predicates;
        this.m_booleanOperator = booleanOp;
    }

    private void buildSimplePredicatesMap(Map simplePredMap) {
        for (int i = 0; i < this.m_predicates.length; ++i) {
            if (this.m_predicates[i] instanceof OraCompoundPredicate) {
                ((OraCompoundPredicate)this.m_predicates[i]).buildSimplePredicatesMap(simplePredMap);
            } else if (this.m_predicates[i] instanceof OraSimplePredicate) {
                String attrName = ((OraSimplePredicate)this.m_predicates[i]).getAttributeName();
                Object attrAssociatedObject = simplePredMap.get(attrName);
                if (attrAssociatedObject == null) {
                    simplePredMap.put(attrName, this.m_predicates[i]);
                } else if (attrAssociatedObject instanceof ArrayList) {
                    ((ArrayList)attrAssociatedObject).add(this.m_predicates[i]);
                } else {
                    ArrayList<Object> simplePredArray = new ArrayList<Object>();
                    simplePredArray.add(attrAssociatedObject);
                    simplePredArray.add(this.m_predicates[i]);
                    simplePredMap.put(attrName, simplePredArray);
                }
            }
            if (this.m_booleanOperator.equals((Object)BooleanOperator.surrogate)) break;
        }
    }

    public String toString() {
        StringBuffer predicate = new StringBuffer();
        for (int i = 0; i < this.m_predicates.length; ++i) {
            if (i > 0) {
                predicate.append(' ').append(this.m_booleanOperator.name()).append(' ');
            }
            predicate.append(this.m_predicates[i].toString());
        }
        return predicate.toString();
    }

    public String toConciseString() {
        LinkedHashMap<String, Object> attrSimplePredicatesMap = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.m_predicates.length; ++i) {
            if (this.m_predicates[i] instanceof OraCompoundPredicate) {
                ((OraCompoundPredicate)this.m_predicates[i]).buildSimplePredicatesMap(attrSimplePredicatesMap);
            } else if (this.m_predicates[i] instanceof OraSimplePredicate) {
                String attrName = ((OraSimplePredicate)this.m_predicates[i]).getAttributeName();
                Object attrAssociatedObject = attrSimplePredicatesMap.get(attrName);
                if (attrAssociatedObject == null) {
                    attrSimplePredicatesMap.put(attrName, this.m_predicates[i]);
                } else if (attrAssociatedObject instanceof ArrayList) {
                    ((ArrayList)attrAssociatedObject).add(this.m_predicates[i]);
                } else {
                    ArrayList<Object> simplePredArray = new ArrayList<Object>();
                    simplePredArray.add(attrAssociatedObject);
                    simplePredArray.add(this.m_predicates[i]);
                    attrSimplePredicatesMap.put(attrName, simplePredArray);
                }
            }
            if (this.m_booleanOperator.equals((Object)BooleanOperator.surrogate)) break;
        }
        StringBuffer predStrBuf = new StringBuffer();
        Collection simplePredicates = attrSimplePredicatesMap.values();
        Iterator spIT = simplePredicates.iterator();
        boolean isFirst = true;
        while (spIT.hasNext()) {
            Object spObj = spIT.next();
            if (spObj instanceof SimplePredicate) {
                if (isFirst) {
                    predStrBuf.append(spObj.toString());
                    isFirst = false;
                    continue;
                }
                predStrBuf.append(" ").append(this.m_booleanOperator.name()).append(" ").append(spObj.toString());
                continue;
            }
            if (!(spObj instanceof ArrayList)) continue;
            ArrayList attrSimplPreds = (ArrayList)spObj;
            SimplePredicate firstSimplePredicate = (SimplePredicate)attrSimplPreds.get(0);
            boolean isNumerical = firstSimplePredicate.isNumericalValue();
            String attrName = firstSimplePredicate.getAttributeName();
            if (isNumerical) {
                Double lowestValue = null;
                Double lowestEqualValue = null;
                Double highestValue = null;
                Double highestEqualValue = null;
                ArrayList<Double> equalValues = null;
                ArrayList<Double> notEqualValues = null;
                for (int j = 0; j < attrSimplPreds.size(); ++j) {
                    SimplePredicate simplPred = (SimplePredicate)attrSimplPreds.get(j);
                    if (!simplPred.isNumericalValue()) continue;
                    ComparisonOperator compOperator = simplPred.getComparisonOperator();
                    if (ComparisonOperator.lessOrEqual.equals((Object)compOperator)) {
                        if (lowestEqualValue == null && lowestValue == null) {
                            lowestEqualValue = simplPred.getNumericalValue();
                            continue;
                        }
                        if (lowestEqualValue == null) {
                            if (!(simplPred.getNumericalValue() < lowestValue)) continue;
                            lowestValue = null;
                            lowestEqualValue = simplPred.getNumericalValue();
                            continue;
                        }
                        if (lowestValue != null || !(simplPred.getNumericalValue() < lowestEqualValue)) continue;
                        lowestEqualValue = simplPred.getNumericalValue();
                        continue;
                    }
                    if (ComparisonOperator.lessThan.equals((Object)compOperator)) {
                        if (lowestEqualValue == null && lowestValue == null) {
                            lowestValue = simplPred.getNumericalValue();
                            continue;
                        }
                        if (lowestEqualValue == null) {
                            if (!(simplPred.getNumericalValue() < lowestValue)) continue;
                            lowestValue = simplPred.getNumericalValue();
                            continue;
                        }
                        if (lowestValue != null || !(simplPred.getNumericalValue() <= lowestEqualValue)) continue;
                        lowestEqualValue = null;
                        lowestValue = simplPred.getNumericalValue();
                        continue;
                    }
                    if (ComparisonOperator.greaterOrEqual.equals((Object)compOperator)) {
                        if (highestValue == null && highestEqualValue == null) {
                            highestEqualValue = simplPred.getNumericalValue();
                            continue;
                        }
                        if (highestEqualValue == null) {
                            if (!(simplPred.getNumericalValue() > highestValue)) continue;
                            highestValue = null;
                            highestEqualValue = simplPred.getNumericalValue();
                            continue;
                        }
                        if (highestValue != null || !(simplPred.getNumericalValue() > highestEqualValue)) continue;
                        highestEqualValue = simplPred.getNumericalValue();
                        continue;
                    }
                    if (ComparisonOperator.greaterThan.equals((Object)compOperator)) {
                        if (highestValue == null && highestEqualValue == null) {
                            highestValue = simplPred.getNumericalValue();
                            continue;
                        }
                        if (highestEqualValue == null) {
                            if (!(simplPred.getNumericalValue() > highestValue)) continue;
                            highestValue = simplPred.getNumericalValue();
                            continue;
                        }
                        if (highestValue != null || !(simplPred.getNumericalValue() > highestEqualValue)) continue;
                        highestEqualValue = null;
                        highestValue = simplPred.getNumericalValue();
                        continue;
                    }
                    if (ComparisonOperator.equal.equals((Object)compOperator)) {
                        if (equalValues == null) {
                            equalValues = new ArrayList<Double>();
                        }
                        equalValues.add(simplPred.getNumericalValue());
                        continue;
                    }
                    if (!ComparisonOperator.notEqual.equals((Object)compOperator)) continue;
                    if (equalValues == null) {
                        notEqualValues = new ArrayList<Double>();
                    }
                    notEqualValues.add(simplPred.getNumericalValue());
                }
                if (equalValues != null || notEqualValues != null) {
                    if (equalValues != null) {
                        for (int nEquals = 0; nEquals < equalValues.size(); ++nEquals) {
                            if (!isFirst) {
                                predStrBuf.append(" ").append(BooleanOperator.and.name()).append(" ");
                            } else {
                                isFirst = false;
                            }
                            predStrBuf.append(attrName).append(" = ").append(equalValues.get(nEquals));
                        }
                    }
                    if (notEqualValues == null) continue;
                    for (int nNotEquals = 0; nNotEquals < notEqualValues.size(); ++nNotEquals) {
                        if (!isFirst) {
                            predStrBuf.append(" ").append(BooleanOperator.and.name()).append(" ");
                        } else {
                            isFirst = false;
                        }
                        predStrBuf.append(attrName).append(" = ").append(equalValues.get(nNotEquals));
                    }
                    continue;
                }
                if (lowestValue != null || lowestEqualValue != null) {
                    if (lowestValue != null) {
                        if (!isFirst) {
                            predStrBuf.append(" ").append(BooleanOperator.and.name()).append(" ");
                        } else {
                            isFirst = false;
                        }
                        predStrBuf.append(attrName).append(" < ").append(lowestValue);
                        continue;
                    }
                    if (!isFirst) {
                        predStrBuf.append(" ").append(BooleanOperator.and.name()).append(" ");
                    } else {
                        isFirst = false;
                    }
                    predStrBuf.append(attrName).append(" <= ").append(lowestEqualValue);
                    continue;
                }
                if (highestValue == null && highestEqualValue == null) continue;
                if (highestValue != null) {
                    if (!isFirst) {
                        predStrBuf.append(" ").append(BooleanOperator.and.name()).append(" ");
                    } else {
                        isFirst = false;
                    }
                    predStrBuf.append(attrName).append(" > ").append(highestValue);
                    continue;
                }
                if (!isFirst) {
                    predStrBuf.append(" ").append(BooleanOperator.and.name()).append(" ");
                } else {
                    isFirst = false;
                }
                predStrBuf.append(attrName).append(" >= ").append(highestEqualValue);
                continue;
            }
            for (int j = 0; j < attrSimplPreds.size(); ++j) {
                if (!isFirst) {
                    predStrBuf.append(" ").append(BooleanOperator.and.name()).append(" ");
                } else {
                    isFirst = false;
                }
                predStrBuf.append(attrSimplPreds.get(j).toString());
            }
        }
        return predStrBuf.toString();
    }
}

