/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.rule;

import javax.datamining.JDMException;
import javax.datamining.algorithm.kmeans.ClusteringDistanceFunction;
import javax.datamining.rule.Predicate;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.rule.OraPredicate;
import oracle.dmt.jdm.rule.OraRule;
import oracle.dmt.jdm.transform.OraTransformation;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.transform.binning.OraBinningTransformImpl;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransform;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransformImpl;

public class OraClusterRule
extends OraRule {
    protected static String QRY_RULE_ANTECEDENT_KM = "SELECT     NVL2( rl_ant.attribute_subname, rl_ant.attribute_name || '.' || rl_ant.attribute_subname, rl_ant.attribute_name)           attribute_name,    rl_ant.conditional_operator     cond_op,    Nvl(rl_ant.attribute_str_value, rl_ant.attribute_num_value) predictor_val  FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_km(?,?,null,0,0,2))) a,    TABLE(a.rule.antecedent) rl_ant    ORDER BY attribute_name, cond_op, predictor_val";
    protected static String QRY_DECODE_RULE_ANTECEDENT_KM = "SELECT     NVL2( rl_ant.attribute_subname, rl_ant.attribute_name || '.' || rl_ant.attribute_subname, rl_ant.attribute_name)           attribute_name,    rl_ant.conditional_operator     cond_op,    Nvl(rl_ant.attribute_str_value, (rl_ant.attribute_num_value*l.scale)+l.shift) predictor_val FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_km(?,?,null,0,0,2))) a,    TABLE(a.rule.antecedent) rl_ant LEFT OUTER JOIN    label_view l    ON NVL2( rl_ant.attribute_subname, rl_ant.attribute_name || '.' || rl_ant.attribute_subname, rl_ant.attribute_name) = l.col  ORDER BY attribute_name, cond_op, predictor_val";
    protected static String QRY_RULE_ANTECEDENT_OC = "SELECT     rl_ant.attribute_name           attribute_name,    rl_ant.conditional_operator     cond_op,    Nvl(rl_ant.attribute_str_value, rl_ant.attribute_num_value) predictor_val  FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, null, 0, 0, 2))) a,    TABLE(a.rule.antecedent) rl_ant    ORDER BY attribute_name, cond_op, predictor_val";
    protected static String QRY_DECODE_RULE_ANTECEDENT_OC = "SELECT     rl_ant.attribute_name           attribute_name,    rl_ant.conditional_operator     cond_op,    Nvl(l.label, Nvl(rl_ant.attribute_str_value, rl_ant.attribute_num_value))  predictor_val  FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, null, 0, 0, 2))) a,    TABLE(a.rule.antecedent) rl_ant,    label_view l    WHERE rl_ant.attribute_name = l.col(+)   AND (Nvl(rl_ant.attribute_str_value, rl_ant.attribute_num_value) = l.bin(+) )  ORDER BY attribute_name, cond_op, predictor_val";
    protected static String QRY_RULE_CONSEQUENT_KM = "SELECT     NVL2( rl_cons.attribute_subname, rl_cons.attribute_name || '.' || rl_cons.attribute_subname, rl_cons.attribute_name)  attribute_name,    rl_cons.conditional_operator     cond_op,    Nvl(rl_cons.attribute_str_value, rl_cons.attribute_num_value) predictor_val  FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, null, 0, 0, 2))) a,    TABLE(a.rule.consequent) rl_cons    ORDER BY attribute_name, cond_op, predictor_val";
    protected static String QRY_DECODE_RULE_CONSEQUENT_KM = "SELECT     NVL2( rl_cons.attribute_subname, rl_cons.attribute_name || '.' || rl_cons.attribute_subname, rl_cons.attribute_name)  attribute_name,    rl_cons.conditional_operator     cond_op,    (rl_cons.attribute_num_value*l.scale)+l.shift predictor_val  FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, null, 0, 0, 2))) a,    TABLE(a.consequent) rl_cons LEFT OUTER JOIN    label_view l    ON NVL2( rl_cons.attribute_subname, rl_cons.attribute_name || '.' || rl_cons.attribute_subname, rl_cons.attribute_name) = l.col  ORDER BY attribute_name, cond_op, predictor_val";
    protected static String QRY_RULE_CONSEQUENT_OC = "SELECT     rl_cons.attribute_name           attribute_name,    rl_cons.conditional_operator     cond_op,    Nvl(rl_cons.attribute_str_value, rl_cons.attribute_num_value) predictor_val  FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, null, 0, 0, 2))) a,    TABLE(a.rule.consequent) rl_cons    ORDER BY attribute_name, cond_op, predictor_val";
    protected static String QRY_DECODE_RULE_CONSEQUENT_OC = "SELECT     rl_cons.attribute_name        attribute_name,    rl_cons.conditional_operator  cond_op,    Nvl(l.label, Nvl(rl_cons.attribute_str_value, rl_cons.attribute_num_value))  predictor_val  FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, null, 0, 0, 2))) a,    TABLE(a.rule.consequent) rl_cons,    label_view l    WHERE   rl_cons.attribute_name = l.col (+)    AND (Nvl(rl_cons.attribute_str_value, rl_cons.attribute_num_value) = l.bin(+) )  ORDER BY attribute_name, cond_op, predictor_val";

    private void setup102() {
        if (this.is102()) {
            QRY_RULE_ANTECEDENT_KM = "SELECT     rl_ant.attribute_name           attribute_name,    rl_ant.conditional_operator     cond_op,    Nvl(rl_ant.attribute_str_value, rl_ant.attribute_num_value) predictor_val  FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_km(?,?,null,0,0,2))) a,    TABLE(a.rule.antecedent) rl_ant    ORDER BY attribute_name, cond_op, predictor_val";
            QRY_DECODE_RULE_ANTECEDENT_KM = "SELECT     rl_ant.attribute_name           attribute_name,    rl_ant.conditional_operator     cond_op,    Nvl(rl_ant.attribute_str_value, (rl_ant.attribute_num_value*l.scale)+l.shift) predictor_val FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_km(?,?,null,0,0,2))) a,    TABLE(a.rule.antecedent) rl_ant,    label_view l    WHERE rl_ant.attribute_name = l.col(+)  ORDER BY attribute_name, cond_op, predictor_val";
            QRY_RULE_CONSEQUENT_KM = "SELECT     rl_cons.attribute_name           attribute_name,    rl_cons.conditional_operator     cond_op,    Nvl(rl_cons.attribute_str_value, rl_cons.attribute_num_value) predictor_val  FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, null, 0, 0, 2))) a,    TABLE(a.rule.consequent) rl_cons    ORDER BY attribute_name, cond_op, predictor_val";
            QRY_DECODE_RULE_CONSEQUENT_KM = "SELECT     rl_cons.attribute_name           attribute_name,    rl_cons.conditional_operator     cond_op,    (rl_cons.attribute_num_value*l.scale)+l.shift predictor_val  FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, null, 0, 0, 2))) a,    TABLE(a.consequent) rl_cons,    label_view l    WHERE rl_cons.attribute_name = l.col (+)   ORDER BY attribute_name, cond_op, predictor_val";
        }
    }

    public OraClusterRule(OraConnection dmeConn, String modelName, int modelType, int clusterId, int ruleId, double ruleSupport, double ruleConfidence, OraTransformation transform, ClusteringDistanceFunction distanceFunction) throws JDMException {
        super(dmeConn, modelName, modelType, clusterId, ruleId, ruleSupport, ruleConfidence, transform, distanceFunction);
        this.setup102();
    }

    public Predicate getAntecedent() {
        if (this.m_antecedent != null) {
            return this.m_antecedent;
        }
        String query = null;
        if (this.m_modelType == 0) {
            if (this.m_distanceFunction.equals((Object)ClusteringDistanceFunction.euclidean)) {
                if (this.m_Transform != null) {
                    query = OraNormalizeTransformImpl.getUnnormalizeClause(((OraNormalizeTransform)this.m_Transform).getNormalizationDefinitionTable(), this.is102());
                    query = "WITH label_view AS ( " + query + " ) " + QRY_DECODE_RULE_ANTECEDENT_KM;
                } else {
                    query = QRY_RULE_ANTECEDENT_KM;
                }
            } else {
                query = QRY_RULE_ANTECEDENT_KM;
            }
        } else if (this.m_Transform == null) {
            query = QRY_RULE_ANTECEDENT_OC;
        } else {
            query = OraBinningTransformImpl.getUnbinningClause(((OraBinningTransform)this.m_Transform).getCategoricalBinTable(), ((OraBinningTransform)this.m_Transform).getNumericalBinTable());
            query = "WITH label_view AS ( " + query + " ) " + QRY_DECODE_RULE_ANTECEDENT_OC;
        }
        try {
            this.m_antecedent = (OraPredicate)this.getPredicate(query);
        }
        catch (Exception ex) {
            this.logTrace("Failed Operation: OraClusterRule.getAntecedent: Cluster ID:" + this.m_clusterId + ":  , rule ID:" + this.m_ruleId, ex);
        }
        return this.m_antecedent;
    }

    public Predicate getConsequent() {
        if (this.m_consequent != null) {
            return this.m_consequent;
        }
        String query = null;
        if (this.m_modelType == 0) {
            query = QRY_RULE_CONSEQUENT_KM;
        } else if (this.m_Transform == null) {
            query = QRY_RULE_CONSEQUENT_OC;
        } else {
            query = OraBinningTransformImpl.getUnbinningClause(((OraBinningTransform)this.m_Transform).getCategoricalBinTable(), ((OraBinningTransform)this.m_Transform).getNumericalBinTable());
            query = "WITH label_view AS ( " + query + " ) " + QRY_DECODE_RULE_CONSEQUENT_OC;
        }
        try {
            this.m_consequent = (OraPredicate)this.getPredicate(query);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        return this.m_consequent;
    }
}

