/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.resource;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.datamining.JDMIllegalArgumentException;
import javax.datamining.NamedObject;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraCapabilities;
import oracle.dmt.jdm.resource.OraExceptionHandler;
import oracle.jdbc.pool.OracleDataSource;

public class OraValidationHandler
extends OraCapabilities {
    private Locale m_locale = Locale.getDefault();
    private String m_javaCharSet = null;
    private OraExceptionHandler m_exceptionHandler = null;
    private static final int INTEGER_NUMBER = 1;
    private static final int LONG_NUMBER = 2;
    private static final int DOUBLE_NUMBER = 3;

    OraValidationHandler() {
    }

    OraValidationHandler(Locale locale, String javaCharSet) {
        this.m_locale = locale;
        this.m_javaCharSet = javaCharSet;
    }

    void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    void setChracterSet(String javaCharSet) {
        this.m_javaCharSet = javaCharSet;
    }

    void setExceptionHandler(OraExceptionHandler expHandler) {
        this.m_exceptionHandler = expHandler;
    }

    private String validateDBObjectName(String objectName, String displayName, NamedObject namedObject) {
        this.validateNotNull(objectName, displayName);
        StringTokenizer tokenizer = new StringTokenizer(objectName, ".");
        int numTokens = tokenizer.countTokens();
        if (numTokens > 3) {
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3502", null);
        }
        String[] tokens = new String[numTokens];
        int j = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[j] = tokenizer.nextToken();
            ++j;
        }
        String schemaComp = null;
        String objectComp = null;
        boolean objectCompNoDot = false;
        boolean toUpperSchemaComp = false;
        boolean toUpperObjectComp = false;
        if (numTokens == 1) {
            if (objectName.charAt(0) == '\"' && objectName.endsWith("\"")) {
                objectComp = tokens[0];
                objectCompNoDot = true;
            } else if (objectName.indexOf("\"") == -1) {
                objectComp = tokens[0];
                toUpperObjectComp = true;
            } else {
                this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3502", null);
            }
        } else if (numTokens == 2) {
            if (objectName.charAt(0) == '\"' && tokens[1].charAt(0) == '.') {
                schemaComp = tokens[0];
                objectComp = tokens[1].substring(1);
                toUpperObjectComp = true;
            } else if (objectName.endsWith("\"") && tokens[0].endsWith(".")) {
                schemaComp = tokens[0].substring(0, tokens[0].length() - 1);
                objectComp = tokens[1];
                toUpperSchemaComp = true;
                objectCompNoDot = true;
            } else {
                this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3502", null);
            }
        } else {
            if (tokens[1].compareTo(".") != 0) {
                this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3502", null);
            }
            if (objectName.charAt(0) != '\"' || !objectName.endsWith("\"")) {
                this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3502", null);
            }
            schemaComp = tokens[0];
            objectComp = tokens[2];
            objectCompNoDot = true;
        }
        String comp1 = null;
        String comp2 = null;
        if (schemaComp != null) {
            comp1 = toUpperSchemaComp ? schemaComp.toUpperCase() : schemaComp;
        }
        if (toUpperObjectComp) {
            objectComp = objectComp.toUpperCase();
        }
        if (objectCompNoDot) {
            comp2 = objectComp;
        } else {
            int dotLocation1 = objectComp.indexOf(46, 0);
            if (comp1 == null && dotLocation1 != -1) {
                int dotLocation2;
                if (dotLocation1 == 0 || dotLocation1 + 1 == objectComp.length()) {
                    this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3502", null);
                }
                if ((dotLocation2 = objectComp.indexOf(46, dotLocation1 + 1)) != -1) {
                    this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3502", null);
                }
            }
            comp2 = objectComp;
        }
        if (this.getByteLength(comp2) > 25) {
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3502", null);
        }
        String convertedName = "";
        if (comp1 != null) {
            if (this.getByteLength(comp1) > 30) {
                this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3502", null);
            }
            convertedName = toUpperSchemaComp ? convertedName + comp1 : convertedName + '\"' + comp1 + "\"";
            convertedName = convertedName + ".";
            convertedName = toUpperObjectComp ? convertedName + comp2 : convertedName + '\"' + comp2 + '\"';
        } else {
            convertedName = toUpperObjectComp ? convertedName + comp2 : convertedName + '\"' + comp2 + '\"';
        }
        return convertedName;
    }

    private String validateModelName(String modelName, String displayName) {
        if (modelName.startsWith("\"")) {
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3502", null);
        } else if (this.getByteLength(modelName) > 25) {
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3502", null);
        }
        return modelName.toUpperCase();
    }

    public String validateObjectName(String objectName, String displayName, NamedObject namedObject) {
        this.validateNotNull(objectName, displayName);
        if (namedObject.equals((Object)NamedObject.model)) {
            return this.validateModelName(objectName, displayName);
        }
        return this.prevalidateDBObjectName(objectName, displayName, namedObject);
    }

    private String prevalidateDBObjectName(String objectName, String displayName, NamedObject namedObject) {
        if (objectName.startsWith("\"") && objectName.endsWith("\"")) {
            return objectName;
        }
        return this.validateDBObjectName(objectName, displayName, namedObject);
    }

    public String validateTableColumnName(String columnName, String displayName) {
        this.validateNotNull(columnName, displayName);
        boolean convertToUpper = true;
        if (columnName.charAt(0) == '\"' && columnName.endsWith("\"")) {
            if (this.getByteLength(columnName) > 32) {
                this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3510", null);
            }
            return columnName;
        }
        if (columnName.indexOf("\"") == -1) {
            if (this.getByteLength(columnName) > 30) {
                this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3510", null);
            }
            return columnName.toUpperCase(this.m_locale);
        }
        this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3510", null);
        return null;
    }

    public void validateDataSourceURI(String uri, String displayName) {
        this.validateNotNull(uri, displayName);
        OracleDataSource dSrc = null;
        try {
            dSrc = new OracleDataSource();
        }
        catch (SQLException sqlExp) {
            return;
        }
        if (dSrc != null) {
            dSrc.setURL(uri);
        }
    }

    public void validateNotNull(Object anyObj, String displayName) {
        if (anyObj == null) {
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_NULL_ARGUMENT, new String[]{displayName}, null);
        }
        if (anyObj instanceof String && ((String)anyObj).length() == 0) {
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_STRING_ARGUMENT, new String[]{displayName}, null, "3501", new String[]{displayName});
        }
    }

    public void validateVARCHAR2(String name, String displayName) {
    }

    public void validateNonNegative(int number, String displayName) {
        this.validateNumber((double)number, 0.0, true, displayName, 1);
    }

    public void validateNonNegative(long number, String displayName) {
        this.validateNumber((double)number, 0.0, true, displayName, 2);
    }

    public void validateNonNegative(double number, String displayName) {
        this.validateNumber(number, 0.0, true, displayName, 3);
    }

    public void validateCategory(Object categoryValue, String displayName) {
        if (!(categoryValue == null || categoryValue instanceof Integer || categoryValue instanceof Double || categoryValue instanceof String || categoryValue instanceof BigDecimal || categoryValue instanceof BigInteger)) {
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new String[]{displayName}, null, "3515", new String[]{displayName});
        }
    }

    public void validateDescription(String description, String displayName) {
        if (description != null && this.getByteLength(description) > 128) {
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_STRING_TOO_LONG, new String[]{displayName, Integer.toString(128)}, null);
        }
    }

    public void validateObjectType(NamedObject objectType, String displayName, boolean fromAPI) {
        if (fromAPI) {
            this.validateNotNull(objectType, displayName);
        } else if (objectType == null) {
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT_TYPE, new String[]{displayName}, null);
        }
        boolean found = false;
        for (int i = 0; !found && i < PERSISTENCE_OPTIONS.length; ++i) {
            for (int j = 0; !found && j < OBJECT_PERSISTENCE[i].length; ++j) {
                found = objectType.name().equals(OBJECT_PERSISTENCE[i][j]);
            }
        }
        if (!found) {
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT_TYPE, new String[]{objectType.name()}, null);
        }
    }

    public void validatePercentage(double percentage, String displayName) {
        this.validateNumber(percentage, 0.0, 100.0, true, displayName);
    }

    public void validateNumber(int number, int minValue, String displayName) {
        this.validateNumber((double)number, (double)minValue, true, displayName, 1);
    }

    public void validateNumber(int number, int minValue, boolean includeEqual, String displayName) {
        this.validateNumber((double)number, (double)minValue, includeEqual, displayName, 1);
    }

    public void validateNumber(int number, int minValue, int maxValue, String displayName) {
        this.validateNumber((double)number, (double)minValue, (double)maxValue, true, displayName, 1);
    }

    public void validateNumber(int number, int minValue, int maxValue, boolean includeEqual, String displayName) {
        this.validateNumber((double)number, (double)minValue, (double)maxValue, includeEqual, displayName, 1);
    }

    public void validateNumber(int minValue, int maxValue, String minDisplayName, String maxDisplayName) {
        this.validateNumber((double)minValue, (double)maxValue, false, minDisplayName, maxDisplayName);
    }

    public void validateNumber(int minValue, int maxValue, boolean includeEqual, String minDisplayName, String maxDisplayName) {
        this.validateNumber((double)minValue, (double)maxValue, includeEqual, minDisplayName, maxDisplayName);
    }

    public void validateNumber(int number, int minValue, int maxValue, boolean includeMin, boolean includeMax, String displayName) {
        this.validateNumber(number, minValue, maxValue, includeMin, includeMax, displayName, 1);
    }

    public void validateNumber(double number, double minValue, String displayName) {
        this.validateNumber(number, minValue, true, displayName, 3);
    }

    public void validateNumber(double number, double minValue, boolean includeEqual, String displayName) {
        this.validateNumber(number, minValue, includeEqual, displayName, 3);
    }

    private void validateNumber(double number, double minValue, boolean includeEqual, String displayName, int numberType) {
        boolean bFailed;
        boolean bl = bFailed = includeEqual && number < minValue || !includeEqual && number <= minValue;
        if (bFailed) {
            String numType = Double.toString(minValue);
            if (numberType == 1) {
                numType = Integer.toString((int)minValue);
            } else if (numberType == 2) {
                numType = Long.toString((long)minValue);
            }
            Object[] params = new String[]{displayName, numType};
            String vendorCode = "3512";
            if (!includeEqual) {
                vendorCode = "3513";
            }
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{displayName}, null, vendorCode, params);
        }
    }

    public void validateNumber(double number, double minValue, double maxValue, String displayName) {
        this.validateNumber(number, minValue, maxValue, true, displayName, 3);
    }

    public void validateNumber(double number, double minValue, double maxValue, boolean includeEqual, String displayName) {
        this.validateNumber(number, minValue, maxValue, includeEqual, displayName, 3);
    }

    private void validateNumber(double number, double minValue, double maxValue, boolean includeEqual, String displayName, int numberType) {
        boolean bFailed;
        boolean bl = bFailed = includeEqual && (number < minValue || number > maxValue) || !includeEqual && (number <= minValue || number >= maxValue);
        if (bFailed) {
            String minVal = Double.toString(minValue);
            String maxVal = Double.toString(maxValue);
            if (numberType == 1) {
                minVal = Integer.toString((int)minValue);
                maxVal = Integer.toString((int)maxValue);
            } else if (numberType == 2) {
                minVal = Long.toString((long)minValue);
                maxVal = Long.toString((long)maxValue);
            }
            Object[] params = new String[]{displayName, minVal, maxVal};
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{displayName}, null, "3514", params);
        }
    }

    public void validateNumber(double minValue, double maxValue, String minDisplayName, String maxDisplayName) {
        this.validateNumber(minValue, maxValue, false, minDisplayName, maxDisplayName);
    }

    public void validateNumber(double minValue, double maxValue, boolean includeEqual, String minDisplayName, String maxDisplayName) {
        boolean bFailed;
        boolean bl = bFailed = includeEqual && maxValue < minValue || !includeEqual && maxValue <= minValue;
        if (bFailed) {
            Object[] params = new String[]{maxDisplayName, minDisplayName};
            String vendorCode = "3513";
            if (includeEqual) {
                vendorCode = "3512";
            }
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{minDisplayName}, null, vendorCode, params);
        }
    }

    public void validateNumber(double number, double minValue, double maxValue, boolean includeMin, boolean includeMax, String displayName) {
        this.validateNumber(number, minValue, maxValue, includeMin, includeMax, displayName, 3);
    }

    private void validateNumber(double number, double minValue, double maxValue, boolean includeMin, boolean includeMax, String displayName, int numberType) {
        try {
            this.validateNumber(number, minValue, includeMin, displayName, numberType);
            if (includeMax && number > maxValue || !includeMax && number >= maxValue) {
                this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{displayName}, null);
            }
        }
        catch (JDMIllegalArgumentException illegalArgs) {
            String minVal = Double.toString(minValue);
            String maxVal = Double.toString(maxValue);
            if (numberType == 1) {
                minVal = Integer.toString((int)minValue);
                maxVal = Integer.toString((int)maxValue);
            } else if (numberType == 2) {
                minVal = Long.toString((long)minValue);
                maxVal = Long.toString((long)maxValue);
            }
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{displayName}, null, "3514", new String[]{displayName, minVal, maxVal});
        }
    }

    public void validateNumber(long number, long minValue, String displayName) {
        this.validateNumber((double)number, (double)minValue, true, displayName, 2);
    }

    public void validateNumber(long number, long minValue, boolean includeEual, String displayName) {
        this.validateNumber((double)number, (double)minValue, includeEual, displayName, 2);
    }

    public void validateNumber(long number, long minValue, long maxValue, String displayName) {
        this.validateNumber((double)number, (double)minValue, (double)maxValue, true, displayName, 2);
    }

    public void validateNumber(long number, long minValue, long maxValue, boolean includeEual, String displayName) {
        this.validateNumber((double)number, (double)minValue, (double)maxValue, includeEual, displayName, 2);
    }

    public void validateNumber(long minValue, long maxValue, String minDisplayName, String maxDisplayName) {
        this.validateNumber((double)minValue, (double)maxValue, false, minDisplayName, maxDisplayName);
    }

    public void validateNumber(long minValue, long maxValue, boolean includeEqual, String minDisplayName, String maxDisplayName) {
        this.validateNumber((double)minValue, (double)maxValue, includeEqual, minDisplayName, maxDisplayName);
    }

    public void validateNumber(long number, long minValue, long maxValue, boolean includeMin, boolean includeMax, String displayName) {
        this.validateNumber(number, minValue, maxValue, includeMin, includeMax, displayName, 2);
    }

    public void validateArray(Object[] array, String displayName) {
        this.validateNotNull(array, displayName);
        if (array.length > 1000000) {
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_ARRAY_SIZE_EXCEEDED, new String[]{displayName, Integer.toString(1000000)}, null);
        }
    }

    public void validateArrays(Object[] array1, String displayName1, Object[] array2, String displayName2) {
        this.validateArray(array1, displayName1);
        this.validateArray(array2, displayName2);
        if (array1.length != array1.length) {
            this.m_exceptionHandler.createRuntimeException(OraJDMBundleKeys.JDMR_ARRAY_MISMATCH, new String[]{displayName1, displayName2}, null);
        }
    }

    private int getByteLength(String name) {
        if (this.m_javaCharSet == null) {
            return name.getBytes().length;
        }
        try {
            return name.getBytes(this.m_javaCharSet).length;
        }
        catch (Exception e) {
            return name.getBytes().length;
        }
    }
}

