/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.resource;

import java.sql.Connection;
import javax.datamining.JDMException;
import javax.datamining.JDMUnsupportedFeatureException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningFunction;
import javax.datamining.MiningTask;
import javax.datamining.NamedObject;
import javax.datamining.resource.PersistenceOption;
import oracle.dmt.jdm.resource.OraCapabilities;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.resource.OraSupportManager;

public class OraSupportManagerImpl
extends OraCapabilities
implements OraSupportManager {
    private OraConnection m_dmeConn = null;
    private Connection m_dbConn = null;

    OraSupportManagerImpl(OraConnection dmeConn) {
        this.m_dmeConn = dmeConn;
        this.m_dbConn = dmeConn.getDatabaseConnection();
    }

    public MiningFunction[] getSupportedFunctions() {
        MiningFunction[] supportedFunctions = new MiningFunction[SUPPORTRED_FUNCTIONS.length];
        for (int i = 0; i < SUPPORTRED_FUNCTIONS.length; ++i) {
            try {
                supportedFunctions[i] = MiningFunction.valueOf((String)SUPPORTRED_FUNCTIONS[i]);
                continue;
            }
            catch (JDMException jDMException) {
                // empty catch block
            }
        }
        return supportedFunctions;
    }

    public MiningAlgorithm[] getSupportedAlgorithms(MiningFunction function) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(function, "function");
        int fncIndex = this.getIndex(SUPPORTRED_FUNCTIONS, function.name());
        if (SUPPORTRED_FUNC_ALGORITHMS[fncIndex].length == 0) {
            return null;
        }
        MiningAlgorithm[] supportedAlgorithms = new MiningAlgorithm[SUPPORTRED_FUNC_ALGORITHMS[fncIndex].length];
        for (int i = 0; i < SUPPORTRED_FUNC_ALGORITHMS[fncIndex].length; ++i) {
            supportedAlgorithms[i] = MiningAlgorithm.valueOf((String)SUPPORTRED_FUNC_ALGORITHMS[fncIndex][i]);
        }
        return supportedAlgorithms;
    }

    public boolean supportsCapability(MiningFunction function, MiningAlgorithm algorithm, MiningTask taskType) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(function, "function");
        boolean supported = false;
        int fncIndex = 0;
        try {
            fncIndex = this.getIndex(SUPPORTRED_FUNCTIONS, function.name());
        }
        catch (JDMUnsupportedFeatureException jdmFeatureExp) {
            return supported;
        }
        if (algorithm == null && taskType == null) {
            supported = true;
        } else if (algorithm == null && taskType != null) {
            supported = this.getMatch(SUPPORTED_FUNC_TASKS[fncIndex], taskType.name());
        } else if (algorithm != null && taskType == null) {
            supported = this.getMatch(SUPPORTRED_FUNC_ALGORITHMS[fncIndex], algorithm.name());
        } else {
            boolean funcAlgoSupported = false;
            funcAlgoSupported = this.supportsCapability(function, algorithm, null);
            if (funcAlgoSupported) {
                int algoIndex = this.getIndex(SUPPORTED_ALGO_TASKS_INDEX, algorithm.name());
                supported = this.getMatch(SUPPORTRED_ALGO_TASKS[algoIndex], taskType.name());
            }
        }
        return supported;
    }

    public boolean supportsCapability(NamedObject objectType, PersistenceOption persistenceOption) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(objectType, "objectType");
        this.m_dmeConn.getValidationHandler().validateNotNull(persistenceOption, "persistenceOption");
        int optionIndex = this.getIndex(PERSISTENCE_OPTIONS, persistenceOption.name());
        return this.getMatch(OBJECT_PERSISTENCE[optionIndex], objectType.name());
    }

    public NamedObject[] getNamedObjects(PersistenceOption persistenceOption) {
        this.m_dmeConn.getValidationHandler().validateNotNull(persistenceOption, "persistenceOption");
        int optionIndex = this.getIndex(PERSISTENCE_OPTIONS, persistenceOption.name());
        NamedObject[] supportedObjects = new NamedObject[OBJECT_PERSISTENCE[optionIndex].length];
        for (int i = 0; i < OBJECT_PERSISTENCE[optionIndex].length; ++i) {
            try {
                supportedObjects[i] = NamedObject.valueOf((String)OBJECT_PERSISTENCE[optionIndex][i]);
                continue;
            }
            catch (JDMException jdmExp) {
                // empty catch block
            }
        }
        return supportedObjects;
    }
}

