/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.resource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.datamining.Enum;
import javax.datamining.ExecutionHandle;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningFunction;
import javax.datamining.MiningObject;
import javax.datamining.MiningTask;
import javax.datamining.NamedObject;
import javax.datamining.resource.PersistenceOption;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.OraMiningFunction;
import oracle.dmt.jdm.OraMiningObject;
import oracle.dmt.jdm.OraMiningTask;
import oracle.dmt.jdm.OraNamedObject;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.base.OraBuildSettings;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.base.OraTask;
import oracle.dmt.jdm.data.OraPhysicalDataSet;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.resource.OraLookupManager;
import oracle.dmt.jdm.supervised.OraTestMetrics;
import oracle.dmt.jdm.supervised.classification.OraCostMatrix;
import oracle.dmt.jdm.task.apply.OraApplySettings;
import oracle.dmt.jdm.transform.OraTransformationSequenceImpl;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraLookupManagerImpl
implements OraLookupManager {
    private OraConnection m_dmeConn = null;
    Connection m_dbConn = null;

    OraLookupManagerImpl(OraConnection dmeConn) {
        this.m_dmeConn = dmeConn;
        this.m_dbConn = dmeConn.getDatabaseConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MiningObject retrieveObject(String name, NamedObject objectType) throws JDMException {
        if (!this.m_dmeConn.doesObjectExist(name, objectType)) {
            this.m_dmeConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new String[]{objectType.name(), name}, null);
            return null;
        }
        Logger logger = this.m_dmeConn.getLogger();
        String logMessage = "OraLookupManagerImpl.retrieveObject(name " + name + "," + "objectType " + (objectType == null ? null : objectType.name()) + ")";
        long startTime = System.currentTimeMillis();
        this.m_dmeConn.getValidationHandler().validateNotNull(name, "name");
        OraMiningObject objectImpl = null;
        String objName = this.m_dmeConn.getValidationHandler().validateObjectName(name, "name", objectType);
        try {
            HashMap repository = this.m_dmeConn.getRepository(objectType);
            if (repository == null) {
                if (objectType.equals((Object)NamedObject.buildSettings)) {
                    return OraBuildSettings.retrieveObjectFromDatabase(this.m_dmeConn, objName, null);
                }
                if (objectType.equals((Object)NamedObject.model)) {
                    return OraModel.retrieveObjectFromDatabase(this.m_dmeConn, objName);
                }
                if (objectType.equals((Object)NamedObject.task)) {
                    return OraTask.retrieveObjectFromDatabase(this.m_dmeConn, objName);
                }
                if (objectType.equals((Object)NamedObject.testMetrics)) {
                    return OraTestMetrics.retrieveObjectFromDatabase(this.m_dmeConn, objName);
                }
                if (objectType.equals((Object)NamedObject.costMatrix)) {
                    return OraCostMatrix.retrieveObjectFromDatabase(this.m_dmeConn, objName);
                }
            } else {
                objectImpl = (OraMiningObject)repository.get(name);
                if (objectImpl != null) {
                    // empty if block
                }
            }
        }
        catch (SQLException sqlExp) {
            this.m_dmeConn.createException("2000", new String[]{"retrieveObject"}, sqlExp);
        }
        long endTime = System.currentTimeMillis();
        if (logger != null) {
            logMessage = logMessage + "\n" + "Execution duration: " + (endTime - startTime) / 1000L + " seconds";
            logger.finest(logMessage);
        }
        return objectImpl;
    }

    public MiningObject retrieveObject(String objectIdentifier) throws JDMException {
        Object object = null;
        this.m_dmeConn.getValidationHandler().validateNotNull(objectIdentifier, "objectIdentifier");
        StringTokenizer tokens = new StringTokenizer(objectIdentifier, "_");
        if (tokens.countTokens() < 2) {
            this.m_dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new Object[]{objectIdentifier}, null);
        }
        String[] objectTypeAndName = objectIdentifier.split("_", 2);
        NamedObject objType = NamedObject.valueOf((String)objectTypeAndName[0]);
        return this.retrieveObject(objectTypeAndName[1], objType);
    }

    public Collection retrieveObjects(Date createdAfter, Date createdBefore, NamedObject objectType) throws JDMException {
        return this.retrieveObjects(objectType, null, createdAfter, createdBefore);
    }

    public Collection retrieveObjects(NamedObject objectType, Enum minorType, Date createdAfter, Date createdBefore) throws JDMException {
        Logger logger = this.m_dmeConn.getLogger();
        String logMessage = "OraLookupManagerImpl.retrieveObjects(objectType " + (objectType == null ? null : objectType.name()) + "," + "minorType " + (minorType == null ? null : minorType.name()) + "," + "createdAfter " + createdAfter + "," + "createdBefore " + createdBefore + ")";
        long startTime = System.currentTimeMillis();
        Vector<Object> rerturnedObjects = new Vector<Object>();
        try {
            if (objectType == null) {
                NamedObject[] namedObjects = this.m_dmeConn.getNamedObjects(PersistenceOption.transientObject);
                for (int n = 0; n < namedObjects.length; ++n) {
                    HashMap repository = this.m_dmeConn.getRepository(namedObjects[n]);
                    Collection objects = repository.values();
                    Object[] objectsArray = objects.toArray();
                    boolean addToList = false;
                    for (int i = 0; i < objectsArray.length; ++i) {
                        addToList = false;
                        if (createdAfter == null & createdBefore == null) {
                            addToList = true;
                        } else if (createdAfter != null && ((OraMiningObject)objectsArray[i]).getCreationDate().after(createdAfter) & createdBefore == null) {
                            addToList = true;
                        } else if (createdAfter == null & createdBefore != null && ((OraMiningObject)objectsArray[i]).getCreationDate().before(createdBefore)) {
                            addToList = true;
                        } else if (createdAfter != null && ((OraMiningObject)objectsArray[i]).getCreationDate().after(createdAfter) & createdBefore != null && ((OraMiningObject)objectsArray[i]).getCreationDate().before(createdBefore)) {
                            addToList = true;
                        }
                        if (objectsArray[i] instanceof OraApplySettings & minorType != null && ((OraApplySettings)objectsArray[i]).getFunction() == minorType) {
                            addToList &= true;
                        } else if (objectsArray[i] instanceof OraApplySettings & minorType != null && ((OraApplySettings)objectsArray[i]).getFunction() != minorType) {
                            addToList &= false;
                        }
                        if (!addToList) continue;
                        rerturnedObjects.add(objectsArray[i]);
                    }
                }
                Collection objects = null;
                objects = OraBuildSettings.retrieveObjectsFromDatabase(this.m_dmeConn, createdAfter, createdBefore, minorType);
                if (objects != null && objects.size() > 0) {
                    rerturnedObjects.addAll(objects);
                }
                if ((objects = OraModel.retrieveObjectsFromDatabase(this.m_dmeConn, createdAfter, createdBefore, minorType)) != null && objects.size() > 0) {
                    rerturnedObjects.addAll(objects);
                }
                if ((objects = OraTask.retrieveObjectsFromDatabase(this.m_dmeConn, createdAfter, createdBefore, minorType)) != null && objects.size() > 0) {
                    rerturnedObjects.addAll(objects);
                }
                if ((objects = OraTestMetrics.retrieveObjectsFromDatabase(this.m_dmeConn, createdAfter, createdBefore)) != null && objects.size() > 0) {
                    rerturnedObjects.addAll(objects);
                }
                if ((objects = OraCostMatrix.retrieveObjectsFromDatabase(this.m_dmeConn, createdAfter, createdBefore)) != null && objects.size() > 0) {
                    rerturnedObjects.addAll(objects);
                }
            } else {
                HashMap repository = this.m_dmeConn.getRepository(objectType);
                if (repository == null) {
                    if (objectType.equals((Object)NamedObject.buildSettings)) {
                        return OraBuildSettings.retrieveObjectsFromDatabase(this.m_dmeConn, createdAfter, createdBefore, minorType);
                    }
                    if (objectType.equals((Object)NamedObject.model)) {
                        return OraModel.retrieveObjectsFromDatabase(this.m_dmeConn, createdAfter, createdBefore, minorType);
                    }
                    if (objectType.equals((Object)NamedObject.task)) {
                        return OraTask.retrieveObjectsFromDatabase(this.m_dmeConn, createdAfter, createdBefore, minorType);
                    }
                    if (objectType.equals((Object)NamedObject.testMetrics)) {
                        return OraTestMetrics.retrieveObjectsFromDatabase(this.m_dmeConn, createdAfter, createdBefore);
                    }
                    if (objectType.equals((Object)NamedObject.costMatrix)) {
                        return OraCostMatrix.retrieveObjectsFromDatabase(this.m_dmeConn, createdAfter, createdBefore);
                    }
                } else {
                    Collection objects = repository.values();
                    if (objects != null) {
                        Object[] objectsArray = objects.toArray();
                        boolean addToList = false;
                        for (int i = 0; i < objectsArray.length; ++i) {
                            addToList = false;
                            if (objectType == NamedObject.physicalDataSet) {
                                if (objectsArray[i] instanceof OraPhysicalDataSet & createdAfter == null & createdBefore == null) {
                                    addToList = true;
                                } else if (objectsArray[i] instanceof OraPhysicalDataSet & createdAfter != null && ((OraPhysicalDataSet)objectsArray[i]).getCreationDate().after(createdAfter) & createdBefore == null) {
                                    addToList = true;
                                } else if (objectsArray[i] instanceof OraPhysicalDataSet & createdAfter == null & createdBefore != null && ((OraPhysicalDataSet)objectsArray[i]).getCreationDate().before(createdBefore)) {
                                    addToList = true;
                                } else if (objectsArray[i] instanceof OraPhysicalDataSet & createdAfter != null && ((OraPhysicalDataSet)objectsArray[i]).getCreationDate().after(createdAfter) & createdBefore != null && ((OraPhysicalDataSet)objectsArray[i]).getCreationDate().before(createdBefore)) {
                                    addToList = true;
                                }
                            } else if (objectType == NamedObject.applySettings) {
                                if (objectsArray[i] instanceof OraApplySettings & createdAfter == null & createdBefore == null) {
                                    addToList = true;
                                } else if (objectsArray[i] instanceof OraApplySettings & createdAfter != null && ((OraApplySettings)objectsArray[i]).getCreationDate().after(createdAfter) & createdBefore == null) {
                                    addToList = true;
                                } else if (objectsArray[i] instanceof OraApplySettings & createdAfter == null & createdBefore != null && ((OraApplySettings)objectsArray[i]).getCreationDate().before(createdBefore)) {
                                    addToList = true;
                                } else if (objectsArray[i] instanceof OraApplySettings & createdAfter != null && ((OraApplySettings)objectsArray[i]).getCreationDate().after(createdAfter) & createdBefore != null && ((OraApplySettings)objectsArray[i]).getCreationDate().before(createdBefore)) {
                                    addToList = true;
                                }
                            }
                            if (!addToList) continue;
                            rerturnedObjects.add(objectsArray[i]);
                        }
                    }
                }
            }
        }
        catch (Exception anyExp) {
            this.m_dmeConn.createException("2000", new String[]{"retrieveObjects"}, anyExp);
        }
        long endTime = System.currentTimeMillis();
        if (logger != null) {
            logMessage = logMessage + "\n" + "Execution duration: " + (endTime - startTime) / 1000L + " seconds";
            logger.finest(logMessage);
        }
        return rerturnedObjects;
    }

    public Collection getObjectNames(NamedObject objectType, Enum minorType, Date createdAfter, Date createdBefore) throws JDMException {
        Logger logger = this.m_dmeConn.getLogger();
        String logMessage = "OraLookupManagerImpl.getObjectNames(objectType " + (objectType == null ? null : objectType.name()) + "," + "minorType " + (minorType == null ? null : minorType.name()) + "," + "createdAfter " + createdAfter + "," + "createdBefore " + createdBefore + ")";
        long startTime = System.currentTimeMillis();
        Vector<String> rerturnedNames = new Vector<String>();
        Collection objects = this.retrieveObjects(objectType, minorType, createdAfter, createdBefore);
        if (objects != null) {
            for (MiningObject miningObj : objects) {
                rerturnedNames.add(miningObj.getName());
            }
        }
        long endTime = System.currentTimeMillis();
        if (logger != null) {
            logMessage = logMessage + "\n" + "Execution duration: " + (endTime - startTime) / 1000L + " seconds";
            logger.finest(logMessage);
        }
        return rerturnedNames;
    }

    public Collection getObjectNames(Date createdAfter, Date createdBefore, NamedObject objectType) throws JDMException {
        return this.getObjectNames(objectType, null, createdAfter, createdBefore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getObjectNames(NamedObject objectType) throws JDMException {
        Logger logger = this.m_dmeConn.getLogger();
        String logMessage = "OraLookupManagerImpl.getObjectNames(objectType " + (objectType == null ? null : objectType.name()) + ")";
        long startTime = System.currentTimeMillis();
        Vector<String> rerturnedNames = new Vector<String>();
        NamedObject[] namedObjects = this.m_dmeConn.getNamedObjects(PersistenceOption.transientObject);
        for (int n = 0; n < namedObjects.length; ++n) {
            HashMap repository = this.m_dmeConn.getRepository(namedObjects[n]);
            Collection objects = repository.values();
            Object[] objectsArray = objects.toArray();
            for (int i = 0; i < objectsArray.length; ++i) {
                if (objectType == null) {
                    rerturnedNames.add(((OraMiningObject)objectsArray[i]).getName());
                    continue;
                }
                if (!(objectType != null & objectType == namedObjects[n])) continue;
                rerturnedNames.add(((OraMiningObject)objectsArray[i]).getName());
            }
        }
        String sqlSpec = "";
        if (objectType == null | objectType != null & objectType == NamedObject.buildSettings) {
            if (sqlSpec != "") {
                sqlSpec = sqlSpec + "UNION ALL  ";
            }
            String BS_COMMENTS_PREFIX = "BS_";
            sqlSpec = sqlSpec + "SELECT T.TABLE_NAME name from ALL_TABLES T, " + "ALL_TAB_COMMENTS C " + "WHERE C.TABLE_NAME = T.TABLE_NAME AND C.COMMENTS like '" + BS_COMMENTS_PREFIX + "%' ";
        }
        if (objectType == null | objectType != null & objectType == NamedObject.model) {
            if (sqlSpec != "") {
                sqlSpec = sqlSpec + "UNION ALL ";
            }
            sqlSpec = this.m_dmeConn.is102() ? sqlSpec + "SELECT name FROM dm_user_models " : sqlSpec + "SELECT model_name FROM user_mining_models ";
        }
        if (objectType == null | objectType != null & objectType == NamedObject.task) {
            if (sqlSpec != "") {
                sqlSpec = sqlSpec + "UNION ALL  ";
            }
            sqlSpec = sqlSpec + "SELECT job_name name FROM user_scheduler_jobs ";
        }
        if (objectType == null | objectType != null & objectType == NamedObject.testMetrics) {
            String TM_COMMENTS_PREFIX = "TM_";
            if (sqlSpec != "") {
                sqlSpec = sqlSpec + "UNION ALL  ";
            }
            sqlSpec = sqlSpec + "SELECT T.TABLE_NAME name from ALL_TABLES T, " + "ALL_TAB_COMMENTS C " + "WHERE C.TABLE_NAME = T.TABLE_NAME AND C.COMMENTS like '" + TM_COMMENTS_PREFIX + "%' ";
        }
        if (objectType == null | objectType != null & objectType == NamedObject.costMatrix) {
            String CM_COMMENTS_PREFIX = "CM_";
            if (sqlSpec != "") {
                sqlSpec = sqlSpec + "UNION ALL  ";
            }
            sqlSpec = sqlSpec + "SELECT T.TABLE_NAME name from ALL_TABLES T, " + "ALL_TAB_COMMENTS C " + "WHERE C.TABLE_NAME = T.TABLE_NAME AND C.COMMENTS like '" + CM_COMMENTS_PREFIX + "%'";
        }
        if (sqlSpec != "") {
            PreparedStatement ps = null;
            ResultSet rs = null;
            String objectName = null;
            try {
                ps = this.m_dbConn.prepareStatement(sqlSpec);
                rs = ps.executeQuery();
                while (rs.next()) {
                    objectName = rs.getString("NAME");
                    rerturnedNames.add(objectName);
                }
            }
            catch (SQLException sqlExp) {
                this.m_dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, new Object[]{sqlSpec}, sqlExp, OraJDMBundleKeys.JDM_CONNECTION_FAILURE, null);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e1) {}
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception e2) {}
            }
        }
        long endTime = System.currentTimeMillis();
        if (logger != null) {
            logMessage = logMessage + "\n" + "Execution duration: " + (endTime - startTime) / 1000L + " seconds";
            logger.finest(logMessage);
        }
        return rerturnedNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getModelNames(MiningFunction function, MiningAlgorithm algorithm, Date createdAfter, Date createdBefore) {
        Logger logger = this.m_dmeConn.getLogger();
        String logMessage = "OraLookupManagerImpl.getModelNames(function " + (function == null ? null : function.name()) + "," + "algorithm " + (algorithm == null ? null : algorithm.name()) + "," + "createdAfter " + createdAfter + "," + "createdBefore " + createdBefore + ")";
        long startTime = System.currentTimeMillis();
        Vector<String> rerturnedNames = new Vector<String>();
        String param1 = "";
        String param2 = "";
        String param3 = "";
        String param4 = "";
        String sqlSpec = "";
        sqlSpec = this.m_dmeConn.is102() ? "SELECT name FROM dm_user_models {0} {1} {2} {3}ORDER BY creation_date ASC " : "SELECT MODEL_NAME FROM USER_MINING_MODELS {0} {1} {2} {3} ORDER BY CREATION_DATE ASC ";
        boolean hasCondition = false;
        if (function != null) {
            param1 = hasCondition ? "AND " : "WHERE ";
            String funcName = OraPLSQLMappings.getPLSQLConstant(function);
            param1 = this.m_dmeConn.is102() ? param1 + "function_name='" + funcName + "' " : param1 + "mining_function='" + funcName + "' ";
            hasCondition = true;
        }
        if (algorithm != null) {
            param2 = hasCondition ? "AND " : "WHERE ";
            String algoName = OraPLSQLMappings.getDBDictionaryName(algorithm);
            param2 = algoName != null ? (this.m_dmeConn.is102() ? param2 + "algorithm_name='" + algoName.toUpperCase() + "' " : param2 + "algorithm='" + algoName.toUpperCase() + "' ") : (this.m_dmeConn.is102() ? param2 + "algorithm_name is NULL" : param2 + "algorithm is NULL ");
            hasCondition = true;
        }
        if (createdAfter != null) {
            param3 = hasCondition ? "AND " : "WHERE ";
            param3 = param3 + " CREATION_DATE > ? ";
            hasCondition = true;
        }
        if (createdBefore != null) {
            param4 = hasCondition ? "AND " : "WHERE ";
            param4 = param4 + " CREATION_DATE < ? ";
            hasCondition = true;
        }
        sqlSpec = MessageFormat.format(sqlSpec, param1, param2, param3, param4);
        PreparedStatement ps = null;
        ResultSet rs = null;
        String objectName = null;
        try {
            ps = this.m_dbConn.prepareStatement(sqlSpec);
            int i = 1;
            if (createdAfter != null) {
                ps.setTimestamp(i++, new Timestamp(createdAfter.getTime()));
            }
            if (createdBefore != null) {
                ps.setTimestamp(i, new Timestamp(createdBefore.getTime()));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                objectName = rs.getString(1);
                rerturnedNames.add(objectName);
            }
        }
        catch (SQLException sqlExp) {
            this.m_dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, new Object[]{sqlSpec}, sqlExp, OraJDMBundleKeys.JDM_CONNECTION_FAILURE, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e2) {}
        }
        long endTime = System.currentTimeMillis();
        if (logger != null) {
            logMessage = logMessage + "\n" + "Execution duration: " + (endTime - startTime) / 1000L + " seconds";
            logger.finest(logMessage);
        }
        return rerturnedNames;
    }

    public Date getCreationDate(String name, NamedObject objectType) throws JDMException {
        Logger logger = this.m_dmeConn.getLogger();
        String logMessage = "OraLookupManagerImpl.getCreationDate(name " + name + "," + "objectType " + (objectType == null ? null : objectType.name()) + ")";
        long startTime = System.currentTimeMillis();
        OraMiningObject objectImpl = null;
        Date objectDate = null;
        objectImpl = (OraMiningObject)this.retrieveObject(name, objectType);
        if (objectImpl != null) {
            objectDate = objectImpl.getCreationDate();
        }
        long endTime = System.currentTimeMillis();
        if (logger != null) {
            logMessage = logMessage + "\n" + "Execution duration: " + (endTime - startTime) / 1000L + " seconds";
            logger.finest(logMessage);
        }
        return objectDate;
    }

    public Collection retrieveModelObjects(MiningFunction function, MiningAlgorithm algorithm, Date createdAfter, Date createdBefore) throws JDMException {
        Vector<Object> modelObjects = null;
        Logger logger = this.m_dmeConn.getLogger();
        String logMessage = "OraLookupManagerImpl.retrieveModelObjects(function " + (function == null ? null : function.name()) + "," + "algorithm " + (algorithm == null ? null : algorithm.name()) + "," + "createdAfter " + createdAfter + "," + "createdBefore " + createdBefore + ")";
        long startTime = System.currentTimeMillis();
        modelObjects = this.retrieveObjects(NamedObject.model, (Enum)function, createdAfter, createdBefore);
        if (algorithm != null) {
            MiningAlgorithm buildAlgorithm = null;
            Vector<Object> filteredModelObjects = new Vector<Object>();
            Object[] objectArray = modelObjects.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                buildAlgorithm = ((OraModel)objectArray[i]).getMiningAlgorithm();
                if (buildAlgorithm != algorithm) continue;
                filteredModelObjects.add(objectArray[i]);
            }
            modelObjects = filteredModelObjects;
        }
        long endTime = System.currentTimeMillis();
        if (logger != null) {
            logMessage = logMessage + "\n" + "Execution duration: " + (endTime - startTime) / 1000L + " seconds";
            logger.finest(logMessage);
        }
        return modelObjects;
    }

    public ExecutionHandle getLastExecutionHandle(String taskName) throws JDMException {
        Object executionHandle = null;
        OraTask task = (OraTask)this.retrieveObject(taskName, NamedObject.task);
        return task.getExecutionHandle();
    }

    public ExecutionHandle[] getExecutionHandles(String taskName) throws JDMException {
        ExecutionHandle[] executionHandles = null;
        executionHandles = new ExecutionHandle[]{this.getLastExecutionHandle(taskName)};
        return executionHandles;
    }

    public boolean doesObjectExist(String objectName, NamedObject objectType) throws JDMException {
        Logger logger = this.m_dmeConn.getLogger();
        String logMessage = "OraLookupManagerImpl.doesObjectExist(objectName " + objectName + "," + "objectType " + (objectType == null ? null : objectType.name()) + ")";
        long startTime = System.currentTimeMillis();
        boolean doesObjectExist = false;
        try {
            HashMap repository = this.m_dmeConn.getRepository(objectType);
            if (repository == null) {
                String objName = this.m_dmeConn.getValidationHandler().validateObjectName(objectName, "objectName", objectType);
                objName = OraStringUtils.processQuotedName(objName);
                if (objectType.equals((Object)NamedObject.buildSettings)) {
                    doesObjectExist = OraBuildSettings.doesObjectExistInDatabase(this.m_dmeConn, objName);
                } else if (objectType.equals((Object)NamedObject.model)) {
                    doesObjectExist = OraModel.doesObjectExistInDatabase(this.m_dmeConn, objName);
                } else if (objectType.equals((Object)NamedObject.task)) {
                    doesObjectExist = OraTask.doesObjectExistInDatabase(this.m_dmeConn, objName);
                } else if (objectType.equals((Object)NamedObject.testMetrics)) {
                    doesObjectExist = OraTestMetrics.doesObjectExistInDatabase(this.m_dmeConn, objName);
                } else if (objectType.equals((Object)NamedObject.costMatrix)) {
                    doesObjectExist = OraCostMatrix.doesObjectExistInDatabase(this.m_dmeConn, objName);
                } else if (objectType.equals((Object)OraNamedObject.transformationSequence)) {
                    doesObjectExist = OraTransformationSequenceImpl.doesObjectExistInDatabase(this.m_dmeConn, objName);
                }
            } else {
                doesObjectExist = repository.containsKey(objectName);
            }
        }
        catch (SQLException sqlExp) {
            this.m_dmeConn.createException("2000", new String[]{"doesObjectExist"}, sqlExp);
        }
        long endTime = System.currentTimeMillis();
        if (logger != null) {
            logMessage = logMessage + "\n" + "Execution duration: " + (endTime - startTime) / 1000L + " seconds";
            logger.finest(logMessage);
        }
        return doesObjectExist;
    }

    public ResultSet getObjectNames(String schemaPattern, NamedObject objectType, String objectNamePattern, Enum minorType_1, Enum minorType_2) {
        if (this.m_dmeConn.is102()) {
            this.m_dmeConn.unsupported("getObjectNames");
        }
        String owner = schemaPattern == null ? null : this.m_dmeConn.getValidationHandler().validateTableColumnName(schemaPattern, "schemaPattern");
        String objectName = objectNamePattern == null && objectType == null ? null : this.m_dmeConn.getValidationHandler().validateObjectName(objectNamePattern, "objectNamePattern", objectType);
        String col_1_schema_name = " SCHEMA_NAME ";
        String col_2_type = " TYPE ";
        String col_3_name = " NAME ";
        String col_4_minor_type_1 = " MINOR_TYPE_1 ";
        String col_5_minor_type_2 = " MINOR_TYPE_2 ";
        String col_6_creation_date = " CREATION_DATE ";
        String col_7_description = " DESCRIPTION ";
        StringBuffer sqlQry = new StringBuffer();
        ArrayList<String> paramList = new ArrayList<String>();
        if (NamedObject.buildSettings.equals((Object)objectType) || objectType == null) {
            sqlQry.append("select t2.owner as " + col_1_schema_name).append(", '" + NamedObject.buildSettings.name() + "' as " + col_2_type).append(", t2.table_name as " + col_3_name).append(", CASE REGEXP_INSTR(t2.comments, '(;Description:)') WHEN 0 THEN substr(t2.comments, 4, length(t2.comments)) ELSE substr(t2.comments, 4, (REGEXP_INSTR(t2.comments, '(;Description:)')-4)) END AS " + col_4_minor_type_1).append(", NULL AS " + col_5_minor_type_2).append(", t1.created as " + col_6_creation_date).append(", CASE REGEXP_INSTR(t2.comments, '(;Description:)') WHEN 0 THEN NULL ELSE substr(t2.comments, (REGEXP_INSTR(t2.comments, '(;Description:)')+13), length(t2.comments)) END as " + col_7_description).append(" from ALL_OBJECTS t1, ALL_TAB_COMMENTS t2 WHERE ").append(owner == null ? "" : " t1.owner like ? and ").append(objectName == null ? "" : " t1.object_name like ? and ").append(" t1.object_name = t2.table_name and t2.comments like 'BS_%' ").append(objectType != null && minorType_1 != null && minorType_1 instanceof MiningFunction ? " and CASE REGEXP_INSTR(t2.comments, '(;Description:)') WHEN 0 THEN substr(t2.comments, 4, length(t2.comments)) ELSE substr(t2.comments, 4, (REGEXP_INSTR(t2.comments, '(;Description:)')-4)) END = ? " : "").append(objectType == null ? " UNION ALL " : "");
            if (owner != null) {
                paramList.add(owner);
            }
            if (objectName != null) {
                paramList.add(objectName);
            }
            if (objectType != null && minorType_1 != null && minorType_1 instanceof MiningFunction) {
                paramList.add(minorType_1.name());
            }
        }
        if (NamedObject.costMatrix.equals((Object)objectType) || objectType == null) {
            sqlQry.append("select t2.owner as " + col_1_schema_name).append(", '" + NamedObject.costMatrix.name() + "' as " + col_2_type).append(", t2.table_name as " + col_3_name).append(", NULL AS " + col_4_minor_type_1).append(", NULL AS " + col_5_minor_type_2).append(", t1.created as " + col_6_creation_date).append(", CASE REGEXP_INSTR(t2.comments, '(;Description:)') WHEN 0 THEN NULL ELSE substr(t2.comments, (REGEXP_INSTR(t2.comments, '(;Description:)')+13), length(t2.comments)) END as " + col_7_description).append(" from ALL_OBJECTS t1, ALL_TAB_COMMENTS t2 WHERE ").append(owner == null ? "" : " t1.owner like ? and ").append(objectName == null ? "" : " t1.object_name like ? and ").append(" t1.object_name = t2.table_name and t2.comments like 'CM_%' ").append(objectType == null ? " UNION ALL " : "");
            if (owner != null) {
                paramList.add(owner);
            }
            if (objectName != null) {
                paramList.add(objectName);
            }
        }
        if (NamedObject.testMetrics.equals((Object)objectType) || objectType == null) {
            sqlQry.append("select t2.owner as " + col_1_schema_name).append(", '" + NamedObject.testMetrics.name() + "' as " + col_2_type).append(", t2.table_name as " + col_3_name).append(", CASE REGEXP_INSTR(t2.comments, '(;Description:)') WHEN 0 THEN substr(t2.comments, 4, length(t2.comments)) ELSE substr(t2.comments, 4, (REGEXP_INSTR(t2.comments, '(;Description:)')-4)) END AS " + col_4_minor_type_1).append(", NULL AS " + col_5_minor_type_2).append(", t1.created as " + col_6_creation_date).append(", CASE REGEXP_INSTR(t2.comments, '(;Description:)') WHEN 0 THEN NULL ELSE substr(t2.comments, (REGEXP_INSTR(t2.comments, '(;Description:)')+13), length(t2.comments)) END as " + col_7_description).append(" from ALL_OBJECTS t1, ALL_TAB_COMMENTS t2 WHERE ").append(owner == null ? "" : " t1.owner like ? and ").append(objectName == null ? "" : " t1.object_name like ? and ").append(" t1.object_name = t2.table_name and t2.comments like 'TM_%' ").append(objectType != null && minorType_1 != null && minorType_1 instanceof MiningFunction ? " and CASE REGEXP_INSTR(t2.comments, '(;Description:)') WHEN 0 THEN substr(t2.comments, 4, length(t2.comments)) ELSE substr(t2.comments, 4, (REGEXP_INSTR(t2.comments, '(;Description:)')-4)) END = ? " : "").append(objectType == null ? " UNION ALL " : "");
            if (owner != null) {
                paramList.add(owner);
            }
            if (objectName != null) {
                paramList.add(objectName);
            }
            if (objectType != null && minorType_1 != null && minorType_1 instanceof MiningFunction) {
                paramList.add(minorType_1.name());
            }
        }
        if (NamedObject.task.equals((Object)objectType) || objectType == null) {
            sqlQry.append("select t2.owner as " + col_1_schema_name).append(", '" + NamedObject.task.name() + "' as " + col_2_type).append(", t2.job_name as " + col_3_name).append(", CASE 'SYS.' || t2.program_name WHEN 'SYS.JDM_BUILD_PROGRAM' THEN '" + MiningTask.buildTask.name()).append("'   WHEN 'SYS.JDM_TEST_PROGRAM' THEN '" + MiningTask.testTask.name()).append("'   WHEN 'SYS.JDM_SQL_APPLY_PROGRAM' THEN '" + MiningTask.applyTask.name()).append("'   WHEN 'SYS.JDM_XFORM_PROGRAM' THEN '" + OraMiningTask.transformTask.name()).append("'   WHEN 'SYS.JDM_IMPORT_PROGRAM' THEN '" + MiningTask.importTask.name()).append("'   WHEN 'SYS.JDM_EXPORT_PROGRAM' THEN '" + MiningTask.exportTask.name()).append("'   WHEN 'SYS.JDM_PREDICT_PROGRAM' THEN '" + OraMiningTask.predictTask.name()).append("'   WHEN 'SYS.JDM_EXPLAIN_PROGRAM' THEN '" + OraMiningTask.explainTask.name()).append("'   ELSE 'UNKNOWN' END as " + col_4_minor_type_1).append(", NULL AS " + col_5_minor_type_2).append(", t1.created as " + col_6_creation_date).append(", t2.comments as " + col_7_description).append(" from ALL_OBJECTS t1, all_scheduler_jobs t2 WHERE ").append(owner == null ? "" : " t1.owner like ? and ").append("t1.object_type='JOB' and ").append(objectName == null ? "" : " t1.object_name like ? and ").append(" t1.object_name = t2.job_name ").append(objectType != null && minorType_1 != null && minorType_1 instanceof MiningTask ? " and t2.program_name = '" + OraTask.getProgramName((MiningTask)minorType_1) + "' " : "").append(objectName == null ? " and t2.program_name like 'JDM%' " : "").append(objectType == null ? " UNION ALL " : "");
            if (owner != null) {
                paramList.add(owner);
            }
            if (objectName != null) {
                paramList.add(objectName);
            }
            if (objectType != null && minorType_1 != null && minorType_1 instanceof MiningFunction) {
                paramList.add(minorType_1.name());
            }
        }
        if (NamedObject.model.equals((Object)objectType) || objectType == null) {
            sqlQry.append("select t1.owner as " + col_1_schema_name).append(", '" + NamedObject.model.name() + "' as " + col_2_type).append(", t1.Model_NAME as " + col_3_name).append(", CASE t1.mining_function WHEN 'CLASSIFICATION' THEN '" + MiningFunction.classification.name()).append("'   WHEN 'REGRESSION' THEN '" + MiningFunction.regression.name()).append("'   WHEN 'ATTRIBUTE_IMPORTANCE' THEN '" + MiningFunction.attributeImportance.name()).append("'   WHEN 'ASSOCIATION' THEN '" + MiningFunction.association.name()).append("'   WHEN 'CLUSTERING' THEN '" + MiningFunction.clustering.name()).append("'   WHEN 'FEATURE_EXTRACTION' THEN '" + OraMiningFunction.featureExtraction.name()).append("'   ELSE t1.mining_function END as " + col_4_minor_type_1).append(", CASE t1.algorithm WHEN '" + "ALGO_ADAPTIVE_BAYES_NETWORK".substring(5) + "' THEN '" + OraMiningAlgorithm.adaptiveBayesNetwork.name()).append("'   WHEN '" + "ALGO_DECISION_TREE".substring(5) + "' THEN '" + MiningAlgorithm.decisionTree.name()).append("'   WHEN '" + "ALGO_NAIVE_BAYES".substring(5) + "' THEN '" + MiningAlgorithm.naiveBayes.name()).append("'   WHEN '" + "ALGO_SUPPORT_VECTOR_MACHINES".substring(5) + "' THEN CASE t1.mining_function WHEN '" + "CLASSIFICATION" + "' THEN '" + MiningAlgorithm.svmClassification.name() + "' ELSE '" + MiningAlgorithm.svmRegression.name() + "' END ").append("   WHEN '" + "ALGO_MINIMUM_DESCRIPTION_LENGTH".substring(5) + "' THEN '" + OraMiningAlgorithm.minimumDescriptionLength.name()).append("'   WHEN '" + "ALGO_APRIORI_ASSOCIATION_RULES".substring(5) + "' THEN '" + OraMiningAlgorithm.aprioriAssociationRules.name()).append("'   WHEN '" + "ALGO_KMEANS".substring(5) + "' THEN '" + MiningAlgorithm.kMeans.name()).append("'   WHEN '" + "ALGO_NONNEGATIVE_MATRIX_FACTOR".substring(5) + "' THEN '" + OraMiningAlgorithm.nonNegativeMatrixFactorization.name()).append("'   WHEN '" + "ALGO_O_CLUSTER".substring(5) + "' THEN '" + OraMiningAlgorithm.oCluster.name()).append("'   ELSE t1.algorithm END AS " + col_5_minor_type_2).append(", t1.CREATION_DATE as " + col_6_creation_date).append(", t1.comments as " + col_7_description).append(" from all_mining_models t1 ").append(owner == null && objectName == null && minorType_1 == null && minorType_2 == null ? "" : "  WHERE ").append(owner == null ? "" : " t1.owner like ? ").append(owner != null && objectName != null ? " and " : "").append(objectName == null ? "" : " t1.model_name like ? ").append((owner != null || objectName != null) && minorType_1 != null ? " and " : "").append(objectType != null && minorType_1 != null && minorType_1 instanceof MiningFunction ? " t1.mining_function = '" + OraPLSQLMappings.getPLSQLConstant((MiningFunction)minorType_1) + "' " : "").append((owner != null || objectName != null || minorType_1 != null) && minorType_2 != null ? " and " : "").append(objectType != null && minorType_2 != null && minorType_2 instanceof MiningAlgorithm ? " t1.algorithm = '" + OraPLSQLMappings.getPLSQLConstant((MiningAlgorithm)minorType_2).substring(5) + "' " : "");
            if (owner != null) {
                paramList.add(owner);
            }
            if (objectName != null) {
                paramList.add(objectName);
            }
        }
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = this.m_dbConn.prepareStatement(sqlQry.toString());
            for (int i = 0; i < paramList.size(); ++i) {
                pStmt.setString(i + 1, (String)paramList.get(i));
            }
            rs = pStmt.executeQuery();
            return rs;
        }
        catch (SQLException sqlExp) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            this.m_dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
            return null;
        }
    }
}

