/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.resource;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.datamining.ConnectionFailureException;
import javax.datamining.DuplicateEntryException;
import javax.datamining.EntryNotFoundException;
import javax.datamining.IncompatibleSpecificationException;
import javax.datamining.InvalidURIException;
import javax.datamining.JDMException;
import javax.datamining.JDMIllegalArgumentException;
import javax.datamining.JDMUnsupportedFeatureException;
import javax.datamining.ObjectExistsException;
import javax.datamining.ObjectNotFoundException;
import javax.datamining.TaskException;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.rbundle.OraJDMExceptionMap;

public class OraExceptionHandler {
    private Locale m_locale = Locale.getDefault();
    private Logger m_logger = null;
    private static final String BASE_NAME = "oracle.dmt.jdm.rbundle.OraJDMBundle";

    OraExceptionHandler(Locale locale, Logger logger) {
        this.setLocale(locale);
        this.m_logger = logger;
    }

    void setLocale(Locale locale) {
        if (locale != null) {
            this.m_locale = locale;
        }
    }

    public void createException(String errorCode, Object[] jdmMsgparams, Throwable cause) throws JDMException {
        this.createException(errorCode, jdmMsgparams, cause, "-1", null);
    }

    public void createException(String errorCode, Object[] jdmMsgparams, Throwable cause, String vendorCode, Object[] vendorMsgParams) throws JDMException {
        Integer exceptionCode;
        Object exception = null;
        String errorMessage = this.getLocalizedMessage(errorCode, jdmMsgparams);
        if (vendorCode != "-1") {
            errorMessage = errorMessage + this.getLocalizedMessage(vendorCode, vendorMsgParams);
        }
        if ((exceptionCode = (Integer)OraJDMExceptionMap.exceptionMap.get(new Integer(errorCode))) == null) {
            throw new RuntimeException("Internal Error: No exception defined for this error code:" + errorCode);
        }
        switch (exceptionCode) {
            case 1: {
                exception = new ConnectionFailureException(Integer.parseInt(errorCode), errorMessage);
                break;
            }
            case 7: {
                exception = new EntryNotFoundException(errorMessage);
                break;
            }
            case 6: {
                exception = new DuplicateEntryException(errorMessage);
                break;
            }
            case 4: {
                exception = new InvalidURIException(Integer.parseInt(errorCode), errorMessage);
                break;
            }
            case 2: {
                exception = new IncompatibleSpecificationException(Integer.parseInt(errorCode), errorMessage);
                break;
            }
            case 9: {
                exception = new ObjectNotFoundException(errorMessage);
                break;
            }
            case 8: {
                exception = new ObjectExistsException(errorMessage);
                break;
            }
            case 5: {
                exception = new TaskException(Integer.parseInt(errorCode), errorMessage);
                break;
            }
            default: {
                errorMessage = this.getLocalizedMessage(OraJDMBundleKeys.JDM_GENERIC_ERROR, null);
                exception = new JDMException(Integer.parseInt(OraJDMBundleKeys.JDM_GENERIC_ERROR), errorMessage);
            }
        }
        exception.initCause(cause);
        throw exception;
    }

    public void createRuntimeException(String errorCode, Object[] jdmMsgparams, Throwable cause) {
        this.createRuntimeException(errorCode, jdmMsgparams, cause, "-1", null);
    }

    public void createRuntimeException(String errorCode, Object[] jdmMsgparams, Throwable cause, String vendorCode, Object[] vendorMsgParams) {
        Integer exceptionCode;
        JDMUnsupportedFeatureException exception = null;
        String errorMessage = this.getLocalizedMessage(errorCode, jdmMsgparams);
        if (vendorCode != "-1") {
            errorMessage = errorMessage + this.getLocalizedMessage(vendorCode, vendorMsgParams);
        }
        if ((exceptionCode = (Integer)OraJDMExceptionMap.exceptionMap.get(new Integer(errorCode))) == null) {
            if (cause != null) {
                RuntimeException runExp = new RuntimeException();
                runExp.initCause(cause);
                throw runExp;
            }
            throw new RuntimeException("Internal Error: No exception defined for this error code" + errorCode);
        }
        switch (exceptionCode) {
            case 11: {
                exception = new JDMUnsupportedFeatureException(errorMessage);
                break;
            }
            case 10: {
                exception = new JDMIllegalArgumentException(Integer.parseInt(errorCode), errorMessage);
            }
        }
        if (cause != null) {
            exception.initCause(cause);
        }
        throw exception;
    }

    String getLocalizedMessage(String errorCode, Object[] params) {
        String errorCode2 = errorCode;
        ResourceBundle resBundle = ResourceBundle.getBundle(BASE_NAME);
        if (params == null || params.length == 0) {
            return resBundle.getString(errorCode2);
        }
        return MessageFormat.format(resBundle.getString(errorCode2), params);
    }
}

