/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.resource;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.datamining.resource.ConnectionSpec;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import oracle.dmt.jdm.resource.OraConnectionFactory;

public class OraConnectionFactoryFactory
implements ObjectFactory {
    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Reference ref = (Reference)refObj;
        OraConnectionFactory oraConnFactory = null;
        String cn = ref.getClassName();
        Properties info = new Properties();
        if (cn.equals("oracle.dmt.jdm.resource.OraConnectionFactory")) {
            oraConnFactory = new OraConnectionFactory();
            StringRefAddr st = null;
            ConnectionSpec cSpec = null;
            st = (StringRefAddr)ref.get("url");
            if (st != null) {
                String uri = (String)st.getContent();
                cSpec = oraConnFactory.getConnectionSpec();
                cSpec.setURI(uri);
            }
            if (cSpec != null) {
                st = (StringRefAddr)ref.get("userName");
                if (st != null) {
                    String userName = (String)st.getContent();
                    cSpec.setName(userName);
                }
                if ((st = (StringRefAddr)ref.get("passWord")) != null) {
                    String passwd = (String)st.getContent();
                    cSpec.setPassword(passwd);
                }
                String lang = null;
                String country = null;
                String variant = null;
                st = (StringRefAddr)ref.get("localeLanguage");
                if (st != null) {
                    lang = (String)st.getContent();
                }
                if ((st = (StringRefAddr)ref.get("localeCountry")) != null) {
                    country = (String)st.getContent();
                }
                if ((st = (StringRefAddr)ref.get("localeVariant")) != null) {
                    variant = (String)st.getContent();
                }
                if (lang != null) {
                    cSpec.setLocale(new Locale(lang, country, variant));
                }
                oraConnFactory.setConnectionSpec(cSpec);
            }
        }
        return oraConnFactory;
    }
}

