/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.resource;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.JDMUnsupportedFeatureException;
import javax.datamining.resource.ConnectionCapability;
import javax.datamining.resource.ConnectionFactory;
import javax.datamining.resource.ConnectionSpec;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.resource.cci.Connection;
import javax.sql.DataSource;
import oracle.dmt.jdm.OraSupportedEnums;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.resource.OraExceptionHandler;
import oracle.dmt.jdm.resource.OraLookupManagerImpl;
import oracle.dmt.jdm.resource.OraPersistanceManagerImpl;
import oracle.dmt.jdm.resource.OraSupportManagerImpl;
import oracle.dmt.jdm.resource.OraTaskManagerImpl;
import oracle.dmt.jdm.resource.OraValidationHandler;
import oracle.i18n.util.LocaleMapper;
import oracle.jdbc.pool.OracleDataSource;

public class OraConnectionFactory
implements ConnectionFactory,
Serializable,
Referenceable {
    private DataSource m_dataSource;
    private OraValidationHandler m_validationHandler = new OraValidationHandler();
    private OraConnectionSpec m_connSpec = null;
    private static final OraSupportedEnums supportedConnectionCapabilities = new OraSupportedEnums(new Enum[]{ConnectionCapability.connectionSpec});

    public OraConnectionFactory() throws JDMException {
        try {
            this.m_dataSource = new OracleDataSource();
        }
        catch (SQLException sqlExp) {
            JDMException jdmExp = new JDMException();
            jdmExp.initCause((Throwable)sqlExp);
            throw jdmExp;
        }
    }

    public OraConnectionFactory(DataSource dataSource) throws JDMException {
        this.m_dataSource = dataSource;
        this.m_connSpec = new OraConnectionSpec();
        if (dataSource instanceof OracleDataSource) {
            this.m_connSpec.setName(((OracleDataSource)this.m_dataSource).getUser());
            try {
                this.m_connSpec.setURI(((OracleDataSource)this.m_dataSource).getURL());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setConnectionSpec(ConnectionSpec spec) {
        this.m_connSpec = (OraConnectionSpec)spec;
        if (this.m_dataSource instanceof OracleDataSource) {
            ((OracleDataSource)this.m_dataSource).setURL(spec.getURI());
            ((OracleDataSource)this.m_dataSource).setUser(spec.getName());
            ((OracleDataSource)this.m_dataSource).setPassword(new String(this.m_connSpec.m_passwd));
        }
    }

    private void setupConnection(OraConnection dmeConn) {
        OraPersistanceManagerImpl pm = new OraPersistanceManagerImpl(dmeConn);
        OraLookupManagerImpl lm = new OraLookupManagerImpl(dmeConn);
        OraSupportManagerImpl sm = new OraSupportManagerImpl(dmeConn);
        OraTaskManagerImpl tm = new OraTaskManagerImpl(dmeConn);
        dmeConn.registerLookupManager(lm);
        dmeConn.registerPersistanceManager(pm);
        dmeConn.registerSupportManager(sm);
        dmeConn.registerTasktManager(tm);
        Logger log = Logger.getLogger("javax.datamining");
        log.setLevel(Level.OFF);
        StreamHandler handler = new StreamHandler(System.out, new SimpleFormatter());
        log.addHandler(handler);
        this.m_validationHandler.setLocale(dmeConn.getLocale());
        this.m_validationHandler.setChracterSet(OraConnectionFactory.getJavaCharacterSet(dmeConn.getDatabaseConnection()));
        dmeConn.registerHandlers(new OraExceptionHandler(dmeConn.getLocale(), log), this.m_validationHandler);
        dmeConn.setLogger(log);
    }

    public javax.datamining.resource.Connection getConnection() throws JDMException {
        OraConnection dmeConn = null;
        try {
            dmeConn = this.m_dataSource instanceof OracleDataSource || this.m_connSpec.getName() == null || this.m_connSpec.m_passwd == null ? new OraConnection(this.m_dataSource.getConnection(), this.m_connSpec) : new OraConnection(this.m_dataSource.getConnection(this.m_connSpec.getName(), new String(this.m_connSpec.m_passwd)), this.m_connSpec);
        }
        catch (SQLException sqlExp) {
            JDMException jdmExp = new JDMException();
            jdmExp.initCause((Throwable)sqlExp);
            throw jdmExp;
        }
        this.setupConnection(dmeConn);
        return dmeConn;
    }

    public javax.datamining.resource.Connection getConnection(ConnectionSpec spec) throws JDMException {
        OraConnection dmeConn = null;
        try {
            OraConnectionSpec innerConnImpl = (OraConnectionSpec)spec;
            if (this.m_dataSource instanceof OracleDataSource) {
                ((OracleDataSource)this.m_dataSource).setURL(spec.getURI());
            }
            dmeConn = new OraConnection(this.m_dataSource.getConnection(spec.getName(), new String(innerConnImpl.m_passwd)), spec);
        }
        catch (SQLException sqlExp) {
            JDMException jdmExp = new JDMException();
            jdmExp.initCause((Throwable)sqlExp);
            throw jdmExp;
        }
        this.setupConnection(dmeConn);
        return dmeConn;
    }

    public javax.datamining.resource.Connection getConnection(Connection connection) throws JDMException {
        String errorMessage = null;
        try {
            ResourceBundle resBundle = ResourceBundle.getBundle("oracle.dmt.jdm.rbundle.OraJDMBundle");
            errorMessage = MessageFormat.format(resBundle.getString(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE), "getConnection(javax.resource.cci.Connection connection)", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new JDMUnsupportedFeatureException(errorMessage);
    }

    public ConnectionSpec getConnectionSpec() {
        return new OraConnectionSpec();
    }

    public boolean supportsCapability(ConnectionCapability capability) {
        return supportedConnectionCapabilities.isSupported((Enum)capability);
    }

    public synchronized Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "oracle.dmt.jdm.resource.OraConnectionFactoryFactory", null);
        this.addRefProperties(ref);
        return ref;
    }

    protected void addRefProperties(Reference ref) {
        if (this.m_connSpec != null) {
            ref.add(new StringRefAddr("url", this.m_connSpec.getURI()));
            ref.add(new StringRefAddr("userName", this.m_connSpec.getName()));
            ref.add(new StringRefAddr("passWord", new String(this.m_connSpec.m_passwd)));
            if (this.m_connSpec.m_locale != null) {
                ref.add(new StringRefAddr("localeLanguage", this.m_connSpec.m_locale.getLanguage()));
                String country = this.m_connSpec.m_locale.getCountry();
                String variant = this.m_connSpec.m_locale.getVariant();
                if (country != null) {
                    ref.add(new StringRefAddr("localeCountry", country));
                }
                if (variant != null) {
                    ref.add(new StringRefAddr("localeVariant", variant));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getJavaCharacterSet(java.sql.Connection conn) {
        String javaCharSet;
        block16: {
            String oracleCharset;
            block15: {
                PreparedStatement ps = null;
                ResultSet rs = null;
                oracleCharset = null;
                String query = null;
                javaCharSet = null;
                query = "SELECT VALUE FROM v$nls_parameters WHERE PARAMETER='NLS_CHARACTERSET'";
                ps = conn.prepareStatement(query);
                rs = ps.executeQuery();
                if (rs.next()) {
                    oracleCharset = rs.getString(1);
                }
                rs.close();
                rs = null;
                ps.close();
                ps = null;
                if (oracleCharset != null) break block15;
                javaCharSet = null;
            }
            try {
                javaCharSet = LocaleMapper.getJavaCharacterSet((int)1, (String)oracleCharset);
            }
            catch (Exception anyExp) {
                javaCharSet = null;
            }
            break block16;
            catch (Exception e) {
                if (oracleCharset == null) {
                    javaCharSet = null;
                } else {
                    try {
                        javaCharSet = LocaleMapper.getJavaCharacterSet((int)1, oracleCharset);
                    }
                    catch (Exception anyExp) {
                        javaCharSet = null;
                    }
                }
                catch (Throwable throwable) {
                    if (oracleCharset == null) {
                        javaCharSet = null;
                    } else {
                        try {
                            javaCharSet = LocaleMapper.getJavaCharacterSet((int)1, oracleCharset);
                        }
                        catch (Exception anyExp) {
                            javaCharSet = null;
                        }
                    }
                    throw throwable;
                }
            }
        }
        return javaCharSet;
    }

    private class OraConnectionSpec
    implements ConnectionSpec {
        private String m_user = null;
        private char[] m_passwd = null;
        private String m_uri = null;
        private Locale m_locale = null;

        private OraConnectionSpec() {
        }

        public String getName() {
            return this.m_user;
        }

        public void setName(String userName) {
            this.m_user = userName;
        }

        public String getURI() {
            return this.m_uri;
        }

        public void setURI(String uri) {
            this.m_uri = uri;
        }

        public void setPassword(String password) {
            this.m_passwd = password.toCharArray();
        }

        public void setLocale(Locale locale) {
            this.m_locale = locale;
        }

        public Locale getLocale() {
            return this.m_locale;
        }
    }
}

