/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.modeldetail.tree;

import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.data.AttributeDataType;
import javax.datamining.modeldetail.tree.PredictionType;
import javax.datamining.modeldetail.tree.TreeNode;
import javax.datamining.rule.Predicate;
import javax.datamining.rule.Rule;
import javax.datamining.statistics.AttributeStatisticsSet;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.data.OraCategorySet;
import oracle.dmt.jdm.modeldetail.tree.OraTreeModelDetail;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;

public class OraTreeNode
extends OraDMObject
implements TreeNode {
    private int m_identifier;
    private Object m_prediction;
    private int m_level;
    private long m_caseCount;
    private long m_predictionCaseCount = 0L;
    private Vector m_targetValue = null;
    private Vector m_targetCount = null;
    private PredictionType m_predictionType = PredictionType.category;
    private Predicate m_predicate = null;
    private Predicate[] m_surrogates = null;
    private OraTreeModelDetail m_treeModelDetail = null;
    private OraCategorySet m_targetCategorySet = null;
    private OraTreeNode m_parent = null;
    private OraTreeNode m_next = null;
    private OraTreeNode m_firstChild = null;

    OraTreeNode(OraConnection dmeConn, OraTreeModelDetail treeModelDetail, OraCategorySet categorySet) throws JDMException {
        super(dmeConn, null);
        this.m_treeModelDetail = treeModelDetail;
        this.m_targetCategorySet = categorySet;
        Object[] targets = this.m_targetCategorySet.getValues();
        this.m_targetValue = new Vector();
        this.m_targetCount = new Vector();
        for (int i = 0; i < targets.length; ++i) {
            this.m_targetValue.add(targets[i]);
            this.m_targetCount.add(new Long(0L));
        }
    }

    OraTreeNode getNext() {
        return this.m_next;
    }

    void setNext(OraTreeNode next) {
        this.m_next = next;
    }

    OraTreeNode getFirstChild() {
        return this.m_firstChild;
    }

    void setFirstChild(OraTreeNode child) {
        this.m_firstChild = child;
    }

    void setParent(OraTreeNode parent) {
        this.m_parent = parent;
    }

    void setLevel(int level) {
        this.m_level = level;
    }

    void setNodeId(int id) {
        this.m_identifier = id;
    }

    void setPrediction(Object prediction) {
        AttributeDataType targetType = this.m_targetCategorySet.getDataType();
        if (prediction instanceof String && !targetType.equals((Object)AttributeDataType.stringType)) {
            prediction = targetType.equals((Object)AttributeDataType.integerType) ? (Number)Integer.valueOf((String)prediction) : (Number)Double.valueOf((String)prediction);
        }
        this.m_prediction = prediction;
    }

    void setCaseCount(long caseCount) {
        this.m_caseCount = caseCount;
    }

    void setPredictionCount(Object prediction, long count) throws JDMException {
        AttributeDataType targetType = this.m_targetCategorySet.getDataType();
        if (prediction instanceof String && !targetType.equals((Object)AttributeDataType.stringType)) {
            prediction = targetType.equals((Object)AttributeDataType.integerType) ? (Number)Integer.valueOf((String)prediction) : (Number)Double.valueOf((String)prediction);
        }
        if (this.m_targetValue.contains(prediction)) {
            int index = this.m_targetValue.indexOf(prediction);
            this.m_targetCount.setElementAt(new Long(count), index);
        } else {
            this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new Object[]{prediction.toString(), "TreeNode", Integer.toString(this.m_identifier)}, null, "2012", new Object[]{prediction.toString()});
        }
        if (count > this.m_predictionCaseCount) {
            this.m_predictionCaseCount = count;
        }
    }

    long getPredictionCaseCount() {
        return this.m_predictionCaseCount;
    }

    void setPredicate(Predicate predicate) {
        this.m_predicate = predicate;
    }

    void setSurrogates(Predicate[] surrogates) {
        this.m_surrogates = surrogates;
    }

    public int getIdentifier() {
        return this.m_identifier;
    }

    public long getCaseCount() {
        return this.m_caseCount;
    }

    public long getTargetCount(Object target) throws JDMException {
        this.getValidationHandler().validateCategory(target, "target");
        int loc = this.m_targetValue.indexOf(target);
        if (loc == -1) {
            this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new Object[]{target.toString(), "TreeNode", Integer.toString(this.m_identifier)}, null, "2012", new Object[]{target.toString()});
        }
        Long count = (Long)this.m_targetCount.elementAt(loc);
        return count;
    }

    public long[] getTargetCounts() {
        int size = this.m_targetCount.size();
        long[] counts = new long[size];
        for (int i = 0; i < size; ++i) {
            Long cnt = (Long)this.m_targetCount.elementAt(i);
            counts[i] = cnt;
        }
        return counts;
    }

    public int getNumberOfChildren() {
        int numChildren = 0;
        for (OraTreeNode next = this.m_firstChild; next != null; next = next.getNext()) {
            ++numChildren;
        }
        return numChildren;
    }

    public TreeNode getParent() throws JDMException {
        return this.m_parent;
    }

    public TreeNode[] getAncestors() throws JDMException {
        if (this.m_parent == null) {
            return null;
        }
        Vector<OraTreeNode> parents = new Vector<OraTreeNode>();
        for (OraTreeNode next = this.m_parent; next != null; next = (OraTreeNode)next.getParent()) {
            parents.add(next);
        }
        TreeNode[] ancestors = new OraTreeNode[parents.size()];
        parents.toArray(ancestors);
        return ancestors;
    }

    public TreeNode[] getChildren() throws JDMException {
        if (this.m_firstChild == null) {
            return null;
        }
        Vector<OraTreeNode> children = new Vector<OraTreeNode>();
        for (OraTreeNode next = this.m_firstChild; next != null; next = next.getNext()) {
            children.add(next);
        }
        TreeNode[] children2 = new OraTreeNode[children.size()];
        children.toArray(children2);
        return children2;
    }

    public Predicate getPredicate() {
        return this.m_predicate;
    }

    public Predicate[] getSurrogates() {
        return this.m_surrogates;
    }

    public Object getPrediction() {
        return this.m_prediction;
    }

    public int getLevel() {
        return this.m_level - 1;
    }

    public AttributeStatisticsSet getNodeStatistics() throws JDMException {
        this.unsupported("TreeNode.getNodeStatistics");
        return null;
    }

    public PredictionType getPredictionType() {
        return this.m_predictionType;
    }

    public boolean isLeaf() {
        return this.m_firstChild == null;
    }

    public Rule getRule() throws JDMException {
        return this.m_treeModelDetail.getRule(this.m_identifier);
    }
}

