/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.modeldetail.svm;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.datamining.JDMException;
import javax.datamining.modeldetail.svm.SVMRegressionModelDetail;
import javax.datamining.supervised.regression.RegressionModel;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.modeldetail.svm.OraSVMModelDetail;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransformImpl;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraSVMRegressionModelDetail
extends OraSVMModelDetail
implements SVMRegressionModelDetail {
    private PreparedStatement m_qryStmt = null;
    private ResultSet m_rs = null;
    private static String QRY_REGRESSION_BIAS = "SELECT s.coefficient as bias FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s WHERE s.attribute_name IS NULL";
    private static String QRY_REGRESSION_NUMERICAL_COEFFICIENT = "SELECT s.coefficient FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s WHERE NVL2(s.attribute_subname, s.attribute_name || '.' || s.attribute_subname, s.attribute_name) = ? AND s.attribute_value IS NULL";
    private static String QRY_REGRESSION_CATEGORICAL_COEFFICIENT = "SELECT s.coefficient FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s WHERE NVL2(s.attribute_subname, s.attribute_name || '.' || s.attribute_subname, s.attribute_name) = ? AND s.attribute_value = ?";
    private static String QRY_DENORMALIZED_REGRESSION_BIAS = "SELECT ((s.coefficient*target.scale + target.shift) - de_norm.sum_coefficient) as bias  FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t,       TABLE(t.attribute_set) s,       (SELECT nvl(SUM(s.coefficient * n.shift / n.scale), 0) as sum_coefficient         FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t,              TABLE(t.attribute_set) s, {0} n         WHERE s.attribute_name IS NOT NULL AND n.COL = s.attribute_name          AND n.scale <> 0) de_norm,       (SELECT * FROM {1} WHERE COL = {2}) target  WHERE s.attribute_name IS NULL";
    private static String QRY_DENORMALIZED_REGRESSION_NUMERICAL_COEFFICIENT = "SELECT s.coefficient*target.scale/n.scale as coefficient  FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t,       TABLE(t.attribute_set) s,       {0} n,       (SELECT * FROM {1} WHERE COL = {2}) target  WHERE NVL2(s.attribute_subname, s.attribute_name || '.' || s.attribute_subname, s.attribute_name) = ?   AND s.attribute_value IS NULL   AND n.col = s.attribute_name    AND n.scale <> 0";
    private static String QRY_DENORMALIZED_REGRESSION_ALL_COEFFICIENTS_PER_ATTR = "SELECT s.attribute_value, s.coefficient*target.scale/nvl(n.scale, 1) as coefficient  FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t,       TABLE(t.attribute_set) s,       {0} n,       (SELECT * FROM {1} WHERE COL = {2}) target  WHERE s.attribute_name = n.col (+) and NVL2(s.attribute_subname, s.attribute_name || '.' || s.attribute_subname, s.attribute_name)=? ORDER BY abs(coefficient) DESC, s.attribute_value";
    private static String QRY_REGRESSION_ALL_COEFFICIENTS_PER_ATTR = "SELECT s.attribute_value, s.coefficient FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s WHERE NVL2(s.attribute_subname, s.attribute_name || '.' || s.attribute_subname, s.attribute_name)=? ORDER BY abs(coefficient) DESC, s.attribute_value";

    public OraSVMRegressionModelDetail(OraConnection dmeConn, OraModel model, OraNormalizeTransformImpl normalizeTransform) throws JDMException {
        super(dmeConn, model, normalizeTransform);
    }

    public double getCoefficient(String categoricalAttrName, Object categoryValue) throws JDMException {
        this.getValidationHandler().validateTableColumnName(categoricalAttrName, "categoricalAttrName");
        this.getValidationHandler().validateCategory(categoryValue, "categoryValue");
        Connection dbConn = this.getDatabaseConnection();
        CallableStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dbConn.prepareCall(QRY_REGRESSION_CATEGORICAL_COEFFICIENT);
            pStmt.setString(1, this.m_model.getName());
            pStmt.setString(2, categoricalAttrName);
            pStmt.setObject(3, categoryValue);
            rs = pStmt.executeQuery();
            BigDecimal coefCatVal = null;
            if (rs.next()) {
                coefCatVal = rs.getBigDecimal("coefficient");
            }
            if (coefCatVal == null) {
                this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"coefficient", "model", "details"}, null);
            }
            double d = coefCatVal.doubleValue();
            return d;
        }
        catch (SQLException sqlExp) {
            throw new JDMException(1, "Failed in OraSVMRegressionModelDetail.getCoefficient(categoricalAttrName, categoryValue) method.");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
    }

    public double getCoefficient(String numericalAttrName) throws JDMException {
        this.getValidationHandler().validateTableColumnName(numericalAttrName, "numericalAttrName");
        Connection dbConn = this.getDatabaseConnection();
        CallableStatement pStmt = null;
        ResultSet rs = null;
        try {
            if (this.m_normalizeTransform != null) {
                String qry = QRY_DENORMALIZED_REGRESSION_NUMERICAL_COEFFICIENT;
                String targetAttribute = ((RegressionModel)this.m_model).getTargetAttributeName();
                qry = MessageFormat.format(qry.replaceAll("'", "''"), this.m_normalizeTransform.getNormalizationDefinitionTable(), this.m_normalizeTransform.getNormalizationDefinitionTable(), "'" + OraStringUtils.getReplacedString(targetAttribute, "'", "''") + "'");
                pStmt = dbConn.prepareCall(qry);
                pStmt.setString(1, this.m_model.getName());
                pStmt.setString(2, numericalAttrName);
            } else {
                pStmt = dbConn.prepareCall(QRY_REGRESSION_NUMERICAL_COEFFICIENT);
                pStmt.setString(1, this.m_model.getName());
                pStmt.setString(2, numericalAttrName);
            }
            rs = pStmt.executeQuery();
            BigDecimal coefNumVal = null;
            if (rs.next()) {
                coefNumVal = rs.getBigDecimal("coefficient");
            }
            if (coefNumVal == null) {
                this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"coefficient", "model", "details"}, null);
            }
            double d = coefNumVal.doubleValue();
            return d;
        }
        catch (SQLException sqlExp) {
            throw new JDMException(1, "Failed in OraSVMRegressionModelDetail.getCoefficient(numericalAttrName) method.");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCoefficients(String attrName) {
        Connection dbConn = this.getDatabaseConnection();
        this.getValidationHandler().validateTableColumnName(attrName, "attrName");
        LinkedHashMap<Object, BigDecimal> coefficientsMap = null;
        try {
            if (this.m_normalizeTransform != null) {
                String qry = QRY_DENORMALIZED_REGRESSION_ALL_COEFFICIENTS_PER_ATTR;
                String targetAttribute = ((RegressionModel)this.m_model).getTargetAttributeName();
                qry = MessageFormat.format(qry.replaceAll("'", "''"), this.m_normalizeTransform.getNormalizationDefinitionTable(), this.m_normalizeTransform.getNormalizationDefinitionTable(), "'" + OraStringUtils.getReplacedString(targetAttribute, "'", "''") + "'");
                this.m_qryStmt = dbConn.prepareCall(qry);
                this.m_qryStmt.setString(1, this.m_model.getName());
                this.m_qryStmt.setString(2, attrName);
            } else {
                this.m_qryStmt = dbConn.prepareCall(QRY_REGRESSION_ALL_COEFFICIENTS_PER_ATTR);
                this.m_qryStmt.setString(1, this.m_model.getName());
                this.m_qryStmt.setString(2, attrName);
            }
            this.m_rs = this.m_qryStmt.executeQuery();
            coefficientsMap = new LinkedHashMap<Object, BigDecimal>();
            while (this.m_rs.next()) {
                coefficientsMap.put(this.m_rs.getObject(1), this.m_rs.getBigDecimal(2));
            }
        }
        catch (SQLException sqlExp) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
        }
        finally {
            try {
                if (this.m_rs != null) {
                    this.m_rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (this.m_qryStmt != null) {
                    this.m_qryStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return coefficientsMap;
    }

    public void close() {
        try {
            if (this.m_rs != null) {
                this.m_rs.close();
            }
        }
        catch (SQLException sqlExp1) {
            // empty catch block
        }
        try {
            if (this.m_qryStmt != null) {
                this.m_qryStmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void finalize() {
        this.close();
    }

    public double getBias() throws JDMException {
        Connection dbConn = this.getDatabaseConnection();
        CallableStatement pStmt = null;
        ResultSet rs = null;
        try {
            if (this.m_normalizeTransform != null) {
                String targetAttribute = ((RegressionModel)this.m_model).getTargetAttributeName();
                String qry = QRY_DENORMALIZED_REGRESSION_BIAS;
                qry = MessageFormat.format(qry.replaceAll("'", "''"), this.m_normalizeTransform.getNormalizationDefinitionTable(), this.m_normalizeTransform.getNormalizationDefinitionTable(), "'" + OraStringUtils.getReplacedString(targetAttribute, "'", "''") + "'");
                pStmt = dbConn.prepareCall(qry);
                pStmt.setString(1, this.m_model.getName());
                pStmt.setString(2, this.m_model.getName());
            } else {
                pStmt = dbConn.prepareCall(QRY_REGRESSION_BIAS);
                pStmt.setString(1, this.m_model.getName());
            }
            rs = pStmt.executeQuery();
            BigDecimal biasVal = null;
            if (rs.next()) {
                biasVal = rs.getBigDecimal("bias");
            }
            if (biasVal == null) {
                this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"bias", "model", "details"}, null);
            }
            double d = biasVal.doubleValue();
            return d;
        }
        catch (SQLException sqlExp) {
            throw new JDMException(1, "Failed in OraSVMRegressionModelDetail.getBias() method.");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
    }

    private void setup102() {
        if (this.is102()) {
            QRY_REGRESSION_NUMERICAL_COEFFICIENT = "SELECT s.coefficient FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s WHERE s.attribute_name = ? AND s.attribute_value IS NULL";
            QRY_REGRESSION_CATEGORICAL_COEFFICIENT = "SELECT s.coefficient FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s WHERE s.attribute_name = ? AND s.attribute_value = ?";
            QRY_DENORMALIZED_REGRESSION_BIAS = "SELECT ((s.coefficient*target.scale + target.shift) - de_norm.sum_coefficient) as bias  FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t,       TABLE(t.attribute_set) s,       (SELECT nvl(SUM(s.coefficient * n.shift / n.scale), 0) as sum_coefficient         FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t,              TABLE(t.attribute_set) s, {0} n         WHERE s.attribute_name IS NOT NULL AND n.COL = s.attribute_name         AND n.scale <> 0) de_norm,       (SELECT * FROM {1} WHERE COL = {2}) target  WHERE s.attribute_name IS NULL";
            QRY_DENORMALIZED_REGRESSION_NUMERICAL_COEFFICIENT = "SELECT s.coefficient*target.scale/n.scale as coefficient  FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t,       TABLE(t.attribute_set) s,       {0} n,       (SELECT * FROM {1} WHERE COL = {2}) target  WHERE s.attribute_name = ?   AND s.attribute_value IS NULL   AND n.col = s.attribute_name   AND n.scale <> 0";
            QRY_DENORMALIZED_REGRESSION_ALL_COEFFICIENTS_PER_ATTR = "SELECT s.attribute_value, s.coefficient*target.scale/nvl(n.scale, 1) as coefficient  FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t,       TABLE(t.attribute_set) s,       {0} n,       (SELECT * FROM {1} WHERE COL = {2}) target  WHERE s.attribute_name = n.col (+) and s.attribute_name=? ORDER BY abs(coefficient) DESC, s.attribute_value";
            QRY_REGRESSION_ALL_COEFFICIENTS_PER_ATTR = "SELECT s.attribute_value, s.coefficient FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s WHERE s.attribute_name=? ORDER BY abs(coefficient) DESC, s.attribute_value";
        }
    }
}

