/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.modeldetail.svm;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.datamining.JDMException;
import javax.datamining.modeldetail.svm.SVMModelDetail;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.base.OraModelDetail;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransformImpl;

public class OraSVMModelDetail
extends OraModelDetail
implements SVMModelDetail {
    private String SVMS_KERNEL_FUNCTION = "SVMS_KERNEL_FUNCTION";
    private String SVMS_LINEAR = "SVMS_LINEAR";
    private String SVMS_GUASSIAN = "SVMS_GUASSIAN";
    protected OraNormalizeTransformImpl m_normalizeTransform = null;
    private static final String QRY_SVM_KERNEL_FUNCTION = "SELECT t.setting_name, t.setting_value from TABLE(dbms_data_mining.get_model_settings(?)) t where t.setting_name = 'SVMS_KERNEL_FUNCTION'";

    public OraSVMModelDetail(OraConnection dmeConn, OraModel model, OraNormalizeTransformImpl normalizeTransform) throws JDMException {
        super(dmeConn, model);
        this.m_normalizeTransform = normalizeTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLinearSVMModel() {
        String settingName = "";
        String settingVal = "";
        boolean isLinear = false;
        Connection dbConn = this.getDatabaseConnection();
        CallableStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dbConn.prepareCall(QRY_SVM_KERNEL_FUNCTION);
            pStmt.setString(1, this.m_model.getName());
            rs = pStmt.executeQuery();
            if (rs.next()) {
                settingName = rs.getString("setting_name");
                settingVal = rs.getString("setting_value");
            }
            if (settingName != null & settingVal != null && settingName.equalsIgnoreCase(this.SVMS_KERNEL_FUNCTION)) {
                if (settingVal.equalsIgnoreCase(this.SVMS_LINEAR)) {
                    isLinear = true;
                } else if (settingVal.equalsIgnoreCase(this.SVMS_GUASSIAN)) {
                    isLinear = false;
                }
            }
        }
        catch (SQLException sqlExp) {
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return isLinear;
    }

    public int getNumberOfSupportVectors() {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "OraSVMModelDetail.getNumberOfSupportVectors"}, null);
        return 0;
    }

    public int getNumberOfBoundedVectors() {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "OraSVMModelDetail.getNumberOfBoundedVectors"}, null);
        return 0;
    }

    public int getNumberOfUnboundedVectors() {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "OraSVMModelDetail.getNumberOfUnboundedVectors"}, null);
        return 0;
    }
}

