/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.modeldetail.svm;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.datamining.JDMException;
import javax.datamining.data.CategorySet;
import javax.datamining.modeldetail.svm.SVMClassificationModelDetail;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.modeldetail.svm.OraSVMModelDetail;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.classification.OraClassificationModel;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransformImpl;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraSVMClassificationModelDetail
extends OraSVMModelDetail
implements SVMClassificationModelDetail {
    private PreparedStatement m_qryStmt = null;
    private ResultSet m_rs = null;
    private static String QRY_CLASSIFICATION_BIAS = "SELECT s.coefficient as bias FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s WHERE t.class = ? AND s.attribute_name IS NULL";
    private static String QRY_CLASSIFICATION_NUMERICAL_COEFFICIENT = "SELECT s.coefficient FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s WHERE t.class = ? AND NVL2(s.attribute_subname, s.attribute_name || '.' || s.attribute_subname, s.attribute_name) = ? AND s.attribute_value IS NULL";
    private static String QRY_CLASSIFICATION_CATEGORICAL_COEFFICIENT = "SELECT s.coefficient FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s WHERE t.class = ? AND NVL2(s.attribute_subname, s.attribute_name || '.' || s.attribute_subname, s.attribute_name) = ? AND s.attribute_value = ?";
    private static String QRY_DENORMALIZED_CLASSIFICATION_BIAS = "SELECT (s.coefficient - de_norm.sum_coefficient) as bias  FROM TABLE(dbms_data_mining.get_model_details_svm(<model_name>)) t,       TABLE(t.attribute_set) s,       (SELECT SUM(s.coefficient * n.shift / n.scale) as sum_coefficient         FROM TABLE(dbms_data_mining.get_model_details_svm(<model_name>)) t,              TABLE(t.attribute_set) s, <norm_table_name> n         WHERE t.class = <target>         AND s.attribute_name IS NOT NULL AND n.COL = s.attribute_name          AND n.scale <> 0) de_norm  WHERE t.class = <target> AND s.attribute_name IS NULL";
    private static String QRY_DENORMALIZED_CLASSIFICATION_NUMERICAL_COEFFICIENT = "SELECT s.coefficient/n.scale as coefficient FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s, {0} n WHERE t.class = ? AND NVL2(s.attribute_subname, s.attribute_name || '.' || s.attribute_subname, s.attribute_name) = ? AND s.attribute_value IS NULL AND n.col = s.attribute_name   and n.scale <> 0";
    private static String QRY_DENORMALIZED_CLASSIFICATION_COEFFICIENTS_PER_ATTR = "SELECT s.attribute_value, s.coefficient/nvl(n.scale, 1) as coefficient  FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s, {0} n WHERE t.class = ? AND s.attribute_name = n.col (+) AND NVL2(s.attribute_subname, s.attribute_name || '.' || s.attribute_subname, s.attribute_name) = ? ORDER BY abs(coefficient) DESC, s.attribute_value";
    private static String QRY_CLASSIFICATION_COEFFICIENTS_PER_ATTR = "SELECT s.attribute_value, s.coefficient FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s WHERE t.class = ? AND NVL2(s.attribute_subname, s.attribute_name || '.' || s.attribute_subname, s.attribute_name) = ? ORDER BY abs(s.coefficient) DESC, s.attribute_value";

    public OraSVMClassificationModelDetail(OraConnection dmeConn, OraModel model, OraNormalizeTransformImpl normalizeTransform) throws JDMException {
        super(dmeConn, model, normalizeTransform);
        this.setup102();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCoefficients(Object targetValue, String attrName) {
        Connection dbConn = this.getDatabaseConnection();
        this.getValidationHandler().validateTableColumnName(attrName, "attrName");
        this.getValidationHandler().validateCategory(targetValue, "targetValue");
        LinkedHashMap<Object, BigDecimal> coefficientsMap = null;
        try {
            if (this.m_normalizeTransform != null) {
                if (targetValue != null) {
                    String qry = QRY_DENORMALIZED_CLASSIFICATION_COEFFICIENTS_PER_ATTR;
                    qry = MessageFormat.format(qry.replaceAll("'", "''"), this.m_normalizeTransform.getNormalizationDefinitionTable());
                    this.m_qryStmt = dbConn.prepareCall(qry);
                    this.m_qryStmt.setString(1, this.m_model.getName());
                    this.m_qryStmt.setObject(2, targetValue);
                    this.m_qryStmt.setString(3, attrName);
                }
            } else if (targetValue != null) {
                this.m_qryStmt = dbConn.prepareCall(QRY_CLASSIFICATION_COEFFICIENTS_PER_ATTR);
                this.m_qryStmt.setString(1, this.m_model.getName());
                this.m_qryStmt.setObject(2, targetValue);
                this.m_qryStmt.setString(3, attrName);
            }
            this.m_rs = this.m_qryStmt.executeQuery();
            coefficientsMap = new LinkedHashMap<Object, BigDecimal>();
            while (this.m_rs.next()) {
                coefficientsMap.put(this.m_rs.getObject(1), this.m_rs.getBigDecimal(2));
            }
        }
        catch (SQLException sqlExp) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
        }
        finally {
            try {
                if (this.m_rs != null) {
                    this.m_rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (this.m_qryStmt != null) {
                    this.m_qryStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return coefficientsMap;
    }

    public void close() {
        try {
            if (this.m_rs != null) {
                this.m_rs.close();
            }
        }
        catch (SQLException sqlExp1) {
            // empty catch block
        }
        try {
            if (this.m_qryStmt != null) {
                this.m_qryStmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void finalize() {
        this.close();
    }

    public double getCoefficient(Object targetValue, String categoricalAttrName, Object categoryValue) throws JDMException {
        this.getValidationHandler().validateTableColumnName(categoricalAttrName, "categoricalAttrName");
        this.getValidationHandler().validateCategory(categoryValue, "categoryValue");
        this.getValidationHandler().validateNotNull(targetValue, "targetValue");
        Connection dbConn = this.getDatabaseConnection();
        CallableStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dbConn.prepareCall(QRY_CLASSIFICATION_CATEGORICAL_COEFFICIENT);
            pStmt.setString(1, this.m_model.getName());
            pStmt.setObject(2, targetValue);
            pStmt.setString(3, categoricalAttrName);
            pStmt.setObject(4, categoryValue);
            rs = pStmt.executeQuery();
            BigDecimal coefCatVal = null;
            if (rs.next()) {
                coefCatVal = rs.getBigDecimal("coefficient");
            }
            if (coefCatVal == null) {
                CategorySet targetSet = ((OraClassificationModel)this.m_model).getTargetCategorySet();
                Object[] targets = targetSet.getValues();
                if (targets.length == 2) {
                    for (int i = 0; i < targets.length; ++i) {
                        if (targetValue.toString() == targets[i].toString()) continue;
                        targetValue = targets[i];
                        break;
                    }
                    try {
                        pStmt = dbConn.prepareCall(QRY_CLASSIFICATION_CATEGORICAL_COEFFICIENT);
                        pStmt.setString(1, this.m_model.getName());
                        pStmt.setObject(2, targetValue);
                        pStmt.setString(3, categoricalAttrName);
                        pStmt.setObject(4, categoryValue);
                        rs = pStmt.executeQuery();
                        coefCatVal = null;
                        if (rs.next()) {
                            coefCatVal = rs.getBigDecimal("coefficient");
                        }
                        if (coefCatVal == null) {
                            this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"categorical coefficient", "model", "details"}, null);
                        }
                        coefCatVal = new BigDecimal(coefCatVal.doubleValue() * -1.0);
                    }
                    catch (SQLException sqlExp) {
                        throw new JDMException(1, "Failed in OraSVMClassificationModelDetail.getCoefficient(targetValue, categoricalAttrName, categoryValue) method.");
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (SQLException sqlExp1) {}
                        try {
                            if (pStmt != null) {
                                pStmt.close();
                            }
                        }
                        catch (SQLException sqlExp1) {}
                    }
                }
                this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"coefficient", "model", "details"}, null);
            }
            double d = coefCatVal.doubleValue();
            return d;
        }
        catch (SQLException sqlExp) {
            throw new JDMException(1, "Failed in OraSVMClassificationModelDetail.getCoefficient(targetValue, categoricalAttrName, categoryValue) method.");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
    }

    public double getCoefficient(Object targetValue, String numericalAttrName) throws JDMException {
        this.getValidationHandler().validateTableColumnName(numericalAttrName, "numericalAttrName");
        this.getValidationHandler().validateNotNull(targetValue, "targetValue");
        Connection dbConn = this.getDatabaseConnection();
        CallableStatement pStmt = null;
        ResultSet rs = null;
        try {
            if (this.m_normalizeTransform != null) {
                String qry = QRY_DENORMALIZED_CLASSIFICATION_NUMERICAL_COEFFICIENT;
                qry = MessageFormat.format(qry.replaceAll("'", "''"), this.m_normalizeTransform.getNormalizationDefinitionTable());
                pStmt = dbConn.prepareCall(qry);
                pStmt.setString(1, this.m_model.getName());
                pStmt.setObject(2, targetValue);
                pStmt.setString(3, numericalAttrName);
            } else {
                pStmt = dbConn.prepareCall(QRY_CLASSIFICATION_NUMERICAL_COEFFICIENT);
                pStmt.setString(1, this.m_model.getName());
                pStmt.setObject(2, targetValue);
                pStmt.setString(3, numericalAttrName);
            }
            rs = pStmt.executeQuery();
            BigDecimal coefNumVal = null;
            if (rs.next()) {
                coefNumVal = rs.getBigDecimal("coefficient");
            }
            if (coefNumVal == null) {
                CategorySet targetSet = ((OraClassificationModel)this.m_model).getTargetCategorySet();
                Object[] targets = targetSet.getValues();
                if (targets.length == 2) {
                    for (int i = 0; i < targets.length; ++i) {
                        if (targetValue.toString() == targets[i].toString()) continue;
                        targetValue = targets[i];
                        break;
                    }
                    try {
                        if (this.m_normalizeTransform != null) {
                            String qry = QRY_DENORMALIZED_CLASSIFICATION_NUMERICAL_COEFFICIENT;
                            qry = MessageFormat.format(qry.replaceAll("'", "''"), this.m_normalizeTransform.getNormalizationDefinitionTable());
                            pStmt = dbConn.prepareCall(qry);
                            pStmt.setString(1, this.m_model.getName());
                            pStmt.setObject(2, targetValue);
                            pStmt.setString(3, numericalAttrName);
                        } else {
                            pStmt = dbConn.prepareCall(QRY_CLASSIFICATION_NUMERICAL_COEFFICIENT);
                            pStmt.setString(1, this.m_model.getName());
                            pStmt.setObject(2, targetValue);
                            pStmt.setString(3, numericalAttrName);
                        }
                        rs = pStmt.executeQuery();
                        coefNumVal = null;
                        if (rs.next()) {
                            coefNumVal = rs.getBigDecimal("coefficient");
                        }
                        if (coefNumVal == null) {
                            this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"coefficient", "model", "details"}, null);
                        }
                        coefNumVal = new BigDecimal(coefNumVal.doubleValue() * -1.0);
                    }
                    catch (SQLException sqlExp) {
                        throw new JDMException(1, "Failed in OraSVMClassificationModelDetail.getCoefficient(targetValue, numericalAttrName) method.");
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (SQLException sqlExp1) {}
                        try {
                            if (pStmt != null) {
                                pStmt.close();
                            }
                        }
                        catch (SQLException sqlExp1) {}
                    }
                }
                this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"coefficient", "model", "details"}, null);
            }
            double d = coefNumVal.doubleValue();
            return d;
        }
        catch (SQLException sqlExp) {
            throw new JDMException(1, "Failed in OraSVMClassificationModelDetail.getCoefficient(targetValue, numericalAttrName) method.");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
    }

    public double getBias(Object targetValue) throws JDMException {
        this.getValidationHandler().validateNotNull(targetValue, "targetValue");
        Connection dbConn = this.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            if (this.m_normalizeTransform != null) {
                String qry = QRY_DENORMALIZED_CLASSIFICATION_BIAS;
                qry = OraStringUtils.getReplacedString(qry, "<norm_table_name>", this.m_normalizeTransform.getNormalizationDefinitionTable());
                qry = OraStringUtils.getReplacedString(qry, "<model_name>", "'" + this.m_model.getName() + "'");
                qry = OraStringUtils.getReplacedString(qry, "<target>", targetValue instanceof String ? "'" + targetValue.toString() + "'" : targetValue.toString());
                pStmt = dbConn.prepareStatement(qry);
            } else {
                pStmt = dbConn.prepareCall(QRY_CLASSIFICATION_BIAS);
                pStmt.setString(1, this.m_model.getName());
                pStmt.setObject(2, targetValue);
            }
            rs = pStmt.executeQuery();
            BigDecimal biasVal = null;
            if (rs.next()) {
                biasVal = rs.getBigDecimal("bias");
            }
            if (biasVal == null) {
                CategorySet targetSet = ((OraClassificationModel)this.m_model).getTargetCategorySet();
                Object[] targets = targetSet.getValues();
                if (targets.length == 2) {
                    for (int i = 0; i < targets.length; ++i) {
                        if (targetValue.toString().equalsIgnoreCase(targets[i].toString())) continue;
                        targetValue = targets[i];
                        break;
                    }
                    try {
                        if (this.m_normalizeTransform != null) {
                            String qry = QRY_DENORMALIZED_CLASSIFICATION_BIAS;
                            qry = OraStringUtils.getReplacedString(qry, "<norm_table_name>", this.m_normalizeTransform.getNormalizationDefinitionTable());
                            qry = OraStringUtils.getReplacedString(qry, "<model_name>", "'" + this.m_model.getName() + "'");
                            qry = OraStringUtils.getReplacedString(qry, "<target>", targetValue instanceof String ? "'" + targetValue.toString() + "'" : targetValue.toString());
                            pStmt = dbConn.prepareStatement(qry);
                        } else {
                            pStmt = dbConn.prepareCall(QRY_CLASSIFICATION_BIAS);
                            pStmt.setString(1, this.m_model.getName());
                            pStmt.setObject(2, targetValue);
                        }
                        rs = pStmt.executeQuery();
                        biasVal = null;
                        if (rs.next()) {
                            biasVal = rs.getBigDecimal("bias");
                        }
                        if (biasVal == null) {
                            this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"bias", "model", "details"}, null);
                        }
                        biasVal = new BigDecimal(biasVal.doubleValue() * -1.0);
                    }
                    catch (SQLException sqlExp) {
                        throw new JDMException(1, "Failed in OraSVMClassificationModelDetail.getBias(targetValue) method.");
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (SQLException sqlExp1) {}
                        try {
                            if (pStmt != null) {
                                pStmt.close();
                            }
                        }
                        catch (SQLException sqlExp1) {}
                    }
                }
                this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"bias", "model", "details"}, null);
            }
            double d = biasVal.doubleValue();
            return d;
        }
        catch (SQLException sqlExp) {
            throw new JDMException(1, "Failed in OraSVMClassificationModelDetail.getBias(targetValue) method.");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
    }

    private void setup102() {
        if (this.is102()) {
            QRY_CLASSIFICATION_NUMERICAL_COEFFICIENT = "SELECT s.coefficient FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s WHERE t.class = ? AND s.attribute_name = ? AND s.attribute_value IS NULL";
            QRY_CLASSIFICATION_CATEGORICAL_COEFFICIENT = "SELECT s.coefficient FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s WHERE t.class = ? AND s.attribute_name = ? AND s.attribute_value = ?";
            QRY_DENORMALIZED_CLASSIFICATION_BIAS = "SELECT (s.coefficient - de_norm.sum_coefficient) as bias  FROM TABLE(dbms_data_mining.get_model_details_svm(<model_name>)) t,       TABLE(t.attribute_set) s,       (SELECT SUM(s.coefficient * n.shift / n.scale) as sum_coefficient         FROM TABLE(dbms_data_mining.get_model_details_svm(<model_name>)) t,              TABLE(t.attribute_set) s, <norm_table_name> n         WHERE t.class = <target>         AND s.attribute_name IS NOT NULL AND n.COL = s.attribute_name         AND n.scale <> 0) de_norm  WHERE t.class = <target> AND s.attribute_name IS NULL";
            QRY_DENORMALIZED_CLASSIFICATION_NUMERICAL_COEFFICIENT = "SELECT s.coefficient/n.scale as coefficient FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s, {0} n WHERE t.class = ? AND s.attribute_name = ? AND s.attribute_value IS NULL AND n.col = s.attribute_name and n.scale <> 0";
            QRY_DENORMALIZED_CLASSIFICATION_COEFFICIENTS_PER_ATTR = "SELECT s.attribute_value, s.coefficient/nvl(n.scale, 1) as coefficient  FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s, {0} n WHERE t.class = ? AND s.attribute_name = n.col (+) AND s.attribute_name = ? ORDER BY abs(coefficient) DESC, s.attribute_value";
            QRY_CLASSIFICATION_COEFFICIENTS_PER_ATTR = "SELECT s.attribute_value, s.coefficient FROM TABLE(dbms_data_mining.get_model_details_svm(?)) t, TABLE(t.attribute_set) s WHERE t.class = ? AND s.attribute_name = ? ORDER BY abs(s.coefficient) DESC, s.attribute_value";
        }
    }
}

