/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.modeldetail.glm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.SortOrder;
import javax.datamining.data.Interval;
import javax.datamining.data.IntervalClosure;
import javax.datamining.supervised.classification.ClassificationModel;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.base.OraModelDetail;
import oracle.dmt.jdm.modeldetail.glm.OraGLMModelDetail;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;

public class OraGLMModelDetailImpl
extends OraModelDetail
implements OraGLMModelDetail {
    private static String QRY_GLM_GLOBAL = "SELECT * FROM TABLE(dbms_data_mining.get_model_details_global(?)) ";
    private static String QRY_GLM = "SELECT * FROM TABLE(dbms_data_mining.get_model_details_glm(?)) ";
    private static List allowedOrderByKeys = Arrays.asList("COEFFICIENT", "STD_ERROR", "COEFFICIENT", "P_VALUE", "VIF");

    public OraGLMModelDetailImpl(OraConnection dmeConn, OraModel model) throws JDMException {
        super(dmeConn, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getGlobalDetails() {
        Connection dbConn = this.getDatabaseConnection();
        String modelName = this.m_model.getName();
        HashMap<String, Double> globalDeatilsMap = new HashMap<String, Double>();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dbConn.prepareStatement(QRY_GLM_GLOBAL);
            pStmt.setString(1, modelName);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                String key = rs.getString(1);
                double value = rs.getDouble(2);
                globalDeatilsMap.put(key, new Double(value));
            }
        }
        catch (Exception exp) {
            this.logTrace("Failed Operation: OraGLMModelDetailImpl.getGlobalDetails", exp);
            globalDeatilsMap = null;
            this.getConnection().createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, exp);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return globalDeatilsMap;
    }

    public ResultSet getAttributeCoefficients(String[] targetValuesFilter, String[] attributeNamesFilter, Map valueRangeFilters, Map orderBy) {
        int i;
        Connection dbConn = this.getDatabaseConnection();
        String modelName = this.m_model.getName();
        StringBuffer whereClause = new StringBuffer("WHERE ");
        StringBuffer orderByClause = null;
        Vector intvlRangeFilterVals = new Vector();
        boolean isClassification = false;
        if (this.m_model instanceof ClassificationModel) {
            isClassification = true;
        }
        if (isClassification && targetValuesFilter != null) {
            if (targetValuesFilter.length == 1) {
                whereClause.append(" CLASS='").append(targetValuesFilter[0]).append("' ");
            } else {
                whereClause.append(" CLASS IN (");
                for (i = 0; i < targetValuesFilter.length; ++i) {
                    whereClause.append("'").append(targetValuesFilter[i]).append(i == targetValuesFilter.length - 1 ? "' )" : "', ");
                }
            }
        }
        if (attributeNamesFilter != null) {
            if (whereClause.length() > 6) {
                whereClause.append(" AND ");
            }
            if (attributeNamesFilter.length == 1) {
                whereClause.append(" ATTRIBUTE_NAME='").append(attributeNamesFilter[0]).append("' ");
            } else {
                whereClause.append(" ATTRIBUTE_NAME IN (");
                for (i = 0; i < attributeNamesFilter.length; ++i) {
                    whereClause.append("'").append(attributeNamesFilter[i]).append(i == targetValuesFilter.length - 1 ? "' )" : "', ");
                }
            }
        }
        this.appendRangeFilterToWhereCluse(whereClause, valueRangeFilters, intvlRangeFilterVals);
        if (orderBy != null) {
            for (String key : orderBy.keySet()) {
                if (!allowedOrderByKeys.contains(key)) continue;
                if (orderByClause == null) {
                    orderByClause = new StringBuffer(" ORDER BY ");
                } else {
                    orderByClause.append(", ");
                }
                orderByClause.append(key);
                Object val = orderBy.get(key);
                if (SortOrder.descending.equals(val)) {
                    orderByClause.append(" DESC ");
                    continue;
                }
                if (!SortOrder.descending.equals(val)) continue;
                orderByClause.append(" ASC ");
            }
        }
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dbConn.prepareStatement(QRY_GLM);
            pStmt.setString(1, modelName);
            if (intvlRangeFilterVals != null) {
                for (int pIx = 0; pIx < intvlRangeFilterVals.size(); ++pIx) {
                    pStmt.setDouble(pIx + 2, (Double)intvlRangeFilterVals.elementAt(pIx));
                }
            }
            rs = pStmt.executeQuery();
        }
        catch (Exception exp) {
            this.logTrace("Failed Operation: OraGLMModelDetailImpl.getAttributeCoefficients", exp);
            this.getConnection().createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, exp);
        }
        return rs;
    }

    private void appendRangeFilterToWhereCluse(StringBuffer whereClause, Map valRangeFilters, Vector paramVector) {
        if (valRangeFilters != null && valRangeFilters.size() > 0) {
            Set entries = valRangeFilters.entrySet();
            for (Map.Entry entry : entries) {
                String param = " " + (String)entry.getKey() + " ";
                Interval intvl = (Interval)entry.getValue();
                double start = intvl.getStartPoint();
                double end = intvl.getEndPoint();
                String startCondition = " >= ";
                String endCondition = " <= ";
                IntervalClosure intvlClosure = intvl.getIntervalClosure();
                if (start == Double.NEGATIVE_INFINITY && end == Double.POSITIVE_INFINITY) continue;
                if (intvlClosure != null) {
                    if (IntervalClosure.closedClosed.equals((Object)intvlClosure)) {
                        startCondition = " >= ";
                        endCondition = " <= ";
                    } else if (IntervalClosure.closedOpen.equals((Object)intvlClosure)) {
                        startCondition = " >= ";
                        endCondition = " < ";
                    } else if (IntervalClosure.openClosed.equals((Object)intvlClosure)) {
                        startCondition = " > ";
                        endCondition = " <= ";
                    } else if (IntervalClosure.openOpen.equals((Object)intvlClosure)) {
                        startCondition = " > ";
                        endCondition = " < ";
                    }
                }
                if (whereClause.length() > 6) {
                    whereClause.append(" AND ");
                }
                if (start == Double.NEGATIVE_INFINITY) {
                    whereClause.append(param).append(endCondition).append("?");
                    paramVector.add(new Double(end));
                    continue;
                }
                if (end == Double.POSITIVE_INFINITY) {
                    whereClause.append(param).append(startCondition).append("?");
                    paramVector.add(new Double(start));
                    continue;
                }
                whereClause.append(param).append(startCondition).append("? AND ").append(param).append(endCondition).append("?");
                paramVector.add(new Double(start));
                paramVector.add(new Double(end));
            }
        }
    }
}

