/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.featureextraction;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.base.ModelDetail;
import oracle.dmt.jdm.OraMiningFunction;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.data.OraAttributeCoefficient;
import oracle.dmt.jdm.featureextraction.OraFeature;
import oracle.dmt.jdm.resource.OraConnection;

public class OraFeatureExtractionModel
extends OraModel {
    private static final String feature_id = "feature_id";
    private static final String attribute_name = "attribute_name";
    private static final String attribute_value = "attribute_value";
    private static final String attribute_coefficient = "coefficient";
    private static String QRY_GET_FEATURES = "SELECT feature_id FROM TABLE(dbms_data_mining.get_model_details_nmf(?)) ORDER BY feature_id asc";
    private static String QRY_GET_TOPN_FEATURES = "SELECT  feature_ranking.feature_id,         feature_ranking.attribute_name,         feature_ranking.attribute_value,         feature_ranking.coefficient,         rank FROM (        SELECT  t.feature_id,                 NVL2( a.attribute_subname, a.attribute_name || '.' || a.attribute_subname, a.attribute_name ) as attribute_name,                 a.attribute_value,                 a.coefficient,                 rank() over (partition by feature_id order by coefficient desc, attribute_name, attribute_subname, attribute_value) rank         FROM       TABLE(dbms_data_mining.get_model_details_nmf(?)) t, TABLE(t.attribute_set) a     ) feature_ranking where rank <= ? ";
    private static String QRY_GET_FEATURE_ATTRIBUTE_NAMES = "SELECT distinct attribute_name from (select NVL2( a.attribute_subname, a.attribute_name || '.' || a.attribute_subname , a.attribute_name) as attribute_name   FROM TABLE(dbms_data_mining.get_model_details_nmf(?)) t,   TABLE(t.attribute_set) a WHERE feature_id = ? )ORDER BY attribute_name ASC";
    private static String QRY_GET_FEATURE_COEFFICIENT_FOR_ATTRIBUTE = "SELECT a.attribute_value,  a.coefficient   FROM TABLE(dbms_data_mining.get_model_details_nmf(?)) t,   TABLE(t.attribute_set) a WHERE feature_id = ? and NVL2( a.attribute_subname, a.attribute_name || '.' || a.attribute_subname , a.attribute_name)=? ORDER BY a.coefficient DESC";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getFeatures(int topNCoefficient) throws JDMException {
        String modelName = this.getName();
        Connection dbConn = this.getDatabaseConnection();
        Vector<OraFeature> vFeatures = new Vector<OraFeature>();
        Vector vCoefficients = new Vector();
        Hashtable<Integer, OraFeature> htFeatures = new Hashtable<Integer, OraFeature>();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        try {
            pStmt = dbConn.prepareStatement(QRY_GET_TOPN_FEATURES);
            pStmt.setString(ind++, modelName);
            pStmt.setInt(ind++, topNCoefficient);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                int featureId = rs.getInt(feature_id);
                String attributeName = rs.getString(attribute_name);
                String value = rs.getString(attribute_value);
                double coefficient = rs.getDouble(attribute_coefficient);
                Integer FeatureId = new Integer(featureId);
                OraFeature oraFeature = (OraFeature)htFeatures.get(FeatureId);
                if (oraFeature == null) {
                    oraFeature = new OraFeature(this.getConnection(), this, featureId);
                    htFeatures.put(FeatureId, oraFeature);
                    vFeatures.add(oraFeature);
                }
                oraFeature.addAttributeName(attributeName);
                oraFeature.addCoefficient(new OraAttributeCoefficient(this.getConnection(), attributeName, value, coefficient));
            }
        }
        catch (SQLException sqlExp) {
            vFeatures = null;
            this.getConnection().createRuntimeException("2003", new Object[]{modelName}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return vFeatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getFeatures() throws JDMException {
        String modelName = this.getName();
        Connection dbConn = this.getDatabaseConnection();
        Vector<OraFeature> features = new Vector<OraFeature>();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        try {
            pStmt = dbConn.prepareStatement(QRY_GET_FEATURES);
            pStmt.setString(ind++, modelName);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                int featureId = rs.getInt(feature_id);
                OraFeature feature = new OraFeature(this.getConnection(), this, featureId);
                features.add(feature);
            }
        }
        catch (SQLException sqlExp) {
            features = null;
            this.getConnection().createRuntimeException("2003", new Object[]{modelName}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return features;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector getAttributeNames(int featureId) {
        String modelName = this.getName();
        Connection dbConn = this.getDatabaseConnection();
        Vector<String> attributeNames = new Vector<String>();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        try {
            pStmt = dbConn.prepareStatement(QRY_GET_FEATURE_ATTRIBUTE_NAMES);
            pStmt.setString(ind++, modelName);
            pStmt.setInt(ind++, featureId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                String attributeName = rs.getString(1);
                attributeNames.add(attributeName);
            }
        }
        catch (SQLException sqlExp) {
            attributeNames = null;
            this.getConnection().createRuntimeException("2004", new Object[]{modelName, String.valueOf(featureId)}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return attributeNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getAttributeCoefficients(int featureId, String attributeName) throws JDMException {
        String modelName = this.getName();
        Connection dbConn = this.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        LinkedHashMap<String, Double> coefficientsMap = new LinkedHashMap<String, Double>();
        try {
            pStmt = dbConn.prepareStatement(QRY_GET_FEATURE_COEFFICIENT_FOR_ATTRIBUTE);
            pStmt.setString(ind++, modelName);
            pStmt.setInt(ind++, featureId);
            pStmt.setString(ind++, attributeName);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                String value = rs.getString(attribute_value);
                double coefficient = rs.getDouble(attribute_coefficient);
                coefficientsMap.put(value, new Double(coefficient));
            }
        }
        catch (SQLException sqlExp) {
            coefficientsMap = null;
            this.getConnection().createRuntimeException("2005", new Object[]{modelName, String.valueOf(featureId)}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return coefficientsMap;
    }

    public OraFeatureExtractionModel(OraConnection dmeConn, String name) throws JDMException {
        super(dmeConn, name, OraMiningFunction.featureExtraction);
        this.setup102();
    }

    public ModelDetail getModelDetail() {
        return null;
    }

    private void setup102() {
        if (this.is102()) {
            QRY_GET_TOPN_FEATURES = "SELECT  feature_ranking.feature_id,         feature_ranking.attribute_name,         feature_ranking.attribute_value,         feature_ranking.coefficient,         rank FROM (        SELECT  t.feature_id,                 a.attribute_name,                 a.attribute_value,                 a.coefficient,                 rank() over (partition by feature_id order by coefficient desc, attribute_name, attribute_value) rank         FROM       TABLE(dbms_data_mining.get_model_details_nmf(?)) t, TABLE(t.attribute_set) a     ) feature_ranking where rank <= ? ";
            QRY_GET_FEATURE_COEFFICIENT_FOR_ATTRIBUTE = "SELECT a.attribute_value,  a.coefficient   FROM TABLE(dbms_data_mining.get_model_details_nmf(?)) t,   TABLE(t.attribute_set) a WHERE feature_id = ? and a.attribute_name=? ORDER BY a.coefficient DESC";
            QRY_GET_FEATURE_ATTRIBUTE_NAMES = "SELECT distinct attribute_name from (select a.attribute_name   FROM TABLE(dbms_data_mining.get_model_details_nmf(?)) t,   TABLE(t.attribute_set) a WHERE feature_id = ? )ORDER BY attribute_name ASC";
        }
    }
}

