/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.data;

import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.PhysicalAttribute;
import javax.datamining.data.PhysicalAttributeCapability;
import javax.datamining.data.PhysicalAttributeFactory;
import javax.datamining.data.PhysicalAttributeRole;
import javax.datamining.data.PhysicalDataSet;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraSupportedEnums;
import oracle.dmt.jdm.data.OraPhysicalAttribute;

public class OraPhysicalAttributeFactory
extends OraFactory
implements PhysicalAttributeFactory {
    PhysicalDataSet m_parentPDS = null;
    private static final OraSupportedEnums supportedCapabilities = new OraSupportedEnums(new Enum[]{PhysicalAttributeCapability.caseIdRequired});

    public PhysicalAttribute create(String attrName, AttributeDataType dataType) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateTableColumnName(attrName, "attrName");
        this.m_dmeConn.getValidationHandler().validateNotNull(dataType, "dataType");
        return new OraPhysicalAttribute(this.m_dmeConn, this.m_parentPDS, attrName, dataType);
    }

    public PhysicalAttribute[] create(String[] attrNameArray, AttributeDataType dataType) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateArray(attrNameArray, "attrNameArray");
        PhysicalAttribute[] attrs = new PhysicalAttribute[attrNameArray.length];
        for (int i = 0; i < attrNameArray.length; ++i) {
            attrs[i] = this.create(attrNameArray[i], dataType);
        }
        return attrs;
    }

    public PhysicalAttribute create(String attrName, AttributeDataType dataType, PhysicalAttributeRole role) throws JDMException {
        PhysicalAttribute attr = this.create(attrName, dataType);
        attr.setRole(role);
        return attr;
    }

    public boolean supportsCapability(PhysicalAttributeCapability capability) {
        this.m_dmeConn.getValidationHandler().validateNotNull(capability, "capability");
        return supportedCapabilities.isSupported((Enum)capability);
    }

    void setParentPDS(PhysicalDataSet parentPDS) {
        this.m_parentPDS = parentPDS;
    }
}

