/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.data;

import java.util.Hashtable;
import javax.datamining.JDMException;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.PhysicalAttribute;
import javax.datamining.data.PhysicalAttributeRole;
import javax.datamining.data.PhysicalDataSet;
import oracle.dmt.jdm.data.OraAttribute;
import oracle.dmt.jdm.data.OraPhysicalAttributeRole;
import oracle.dmt.jdm.resource.OraConnection;

public class OraPhysicalAttribute
extends OraAttribute
implements PhysicalAttribute {
    private static Hashtable m_supportedRoles = new Hashtable();
    private AttributeDataType m_dataType = null;
    private PhysicalAttributeRole m_role = null;
    private PhysicalDataSet m_parent = null;

    public AttributeDataType getDataType() {
        return this.m_dataType;
    }

    public void setDataType(AttributeDataType dataType) {
        this.getValidationHandler().validateNotNull(dataType, "dataType");
        this.m_dataType = dataType;
    }

    public PhysicalAttributeRole getRole() {
        return this.m_role;
    }

    public void setRole(PhysicalAttributeRole role) {
        this.getValidationHandler().validateNotNull(role, "role");
        if (!OraPhysicalAttribute.isRoleSupported(role)) {
            this.unsupported("PhysicalAttribute.setRole(PhysicalAttributeRole." + role.name() + ")");
        }
        if (this.m_parent != null && role.equals((Object)PhysicalAttributeRole.caseId)) {
            try {
                this.m_parent.removeAttribute(this.getName());
                this.m_parent.addAttribute((PhysicalAttribute)this);
            }
            catch (Exception e) {
                this.logTrace("Error removing case id:OraPhysicalAttribute.setRole", e);
            }
        }
        this.m_role = role;
    }

    protected OraPhysicalAttribute(OraConnection dmeComm, PhysicalDataSet parentDataSet, String name, AttributeDataType dataType) throws JDMException {
        super(dmeComm, name);
        this.getValidationHandler().validateNotNull(dataType, "dataType");
        this.m_dataType = dataType;
        this.m_parent = parentDataSet;
    }

    private static boolean isRoleSupported(PhysicalAttributeRole role) {
        Object obj = m_supportedRoles.get(role);
        return obj == null ? false : (Boolean)obj;
    }

    static {
        m_supportedRoles.put(PhysicalAttributeRole.caseId, Boolean.TRUE);
        m_supportedRoles.put(OraPhysicalAttributeRole.nestedTable, Boolean.TRUE);
        m_supportedRoles.put(PhysicalAttributeRole.data, Boolean.TRUE);
    }
}

