/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.data;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.TreeMap;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningFunction;
import javax.datamining.SortOrder;
import javax.datamining.data.ModelSignature;
import javax.datamining.data.SignatureAttribute;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.clustering.OraClusteringSignatureAttribute;
import oracle.dmt.jdm.data.OraSignatureAttribute;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;

public class OraModelSignature
extends OraDMObject
implements ModelSignature {
    private String m_modelName;
    private Vector m_signatureAttributes = null;
    private TreeMap m_signMap;
    private boolean m_rankAvailable = false;
    private MiningFunction m_minigFunction = null;
    private MiningAlgorithm m_minigAlgoritm = null;
    private static final String attribute_name = "attribute_name";
    private static final String attribute_type = "attribute_type";
    private static final String data_type = "data_type";
    private static String QRY_MODEL_SIGNATURE = "SELECT attribute_name, attribute_type, data_type  FROM USER_MINING_MODEL_ATTRIBUTES WHERE MODEL_NAME = ? and TARGET='NO' ORDER BY ATTRIBUTE_NAME ASC";
    private static String QRY_MODEL_SIGNATURE_ATTRIBUTE = "SELECT attribute_type  FROM USER_MINING_MODEL_ATTRIBUTES WHERE MODEL_NAME = ? and attribute_name=?";

    private void setup102() {
        if (this.is102()) {
            QRY_MODEL_SIGNATURE = "SELECT attribute_name, attribute_type  FROM TABLE(DBMS_DATA_MINING.GET_MODEL_SIGNATURE(?)) ORDER BY ATTRIBUTE_NAME ASC";
            QRY_MODEL_SIGNATURE_ATTRIBUTE = "SELECT attribute_type  FROM TABLE(DBMS_DATA_MINING.GET_MODEL_SIGNATURE(?)) WHERE attribute_name=?";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAttributes() {
        if (this.m_signatureAttributes.size() == 0) {
            Connection dbConn = this.getDatabaseConnection();
            PreparedStatement pStmt = null;
            ResultSet rs = null;
            int ind = 1;
            try {
                pStmt = dbConn.prepareStatement(QRY_MODEL_SIGNATURE);
                pStmt.setString(ind++, this.m_modelName);
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    String attributeType;
                    String attributeName = rs.getString(attribute_name);
                    String dataType = attributeType = rs.getString(attribute_type);
                    if (!this.is102()) {
                        dataType = rs.getString(data_type);
                    }
                    OraSignatureAttribute sa = this.m_minigFunction != null && this.m_minigFunction.equals((Object)MiningFunction.clustering) ? new OraClusteringSignatureAttribute(this.getConnection(), attributeName, OraPLSQLMappings.getAttributeType(attributeType), OraPLSQLMappings.getAttributeDataType(dataType), this.m_minigAlgoritm) : new OraSignatureAttribute(this.getConnection(), attributeName, OraPLSQLMappings.getAttributeType(attributeType), OraPLSQLMappings.getAttributeDataType(dataType));
                    this.m_signatureAttributes.add(sa);
                    this.m_signMap.put(sa.getName(), sa);
                }
            }
            catch (Exception sqlExp) {
                this.getConnection().createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp, "3517", new Object[]{this.m_modelName});
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sqlExp1) {}
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
                catch (SQLException sqlExp1) {}
            }
        }
        return this.m_signatureAttributes;
    }

    public SignatureAttribute getAttribute(String attributeName) throws JDMException {
        SignatureAttribute signatureAttribute;
        RuntimeException validateColExp = null;
        try {
            this.getValidationHandler().validateTableColumnName(attributeName, "attributeName");
        }
        catch (RuntimeException anyExp) {
            validateColExp = anyExp;
        }
        if (this.m_signatureAttributes.isEmpty()) {
            this.getAttributes();
        }
        if ((signatureAttribute = (SignatureAttribute)this.m_signMap.get(attributeName)) == null) {
            int firstDot = attributeName.indexOf(".");
            if (firstDot > 0) {
                signatureAttribute = (SignatureAttribute)this.m_signMap.get(attributeName.substring(0, firstDot));
            } else {
                if (validateColExp != null) {
                    throw validateColExp;
                }
                this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new Object[]{attributeName, "ModelSignature", ""}, null);
            }
        }
        return signatureAttribute;
    }

    public Collection getAttributesByRank(SortOrder ordering) throws JDMException {
        this.getValidationHandler().validateNotNull(ordering, "ordering");
        if (!this.m_rankAvailable) {
            return null;
        }
        if (ordering.equals((Object)SortOrder.descending)) {
            return this.m_signatureAttributes;
        }
        Vector signatureAttributes = new Vector();
        for (int i = this.m_signatureAttributes.size() - 1; i >= 0; ++i) {
            signatureAttributes.add(this.m_signatureAttributes.elementAt(i));
        }
        return signatureAttributes;
    }

    public OraModelSignature(OraConnection dmeConn, String modelName, MiningFunction minigFunction, MiningAlgorithm minigAlgoritm) throws JDMException {
        super(dmeConn, null);
        this.setup102();
        this.m_modelName = modelName;
        this.m_signatureAttributes = new Vector();
        this.m_signMap = new TreeMap();
        this.m_minigFunction = minigFunction;
        this.m_minigAlgoritm = minigAlgoritm;
    }

    public OraModelSignature(OraConnection dmeConn, String modelName, Vector rankedAttrs, Vector rankedImportance, Vector attributeRanks) throws JDMException {
        super(dmeConn, null);
        this.setup102();
        this.m_modelName = modelName;
        this.m_minigFunction = MiningFunction.attributeImportance;
        this.m_minigAlgoritm = OraMiningAlgorithm.minimumDescriptionLength;
        this.m_signatureAttributes = new Vector();
        this.m_signMap = new TreeMap();
        for (int i = 0; i < rankedAttrs.size(); ++i) {
            String attrName = (String)rankedAttrs.elementAt(i);
            OraSignatureAttribute sigAttr = this.m_minigFunction != null && this.m_minigFunction.equals((Object)MiningFunction.clustering) ? new OraClusteringSignatureAttribute(this.getConnection(), attrName) : new OraSignatureAttribute(this.getConnection(), attrName);
            Double importance = (Double)rankedImportance.elementAt(i);
            Integer rank = (Integer)attributeRanks.elementAt(i);
            sigAttr.setRank(rank);
            sigAttr.setImportance(importance);
            this.m_signatureAttributes.add(sigAttr);
            this.m_signMap.put(sigAttr.getName(), sigAttr);
        }
        this.m_rankAvailable = true;
    }
}

