/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.data;

import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.CategoryProperty;
import javax.datamining.data.CategorySet;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.resource.OraConnection;

public class OraCategorySet
extends OraDMObject
implements CategorySet {
    private CategoryProperty m_defaultCatProperty = CategoryProperty.valid;
    private Vector m_categoryVector = new Vector();
    private Vector m_categoryPropertyVector = new Vector();
    private AttributeDataType m_attrDataType = null;

    public OraCategorySet(OraConnection dmeConn, AttributeDataType attrDataType) {
        super(dmeConn, null);
        this.m_attrDataType = attrDataType;
    }

    OraCategorySet(OraConnection dmeConn, CategorySet catSet) {
        super(dmeConn, null);
        OraCategorySet catSetImpl = (OraCategorySet)catSet;
        this.m_attrDataType = catSetImpl.m_attrDataType;
        this.m_categoryVector = catSetImpl.m_categoryVector;
        this.m_categoryPropertyVector = catSetImpl.m_categoryPropertyVector;
        this.m_defaultCatProperty = catSetImpl.m_defaultCatProperty;
    }

    public int addCategory(Object categoryValue, CategoryProperty property) throws JDMException {
        this.getValidationHandler().validateCategory(categoryValue, "categoryValue");
        this.m_categoryVector.add(categoryValue);
        if (property == null) {
            this.m_categoryPropertyVector.add(this.m_defaultCatProperty);
        } else {
            this.m_categoryPropertyVector.add(property);
        }
        return this.m_categoryVector.size() - 1;
    }

    public void insertCategory(Object categoryValue, CategoryProperty property, int beforeIndex) throws JDMException {
        this.getValidationHandler().validateCategory(categoryValue, "categoryValue");
        this.getValidationHandler().validateNonNegative(beforeIndex, "beforeIndex");
        this.m_categoryVector.add(beforeIndex, categoryValue);
        if (property == null) {
            this.m_categoryPropertyVector.add(beforeIndex, this.m_defaultCatProperty);
        } else {
            this.m_categoryPropertyVector.add(beforeIndex, property);
        }
    }

    public void removeCategory(int index) throws JDMException {
        this.getValidationHandler().validateNonNegative(index, "index");
        this.m_categoryPropertyVector.remove(index);
        this.m_categoryVector.remove(index);
    }

    public int getSize() {
        return this.m_categoryVector.size();
    }

    public AttributeDataType getDataType() {
        return this.m_attrDataType;
    }

    public Integer getIndex(Object categoryValue) throws JDMException {
        this.getValidationHandler().validateCategory(categoryValue, "categoryValue");
        int index = this.m_categoryVector.indexOf(categoryValue);
        Integer index2 = null;
        if (index != -1) {
            index2 = new Integer(index);
        }
        return index2;
    }

    public Object getValue(int index) {
        this.getValidationHandler().validateNonNegative(index, "index");
        Object category = null;
        if (index < this.m_categoryVector.size()) {
            category = this.m_categoryVector.get(index);
        }
        return category;
    }

    public Object[] getValues() {
        return this.m_categoryVector.toArray();
    }

    public Object[] getValues(CategoryProperty property) throws JDMException {
        this.getValidationHandler().validateNotNull(property, "property");
        Vector propertyVector = new Vector();
        for (int i = 0; i < this.m_categoryVector.size(); ++i) {
            if (!this.m_categoryPropertyVector.get(i).equals(property)) continue;
            propertyVector.add(this.m_categoryVector.get(i));
        }
        return propertyVector.toArray();
    }

    public String getName(int index) {
        this.unsupported("CategorySet.getName(int index)");
        return null;
    }

    public void setName(int index, String categoryName) {
        this.unsupported("CategorySet.setName(int index, String categoryName)");
    }

    public CategoryProperty getProperty(int index) {
        this.getValidationHandler().validateNonNegative(index, "index");
        CategoryProperty property = null;
        if (index < this.m_categoryPropertyVector.size()) {
            property = (CategoryProperty)this.m_categoryPropertyVector.get(index);
        }
        return property;
    }

    public CategoryProperty getDefaultProperty() {
        return this.m_defaultCatProperty;
    }

    public void setDefaultProperty(CategoryProperty property) {
        this.m_defaultCatProperty = property;
    }
}

