/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.data.CategoryMatrix;
import javax.datamining.data.CategorySet;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.resource.OraConnection;

public abstract class OraCategoryMatrix
extends OraDMObject
implements CategoryMatrix {
    protected HashMap m_rowMap = new HashMap();
    protected HashMap m_countMap = new HashMap();
    protected TreeSet m_targetSet = new TreeSet();
    protected boolean m_indexTypeString = true;
    protected CategorySet m_categorySet = null;
    protected double m_defaultMatrixValue = 0.0;

    protected OraCategoryMatrix(OraConnection dmeConn, OraFactory factory) {
        super(dmeConn, factory);
    }

    public Collection getCategories() {
        return this.m_targetSet;
    }

    public Double getValue(Object rowCategoryValue, Object columnCategoryValue) throws JDMException {
        this.getValidationHandler().validateCategory(rowCategoryValue, "rowCategoryValue");
        this.getValidationHandler().validateCategory(columnCategoryValue, "columnCategoryValue");
        Vector colList = (Vector)this.m_rowMap.get(rowCategoryValue);
        if (colList == null) {
            return new Double(0.0);
        }
        int predictedIndex = colList.indexOf(columnCategoryValue);
        if (predictedIndex == -1) {
            return new Double(0.0);
        }
        Vector countList = (Vector)this.m_countMap.get(rowCategoryValue);
        Integer count = (Integer)countList.get(predictedIndex);
        return new Double(count.doubleValue());
    }

    public CategorySet getCategorySet() {
        return this.m_categorySet;
    }

    public double getCellValue(Object category1, Object category2) throws JDMException {
        Double val = this.getValue(category1, category2);
        if (val != null) {
            return val;
        }
        return this.m_defaultMatrixValue;
    }

    public void setCellValue(Object category1, Object category2, double cellVal) {
    }
}

