/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.clustering;

import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningFunction;
import javax.datamining.VerificationReport;
import javax.datamining.algorithm.kmeans.KMeansSettings;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.clustering.AggregationFunction;
import javax.datamining.clustering.AttributeComparisonFunction;
import javax.datamining.clustering.ClusteringSettings;
import javax.datamining.clustering.SimilarityMatrix;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.OraVerificationReport;
import oracle.dmt.jdm.algorithm.kmeans.OraKMeansSettingsFactory;
import oracle.dmt.jdm.base.OraBuildSettings;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;

public class OraClusteringSettings
extends OraBuildSettings
implements ClusteringSettings {
    private AggregationFunction m_aggregationFunction = AggregationFunction.systemDefault;
    private AttributeComparisonFunction m_comparisonFunction = AttributeComparisonFunction.systemDefault;
    private long m_minClusterCaseCount = 5L;
    private long m_maxClusterCaseCount = 1L;
    private static final int MAX_NUMBER_LEAF_CLUSTERS = 10;

    public int getMaxNumberOfClusters() {
        String maxNumberOfClusters = this.getValue("CLUS_NUM_CLUSTERS");
        return Integer.parseInt(maxNumberOfClusters);
    }

    public void setMaxNumberOfClusters(int maxClusters) {
        this.getValidationHandler().validateNumber(maxClusters, 1, "maxClusters");
        this.setValue("CLUS_NUM_CLUSTERS", Integer.toString(maxClusters));
    }

    public long getMinClusterCaseCount() {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "getMinClusterCaseCount"}, null);
        return this.m_minClusterCaseCount;
    }

    public void setMinClusterCaseCount(long minCaseCount) {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "setMinClusterCaseCount"}, null);
    }

    public long getMaxClusterCaseCount() {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "OraClusteringSettings.getMaxClusterCaseCount"}, null);
        return this.m_maxClusterCaseCount;
    }

    public void setMaxClusterCaseCount(long maxCount) {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "OraClusteringSettings.setMaxClusterCaseCount"}, null);
    }

    public AggregationFunction getAggregationFunction() {
        boolean bError = false;
        MiningAlgorithm ma = this.getAlgorithmSettings().getMiningAlgorithm();
        if (ma.equals((Object)MiningAlgorithm.kMeans)) {
            if (!(this.m_aggregationFunction.equals((Object)AggregationFunction.euclidean) || this.m_aggregationFunction.equals((Object)AggregationFunction.systemDefault) || this.m_aggregationFunction.equals((Object)AggregationFunction.systemDetermined))) {
                bError = true;
            }
        } else if (ma.equals((Object)OraMiningAlgorithm.oCluster) && !this.m_aggregationFunction.equals((Object)AggregationFunction.systemDefault) && !this.m_aggregationFunction.equals((Object)AggregationFunction.systemDetermined)) {
            bError = true;
        }
        if (bError) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "OraClusteringSettings.getAggregationFunction"}, null);
        }
        return this.m_aggregationFunction;
    }

    public void setAggregationFunction(AggregationFunction function) {
        boolean bError = false;
        MiningAlgorithm ma = this.getAlgorithmSettings().getMiningAlgorithm();
        if (ma.equals((Object)MiningAlgorithm.kMeans)) {
            if (function.equals((Object)AggregationFunction.euclidean) || function.equals((Object)AggregationFunction.systemDefault) || function.equals((Object)AggregationFunction.systemDetermined)) {
                this.m_aggregationFunction = function;
            } else {
                bError = true;
            }
        } else if (ma.equals((Object)OraMiningAlgorithm.oCluster)) {
            if (function.equals((Object)AggregationFunction.systemDefault) || function.equals((Object)AggregationFunction.systemDetermined)) {
                this.m_aggregationFunction = function;
            } else {
                bError = true;
            }
        }
        if (bError) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "OraClusteringSettings.setAggregationFunction"}, null);
        }
    }

    public VerificationReport verify() {
        StringBuffer error = new StringBuffer();
        boolean bError = false;
        MiningAlgorithm ma = this.getAlgorithmSettings().getMiningAlgorithm();
        if (ma.equals((Object)MiningAlgorithm.kMeans)) {
            if (!(this.m_aggregationFunction.equals((Object)AggregationFunction.euclidean) || this.m_aggregationFunction.equals((Object)AggregationFunction.systemDefault) || this.m_aggregationFunction.equals((Object)AggregationFunction.systemDetermined))) {
                error.append("\tAggregationFunction:" + this.m_aggregationFunction.name() + " does not match MiningAlgorithm kMeans\n");
                bError = true;
            }
        } else if (ma.equals((Object)OraMiningAlgorithm.oCluster) && !this.m_aggregationFunction.equals((Object)AggregationFunction.systemDefault) && !this.m_aggregationFunction.equals((Object)AggregationFunction.systemDetermined)) {
            error.append("\tAggregationFunction:" + this.m_aggregationFunction.name() + " does not match MiningAlgorithm oCluster\n");
            bError = true;
        }
        if (ma.equals((Object)MiningAlgorithm.kMeans)) {
            if (!(this.m_comparisonFunction.equals((Object)AttributeComparisonFunction.delta) || this.m_comparisonFunction.equals((Object)AttributeComparisonFunction.systemDefault) || this.m_comparisonFunction.equals((Object)AttributeComparisonFunction.systemDetermined))) {
                error.append("\tAttributeComparisonFunction:" + this.m_comparisonFunction.name() + " does not match MiningAlgorithm kMeans\n");
                bError = true;
            }
        } else if (ma.equals((Object)OraMiningAlgorithm.oCluster) && !this.m_comparisonFunction.equals((Object)AttributeComparisonFunction.systemDefault) && !this.m_comparisonFunction.equals((Object)AttributeComparisonFunction.systemDetermined)) {
            error.append("\tAttributeComparisonFunction:" + this.m_comparisonFunction.name() + " does not match MiningAlgorithm oCluster\n");
            bError = true;
        }
        return bError ? new OraVerificationReport("ERROR: failed to verify ClusterngSetting:" + error.toString()) : null;
    }

    public AttributeComparisonFunction getAttributeComparisonFunction(String logicalAttributeName) throws JDMException {
        boolean bError = false;
        MiningAlgorithm ma = this.getAlgorithmSettings().getMiningAlgorithm();
        if (ma.equals((Object)MiningAlgorithm.kMeans)) {
            if (!(this.m_comparisonFunction.equals((Object)AttributeComparisonFunction.delta) || this.m_comparisonFunction.equals((Object)AttributeComparisonFunction.systemDefault) || this.m_comparisonFunction.equals((Object)AttributeComparisonFunction.systemDetermined))) {
                bError = true;
            }
        } else if (ma.equals((Object)OraMiningAlgorithm.oCluster) && !this.m_comparisonFunction.equals((Object)AttributeComparisonFunction.systemDefault) && !this.m_comparisonFunction.equals((Object)AttributeComparisonFunction.systemDetermined)) {
            bError = true;
        }
        if (bError) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "OraClusteringSettings.getAttributeComparisonFunction"}, null);
        }
        return this.m_comparisonFunction;
    }

    public void setAttributeComparisonFunction(String logicalAttributeName, AttributeComparisonFunction function) throws JDMException {
        boolean bError = false;
        MiningAlgorithm ma = this.getAlgorithmSettings().getMiningAlgorithm();
        if (ma.equals((Object)MiningAlgorithm.kMeans)) {
            if (function.equals((Object)AttributeComparisonFunction.delta) || function.equals((Object)AttributeComparisonFunction.systemDefault) || function.equals((Object)AttributeComparisonFunction.systemDetermined)) {
                this.m_comparisonFunction = function;
            } else {
                bError = true;
            }
        } else if (ma.equals((Object)OraMiningAlgorithm.oCluster)) {
            if (function.equals((Object)AttributeComparisonFunction.systemDefault) || function.equals((Object)AttributeComparisonFunction.systemDetermined)) {
                this.m_comparisonFunction = function;
            } else {
                bError = true;
            }
        }
        if (bError) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "OraClusteringSettings.setAttributeComparisonFunction"}, null);
        }
    }

    public int getMaxLevels() {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "getMaxLevels"}, null);
        return 0;
    }

    public void setMaxLevels(int numberOfLevels) {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "setMaxLevels"}, null);
    }

    public SimilarityMatrix getSimilarityMatrix(String logicalAttributeName) throws JDMException {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "getSimilarityMatrix"}, null);
        return null;
    }

    public void setSimilarityMatrix(String logicalAttributeName, SimilarityMatrix matrix) throws JDMException {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "setSimilarityMatrix"}, null);
    }

    protected boolean isSupported(AlgorithmSettings algoSettings) {
        MiningAlgorithm miningAlgo = algoSettings.getMiningAlgorithm();
        return miningAlgo.equals((Object)MiningAlgorithm.kMeans) || miningAlgo.equals((Object)OraMiningAlgorithm.oCluster);
    }

    protected AlgorithmSettings getDefaultAlgorithmSettings() {
        KMeansSettings kmSettings = null;
        try {
            OraKMeansSettingsFactory kmeansFactory = (OraKMeansSettingsFactory)this.getConnection().getFactory("javax.datamining.algorithm.kmeans.KMeansSettings");
            kmSettings = kmeansFactory.create();
        }
        catch (Exception e) {
            kmSettings = null;
            this.logSevere("Failed to instantiate {0} in the {1}", new String[]{"KMeansSettings", "OraClusteringSettings"});
        }
        return kmSettings;
    }

    protected OraClusteringSettings(OraConnection dmeConn, OraFactory factory) throws JDMException {
        super(dmeConn, factory, MiningFunction.clustering);
        this.setValue("CLUS_NUM_CLUSTERS", Integer.toString(10));
    }
}

