/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.clustering;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.datamining.ComparisonOperator;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningFunction;
import javax.datamining.algorithm.kmeans.ClusteringDistanceFunction;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.base.ModelDetail;
import javax.datamining.clustering.Cluster;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.clustering.ClusteringModelProperty;
import javax.datamining.clustering.ClusteringSettings;
import javax.datamining.data.ModelSignature;
import javax.datamining.rule.BooleanOperator;
import javax.datamining.rule.Predicate;
import javax.datamining.rule.Rule;
import javax.datamining.rule.SimplePredicate;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.algorithm.kmeans.OraKMeansSettings;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.clustering.OraCluster;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.rule.OraClusterRule;
import oracle.dmt.jdm.rule.OraCompoundPredicate;
import oracle.dmt.jdm.rule.OraSimplePredicate;
import oracle.dmt.jdm.statistics.OraAttributeStatisticsSet;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransform;

public class OraClusteringModel
extends OraModel
implements ClusteringModel {
    private TreeMap m_clusters = null;
    private TreeMap m_leafs = null;
    private TreeMap m_roots = null;
    private TreeMap m_rules = null;
    private Hashtable m_splitRules = new Hashtable();
    private Integer m_numberLevels = null;
    private static final String cluster_id = "cluster_id";
    private static final String record_count = "record_count";
    private static final String parent_id = "parent_id";
    private static final String tree_level = "tree_level";
    private static final String dispersion = "dispersion";
    private static final String centroid_attribute_name = "centroid_attribute_name";
    private static final String centroid_mean = "centroid_mean";
    private static final String centroid_mode_value = "centroid_mode_value";
    private static final String cluster_count = "cluster_count";
    private static final String children_count = "children_count";
    private static final String parent_count = "parent_count";
    private static final String rule_id = "rule_id";
    private static final String rule_support = "rule_support";
    private static final String rule_confidence = "rule_confidence";
    private static final String hist_attribute_name = "hist_attribute_name";
    private static final String hist_bin_id = "hist_bin_id";
    private static final String hist_lower_bound = "hist_lower_bound";
    private static final String hist_upper_bound = "hist_upper_bound";
    private static final String hist_label = "hist_label";
    private static final String hist_frequency = "hist_frequency";
    private static final String attribute_name = "attribute_name";
    private static final String attribute_num_value = "attribute_num_value";
    private static final String attribute_str_value = "attribute_str_value";
    private static final String conditional_operator = "conditional_operator";
    private static String KMEANS_DETAILS_NEW = "  FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, ?, ?, ?, ?, ?)) {0} ) a ";
    private static String KMEANS_DETAILS_102 = "  FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, ?, ?, ?, ?)) {0} ) a ";
    private static String OCLUSTER_DETAILS = "  FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?)) {0} ) a ";
    private static String ORDER_BY_ID = "ORDER BY id";
    private static String QRY_ALL_CLUSTERS = "SELECT       id                              cluster_id,          record_count                  record_count,          parent                        parent_id,          tree_level                    tree_level,          dispersion                    dispersion FROM (SELECT *  {0} ";
    private static String DECODE_VIEW = "WITH label_view as (   SELECT col, bin,    Decode(bin,'1','[','(') || lv || ',' || val || ']' label     FROM (SELECT col, bin, last_value(val) over ( PARTITION BY col ORDER BY val rows BETWEEN unbounded preceding AND 1 preceding) lv, val ";
    private static String DECODE_VIEW_SPLIT_PREDICATE = "WITH label_view as (   SELECT col, bin,     val  label     FROM (SELECT col, bin, last_value(val) over ( PARTITION BY col ORDER BY val rows BETWEEN unbounded preceding AND 1 preceding) lv, val ";
    private static String QRY_CLUSTER_RULES = "SELECT          a.rule.rule_id                  rule_id,         a.rule.rule_support             rule_support,         a.rule.rule_confidence          rule_confidence,         a.record_count                  record_count FROM (SELECT *  {0} ";
    private static String QRY_ALL_RULES = "SELECT  a.id                            cluster_id,         a.rule.rule_id                  rule_id,         a.rule.rule_support             rule_support,         a.rule.rule_confidence          rule_confidence,         a.record_count                  record_count FROM (SELECT *  {0} ";
    private static String QRY_IS_ROOT_CLUSTER = "SELECT count (parent)                      parent_count FROM (SELECT *   {0} ";
    private static String QRY_IS_LEAF_CLUSTER = "SELECT count (ch.id)                      children_count FROM (SELECT *    {0} , TABLE(a.child) ch ";
    private static String QRY_LEAF_CLUSTERS = "SELECT       a.id                          cluster_id,          record_count                  record_count,          parent                        parent_id,          tree_level                    tree_level,          dispersion                    dispersion FROM (SELECT *  {0} , TABLE(a.child) ch WHERE ch.id is null";
    private static String QRY_ROOT_CLUSTERS = "SELECT       id                              cluster_id,          record_count                  record_count,          parent                        parent_id,          tree_level                    tree_level,          dispersion                    dispersion FROM (SELECT *  {0}  WHERE parent is null";
    private static String QRY_TREE_LEVEL_CLUSTERS = "SELECT count(distinct tree_level) cluster_count FROM   (SELECT *  {0} ";
    private static String QRY_NUMBER_CLUSTERS = "SELECT count(distinct id) cluster_count FROM   (SELECT *  {0} ";
    private static String QRY_GET_CLUSTER = "SELECT                record_count                  record_count,          parent                        parent_id,          tree_level                    tree_level,          dispersion                    dispersion FROM (SELECT *  {0} ";
    private static String QRY_GET_CHILDREN_CLUSTER = "SELECT       id                              cluster_id,         record_count                  record_count,          tree_level                    tree_level,          dispersion                    dispersion FROM (SELECT *  {0}  WHERE parent = ?";
    private static String QRY_GET_CENTROID_ALL = "SELECT           NVL2( cd.attribute_subname,  cd.attribute_name || '.' || cd.attribute_subname , cd.attribute_name) as attribute_name,    cd.mean                         centroid_mean,    cd.mode_value                   centroid_mode_value FROM (SELECT *  {0}  ,TABLE(a.centroid) cd ";
    private static String QRY_DECODE_GET_CENTROID_OC = "    FROM {0}) )  SELECT NVL((select label from label_view l where cd.mean=l.bin and col=cd.attribute_name), cd.mean) as centroid_mean,    cd.attribute_name               attribute_name,        NVL((select label from label_view l where cd.mode_value=l.bin and col=cd.attribute_name), cd.mode_value) centroid_mode_value  FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?))) a  ,TABLE(a.centroid) cd  ,label_view l   WHERE cd.attribute_name = l.col (+)  ";
    private static String QRY_DECODE_GET_CENTROID_KM = "WITH label_view as (  SELECT col, att, shift, scale     FROM {0} ) SELECT     NVL2( cd.attribute_subname,  cd.attribute_name || '.' || cd.attribute_subname , cd.attribute_name)               attribute_name,    (cd.mean*l.scale)+l.shift centroid_mean,    cd.mode_value                   centroid_mode_value  FROM (SELECT *  FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, ?, ?, ?, ?, ?))) a  ,TABLE(a.centroid) cd  ,label_view l   WHERE NVL2( cd.attribute_subname,  cd.attribute_name || '.' || cd.attribute_subname, cd.attribute_name ) = NVL2( l.att,  l.col || '.' || l.att, l.col ) ";
    private static String QRY_GET_SPLIT_PREDICATE = "SELECT                a.id                             cluster_id,                split.attribute_name   \t      attribute_name,                split.conditional_operator       conditional_operator,                split.attribute_num_value     attribute_num_value,                split.attribute_str_value     attribute_str_value FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?))) a,        TABLE(a.split_predicate) split";
    private static String QRY_DECODE_GET_SPLIT_PREDICATE = "    FROM {0}  ) ) SELECT               a.id                             cluster_id,               split.attribute_name             attribute_name,               split.conditional_operator       conditional_operator,                split.attribute_num_value     attribute_num_value,               NVL( split.attribute_str_value, (SELECT label from  label_view l where split.attribute_num_value=l.bin and  l.col=split.attribute_name)) as attribute_str_value     FROM (SELECT *      FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?))) a,            TABLE(a.split_predicate) split ";

    private void setup102() {
        if (this.is102()) {
            QRY_GET_CENTROID_ALL = "SELECT           cd.attribute_name               attribute_name,    cd.mean                         centroid_mean,    cd.mode_value                   centroid_mode_value FROM (SELECT *  {0}  ,TABLE(a.centroid) cd ";
            QRY_DECODE_GET_CENTROID_KM = "WITH label_view as (  SELECT col, shift, scale     FROM {0} ) SELECT     cd.attribute_name               attribute_name,    (cd.mean*l.scale)+l.shift centroid_mean,    cd.mode_value                   centroid_mode_value  FROM (SELECT *  FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, ?, ?, ?, ?))) a  ,TABLE(a.centroid) cd  ,label_view l   WHERE cd.attribute_name = l.col (+)  ";
        }
    }

    public Cluster getCluster(int identifier) throws JDMException {
        return this.internalGetCluster(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Cluster internalGetCluster(int identifier) throws JDMException {
        if (this.m_clusters != null && !this.m_clusters.isEmpty()) {
            return (Cluster)this.m_clusters.get(new Integer(identifier));
        }
        String modelName = this.getName();
        Connection dbConn = this.getDatabaseConnection();
        OraCluster cluster = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        try {
            pStmt = dbConn.prepareStatement(this.getQuery(QRY_GET_CLUSTER, null));
            pStmt.setString(ind++, modelName);
            pStmt.setInt(ind++, identifier);
            pStmt.setNull(ind++, 12);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            if (!this.is102() && MiningAlgorithm.kMeans.equals((Object)this.getMiningAlgorithm())) {
                pStmt.setNull(ind++, 12);
            }
            rs = pStmt.executeQuery();
            while (rs.next()) {
                long caseCount = rs.getInt(record_count);
                int parentId = rs.getInt(parent_id);
                Integer intParentId = rs.wasNull() ? null : new Integer(parentId);
                int treeLevel = rs.getInt(tree_level);
                double dVal = rs.getDouble(dispersion);
                cluster = new OraCluster(this.getConnection(), this, identifier, treeLevel, intParentId, caseCount, dVal);
            }
        }
        catch (SQLException sqlExp) {
            this.logTrace("Failed Operation: OraClusteringModel.getCluster: Cluster ID:" + identifier + ": ", sqlExp);
            cluster = null;
            this.getConnection().createRuntimeException("2002", new Object[]{modelName}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return cluster;
    }

    public int getNumberOfClusters() {
        return this.internalGetNumberOfClusters();
    }

    private synchronized int internalGetNumberOfClusters() {
        if (this.m_clusters != null && !this.m_clusters.isEmpty()) {
            return this.m_clusters.size();
        }
        return this.getNumberOfDisticntValues(this.getQuery(QRY_NUMBER_CLUSTERS, null), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumberOfDisticntValues(String query, Integer clusterId) {
        String modelName = this.getName();
        Connection dbConn = this.getDatabaseConnection();
        int distinctCount = 0;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        try {
            pStmt = dbConn.prepareStatement(query);
            pStmt.setString(ind++, modelName);
            if (clusterId == null) {
                pStmt.setNull(ind++, 4);
            } else {
                pStmt.setInt(ind++, clusterId);
            }
            pStmt.setNull(ind++, 12);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            if (!this.is102() && MiningAlgorithm.kMeans.equals((Object)this.getMiningAlgorithm())) {
                pStmt.setNull(ind++, 12);
            }
            rs = pStmt.executeQuery();
            while (rs.next()) {
                distinctCount = rs.getInt(1);
            }
        }
        catch (SQLException sqlExp) {
            this.logTrace("Failed Operation: OraClusteringModel.getNumberOfDisticntValues: Model name:" + modelName + ": ", sqlExp);
            distinctCount = 0;
            this.getConnection().createRuntimeException("2002", new Object[]{modelName}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return distinctCount;
    }

    public int getNumberOfLevels() {
        if (this.m_numberLevels != null) {
            return this.m_numberLevels;
        }
        this.m_numberLevels = new Integer(this.getNumberOfDisticntValues(this.getQuery(QRY_TREE_LEVEL_CLUSTERS, null), null));
        return this.m_numberLevels;
    }

    public Collection getRootClusters() {
        return this.internalGetRootClusters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Collection internalGetRootClusters() {
        if (this.m_roots != null) {
            return this.m_roots.values();
        }
        String modelName = this.getName();
        Connection dbConn = this.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        try {
            pStmt = dbConn.prepareStatement(this.getQuery(QRY_ROOT_CLUSTERS, ORDER_BY_ID));
            pStmt.setString(ind++, modelName);
            pStmt.setNull(ind++, 4);
            pStmt.setNull(ind++, 12);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            if (!this.is102() && MiningAlgorithm.kMeans.equals((Object)this.getMiningAlgorithm())) {
                pStmt.setNull(ind++, 12);
            }
            rs = pStmt.executeQuery();
            while (rs.next()) {
                int clusterId = rs.getInt(cluster_id);
                long caseCount = rs.getInt(record_count);
                int treeLevel = rs.getInt(tree_level);
                double dVal = rs.getDouble(dispersion);
                OraCluster cluster = new OraCluster(this.getConnection(), this, clusterId, treeLevel, null, caseCount, dVal);
                if (this.m_roots == null) {
                    this.m_roots = new TreeMap();
                }
                this.m_roots.put(new Integer(cluster.getClusterId()), cluster);
            }
        }
        catch (Exception sqlExp) {
            this.logTrace("Failed Operation: OraClusteringModel.getRootClusters: Model name:" + modelName + ": ", sqlExp);
            if (this.m_roots != null) {
                this.m_roots.clear();
            }
            this.getConnection().createRuntimeException("2002", new Object[]{modelName}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return this.m_roots.values();
    }

    public Collection getClusters() {
        return this.internalGetClusters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Collection internalGetClusters() {
        if (this.m_clusters != null) {
            return this.m_clusters.values();
        }
        if (this.m_leafs != null) {
            this.m_leafs.clear();
        }
        if (this.m_roots != null) {
            this.m_roots.clear();
        }
        String modelName = this.getName();
        Hashtable<Integer, OraCluster> htIdtoClusterMap = new Hashtable<Integer, OraCluster>();
        Hashtable<Integer, Cluster[]> htParentIdtoChildren = new Hashtable<Integer, Cluster[]>();
        Connection dbConn = this.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        this.m_clusters = new TreeMap();
        try {
            pStmt = dbConn.prepareStatement(this.getQuery(QRY_ALL_CLUSTERS, ORDER_BY_ID));
            pStmt.setString(ind++, modelName);
            pStmt.setNull(ind++, 4);
            pStmt.setNull(ind++, 12);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            if (!this.is102() && MiningAlgorithm.kMeans.equals((Object)this.getMiningAlgorithm())) {
                pStmt.setNull(ind++, 12);
            }
            rs = pStmt.executeQuery();
            while (rs.next()) {
                Cluster[] arChildren;
                int clusterId = rs.getInt(cluster_id);
                long caseCount = rs.getInt(record_count);
                int parentId = rs.getInt(parent_id);
                Integer intParentId = rs.wasNull() ? null : new Integer(parentId);
                int treeLevel = rs.getInt(tree_level);
                double dVal = rs.getDouble(dispersion);
                OraCluster cluster = new OraCluster(this.getConnection(), this, clusterId, treeLevel, intParentId, caseCount, dVal);
                this.m_clusters.put(new Integer(cluster.getClusterId()), cluster);
                htIdtoClusterMap.put(new Integer(clusterId), cluster);
                if (intParentId == null) {
                    intParentId = new Integer(0);
                    if (this.m_roots == null) {
                        this.m_roots = new TreeMap();
                    }
                    this.m_roots.put(new Integer(cluster.getClusterId()), cluster);
                }
                if ((arChildren = (Cluster[])htParentIdtoChildren.get(intParentId)) == null) {
                    arChildren = new Cluster[2];
                    htParentIdtoChildren.put(intParentId, arChildren);
                    arChildren[0] = cluster;
                    continue;
                }
                if (arChildren[0].getClusterId() > cluster.getClusterId()) {
                    arChildren[1] = arChildren[0];
                    arChildren[0] = cluster;
                    continue;
                }
                arChildren[1] = cluster;
            }
            Set allClusterSet = this.m_clusters.keySet();
            for (Integer clId : allClusterSet) {
                Integer thisClusterId;
                Cluster[] childrenClusters;
                OraCluster parentCluster;
                OraCluster oraCluster = (OraCluster)this.m_clusters.get(clId);
                Integer parentID = oraCluster.getParentId();
                if (parentID != null && (parentCluster = (OraCluster)htIdtoClusterMap.get(parentID)) != null) {
                    oraCluster.setParentCluster(parentCluster);
                }
                if ((childrenClusters = (Cluster[])htParentIdtoChildren.get(thisClusterId = new Integer(oraCluster.getClusterId()))) != null && 0 != childrenClusters.length) {
                    oraCluster.setChildren(childrenClusters);
                    continue;
                }
                if (this.m_leafs == null) {
                    this.m_leafs = new TreeMap();
                }
                this.m_leafs.put(new Integer(oraCluster.getClusterId()), oraCluster);
            }
        }
        catch (Exception exp) {
            this.logTrace("Failed Operation: OraClusteringModel.getClusters: Model name:" + modelName + ": ", exp);
            if (this.m_clusters != null) {
                this.m_clusters.clear();
            }
            if (this.m_leafs != null) {
                this.m_leafs.clear();
            }
            if (this.m_roots != null) {
                this.m_roots.clear();
            }
            this.getConnection().createRuntimeException("2002", new Object[]{modelName}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return this.m_clusters.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection getChildClusters(int parentId) throws JDMException {
        String modelName = this.getName();
        Vector<OraCluster> clusters = new Vector<OraCluster>();
        Connection dbConn = this.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        try {
            pStmt = dbConn.prepareStatement(this.getQuery(QRY_GET_CHILDREN_CLUSTER, ORDER_BY_ID));
            pStmt.setString(ind++, modelName);
            pStmt.setInt(ind++, parentId);
            pStmt.setNull(ind++, 12);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            if (!this.is102() && MiningAlgorithm.kMeans.equals((Object)this.getMiningAlgorithm())) {
                pStmt.setNull(ind++, 12);
            }
            rs = pStmt.executeQuery();
            while (rs.next()) {
                int clusterId = rs.getInt(cluster_id);
                long caseCount = rs.getInt(record_count);
                int treeLevel = rs.getInt(tree_level);
                double dVal = rs.getDouble(dispersion);
                OraCluster cluster = new OraCluster(this.getConnection(), this, clusterId, treeLevel, new Integer(parentId), caseCount, dVal);
                clusters.add(cluster);
            }
        }
        catch (SQLException sqlExp) {
            this.logTrace("Failed Operation: OraClusteringModel.getChildClusters: Parent cluster id:" + parentId + ": ", sqlExp);
            clusters.clear();
            this.getConnection().createRuntimeException("2002", new Object[]{modelName}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return clusters;
    }

    boolean isLeaf(int clusterId) throws JDMException {
        int count = this.getNumberOfDisticntValues(this.getQuery(QRY_IS_LEAF_CLUSTER, null), new Integer(clusterId));
        return count == 0;
    }

    boolean isRoot(int clusterId) throws JDMException {
        int count = this.getNumberOfDisticntValues(this.getQuery(QRY_IS_ROOT_CLUSTER, null), new Integer(clusterId));
        return count == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeMap getCentroids(int clusterId) throws JDMException {
        String modelName = this.getName();
        Connection dbConn = this.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        TreeMap<String, Object> centroids = new TreeMap<String, Object>();
        String histogramQuery = "";
        histogramQuery = this.m_buildTransform != null ? this.getCentroidQueryDecode(QRY_GET_CENTROID_ALL, null) : this.getQuery(QRY_GET_CENTROID_ALL, null);
        try {
            pStmt = dbConn.prepareStatement(histogramQuery);
            pStmt.setString(ind++, modelName);
            pStmt.setInt(ind++, clusterId);
            pStmt.setNull(ind++, 12);
            pStmt.setInt(ind++, 1);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            if (!this.is102() && MiningAlgorithm.kMeans.equals((Object)this.getMiningAlgorithm())) {
                pStmt.setNull(ind++, 12);
            }
            rs = pStmt.executeQuery();
            while (rs.next()) {
                Double dblMean;
                String attributeName;
                block28: {
                    attributeName = rs.getString(attribute_name);
                    dblMean = null;
                    String valMean = rs.getString(centroid_mean);
                    if (valMean != null) {
                        try {
                            double dval = Double.parseDouble(valMean);
                            dblMean = new Double(dval);
                        }
                        catch (Exception nex1) {
                            int index3;
                            int index2;
                            int index1 = valMean.indexOf("(");
                            if (index1 == -1 || (index2 = valMean.indexOf(",")) == -1 || (index3 = valMean.indexOf("]")) == -1) break block28;
                            String low = valMean.substring(index1 + 1, index2);
                            String high = valMean.substring(index2 + 1, index3);
                            try {
                                double dvalLow = Double.parseDouble(low);
                                double dvalHigh = Double.parseDouble(high);
                                dblMean = new Double((dvalLow + dvalHigh) / 2.0);
                            }
                            catch (Exception nex2) {}
                        }
                    }
                }
                String modeValue = rs.getString(centroid_mode_value);
                Object value = null;
                value = modeValue != null ? modeValue : dblMean;
                centroids.put(attributeName, value);
            }
        }
        catch (SQLException sqlExp) {
            this.logTrace("Failed Operation: OraClusteringModel.getCentroids: cluster id:" + clusterId, sqlExp);
            centroids = null;
            this.getConnection().createRuntimeException("2002", new Object[]{modelName}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return centroids;
    }

    public Collection getLeafClusters() {
        return this.internalGetLeafClusters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Collection internalGetLeafClusters() {
        if (this.m_leafs != null) {
            return this.m_leafs.values();
        }
        String modelName = this.getName();
        Connection dbConn = this.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        try {
            pStmt = dbConn.prepareStatement(this.getQuery(QRY_LEAF_CLUSTERS, ORDER_BY_ID));
            pStmt.setString(ind++, modelName);
            pStmt.setNull(ind++, 4);
            pStmt.setNull(ind++, 12);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            if (!this.is102() && MiningAlgorithm.kMeans.equals((Object)this.getMiningAlgorithm())) {
                pStmt.setNull(ind++, 12);
            }
            rs = pStmt.executeQuery();
            while (rs.next()) {
                int clusterId = rs.getInt(cluster_id);
                long caseCount = rs.getInt(record_count);
                int parentId = rs.getInt(parent_id);
                Integer intParentId = rs.wasNull() ? null : new Integer(parentId);
                int treeLevel = rs.getInt(tree_level);
                double dVal = rs.getDouble(dispersion);
                OraCluster cluster = new OraCluster(this.getConnection(), this, clusterId, treeLevel, intParentId, caseCount, dVal);
                if (this.m_leafs == null) {
                    this.m_leafs = new TreeMap();
                }
                this.m_leafs.put(new Integer(cluster.getClusterId()), cluster);
            }
        }
        catch (Exception exp) {
            this.logTrace("Failed Operation: OraClusteringModel.getLeafClusters: Model name:" + modelName + ": ", exp);
            if (this.m_leafs != null) {
                this.m_leafs.clear();
            }
            this.getConnection().createRuntimeException("2002", new Object[]{modelName}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return this.m_leafs.values();
    }

    public Double getSimilarity(int clusterIdentifier1, int clusterIdentifier2) throws JDMException {
        return null;
    }

    public boolean hasProperty(ClusteringModelProperty property) {
        if (property.equals((Object)ClusteringModelProperty.centroid)) {
            return true;
        }
        if (property.equals((Object)ClusteringModelProperty.hierarchy)) {
            return true;
        }
        if (property.equals((Object)ClusteringModelProperty.rules)) {
            return true;
        }
        if (property.equals((Object)ClusteringModelProperty.splitPredicate)) {
            return true;
        }
        return property.equals((Object)ClusteringModelProperty.statistics);
    }

    public ModelDetail getModelDetail() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Rule getRule(int clusterId) throws JDMException {
        String modelName = this.getName();
        Connection dbConn = this.getDatabaseConnection();
        MiningAlgorithm ma = this.getMiningAlgorithm();
        int modelType = 1;
        if (ma.equals((Object)MiningAlgorithm.kMeans)) {
            modelType = 0;
        }
        ClusteringDistanceFunction dFunction = null;
        ClusteringSettings buildSettings = (ClusteringSettings)this.getBuildSettings();
        AlgorithmSettings algSettings = buildSettings.getAlgorithmSettings();
        if (algSettings instanceof OraKMeansSettings) {
            OraKMeansSettings kmSettings = (OraKMeansSettings)algSettings;
            dFunction = kmSettings.getDistanceFunction();
        }
        OraClusterRule rule = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        try {
            pStmt = dbConn.prepareStatement(this.getQuery(QRY_CLUSTER_RULES, null));
            pStmt.setString(ind++, modelName);
            pStmt.setInt(ind++, clusterId);
            pStmt.setNull(ind++, 12);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 1);
            if (!this.is102() && MiningAlgorithm.kMeans.equals((Object)this.getMiningAlgorithm())) {
                pStmt.setNull(ind++, 12);
            }
            rs = pStmt.executeQuery();
            while (rs.next()) {
                int ruleId = rs.getInt(rule_id);
                double dRuleSupport = rs.getDouble(rule_support);
                double dRuleConfidence = rs.getDouble(rule_confidence);
                long caseCount = rs.getInt(record_count);
                rule = new OraClusterRule(this.getConnection(), modelName, modelType, clusterId, ruleId, dRuleSupport / (double)caseCount, dRuleConfidence, this.m_buildTransform, dFunction);
            }
        }
        catch (SQLException sqlExp) {
            this.logTrace("Failed Operation: OraClusteringModel.getRule: Cluster id" + clusterId, sqlExp);
            rule = null;
            this.getConnection().createRuntimeException("2002", new Object[]{modelName}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return rule;
    }

    public Collection getRules() throws JDMException {
        return this.internalGetRules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Collection internalGetRules() throws JDMException {
        if (this.m_rules != null) {
            return this.m_rules.values();
        }
        String modelName = this.getName();
        Connection dbConn = this.getDatabaseConnection();
        MiningAlgorithm ma = this.getMiningAlgorithm();
        int modelType = 1;
        if (ma.equals((Object)MiningAlgorithm.kMeans)) {
            modelType = 0;
        }
        ClusteringDistanceFunction dFunction = null;
        ClusteringSettings buildSettings = (ClusteringSettings)this.getBuildSettings();
        AlgorithmSettings algSettings = buildSettings.getAlgorithmSettings();
        if (algSettings instanceof OraKMeansSettings) {
            OraKMeansSettings kmSettings = (OraKMeansSettings)algSettings;
            dFunction = kmSettings.getDistanceFunction();
        }
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        try {
            pStmt = dbConn.prepareStatement(this.getQuery(QRY_ALL_RULES, ORDER_BY_ID));
            pStmt.setString(ind++, modelName);
            pStmt.setNull(ind++, 4);
            pStmt.setNull(ind++, 12);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 1);
            if (!this.is102() && MiningAlgorithm.kMeans.equals((Object)this.getMiningAlgorithm())) {
                pStmt.setNull(ind++, 12);
            }
            rs = pStmt.executeQuery();
            while (rs.next()) {
                int clusterId = rs.getInt(cluster_id);
                int ruleId = rs.getInt(rule_id);
                double dRuleSupport = rs.getDouble(rule_support);
                double dRuleConfidence = rs.getDouble(rule_confidence);
                long caseCount = rs.getInt(record_count);
                OraClusterRule rule = new OraClusterRule(this.getConnection(), modelName, modelType, clusterId, ruleId, dRuleSupport / (double)caseCount, dRuleConfidence, this.m_buildTransform, dFunction);
                if (this.m_rules == null) {
                    this.m_rules = new TreeMap();
                }
                this.m_rules.put(new Integer(ruleId), rule);
            }
        }
        catch (SQLException sqlExp) {
            this.logTrace("Failed Operation: OraClusteringModel.getRules", sqlExp);
            if (this.m_rules != null) {
                this.m_rules.clear();
            }
            this.getConnection().createRuntimeException("2002", new Object[]{modelName}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return this.m_rules.values();
    }

    public OraClusteringModel(OraConnection dmeConn, String name) throws JDMException {
        super(dmeConn, name, MiningFunction.clustering);
        this.setup102();
    }

    OraAttributeStatisticsSet getAttributeStatisticsSet(int clusterId) throws JDMException {
        String modelName = this.getName();
        ModelSignature modelSignature = this.getSignature();
        OraAttributeStatisticsSet attributeStats = new OraAttributeStatisticsSet(this.getConnection(), this, modelSignature, clusterId, this.m_buildTransform);
        return attributeStats;
    }

    private boolean isEucledian() {
        OraKMeansSettings kmSettings;
        ClusteringDistanceFunction dFunction = null;
        ClusteringSettings buildSettings = (ClusteringSettings)this.getBuildSettings();
        AlgorithmSettings algSettings = buildSettings.getAlgorithmSettings();
        return algSettings instanceof OraKMeansSettings && (dFunction = (kmSettings = (OraKMeansSettings)algSettings).getDistanceFunction()).equals((Object)ClusteringDistanceFunction.euclidean);
    }

    private String getXformTableName() {
        if (this.m_buildTransform instanceof OraNormalizeTransform) {
            return ((OraNormalizeTransform)this.m_buildTransform).getNormalizationDefinitionTable();
        }
        if (this.m_buildTransform instanceof OraBinningTransform) {
            return ((OraBinningTransform)this.m_buildTransform).getNumericalBinTable();
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getCentroidQueryDecode(String query, String orderBy) {
        String resultquery = null;
        MiningAlgorithm ma = this.getMiningAlgorithm();
        if (!ma.equals((Object)MiningAlgorithm.kMeans)) return DECODE_VIEW + MessageFormat.format(QRY_DECODE_GET_CENTROID_OC.replaceAll("'", "''"), this.getXformTableName());
        if (!this.isEucledian()) return this.getQuery(query, orderBy);
        return MessageFormat.format(QRY_DECODE_GET_CENTROID_KM.replaceAll("'", "''"), this.getXformTableName());
    }

    public String getQuery(String query, String orderBy) {
        String resultquery = null;
        MiningAlgorithm ma = this.getMiningAlgorithm();
        resultquery = ma.equals((Object)MiningAlgorithm.kMeans) ? (this.is102() ? MessageFormat.format(query.replaceAll("'", "''"), KMEANS_DETAILS_102) : MessageFormat.format(query.replaceAll("'", "''"), KMEANS_DETAILS_NEW)) : MessageFormat.format(query.replaceAll("'", "''"), OCLUSTER_DETAILS);
        String finalQuery = null;
        finalQuery = orderBy != null ? MessageFormat.format(resultquery.replaceAll("'", "''"), orderBy) : MessageFormat.format(resultquery.replaceAll("'", "''"), "");
        return finalQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Predicate getSplitPredicate(int clusterId) throws JDMException {
        if (!this.m_splitRules.isEmpty()) {
            return (OraCompoundPredicate)this.m_splitRules.get(new Integer(clusterId));
        }
        String modelName = this.getName();
        Connection dbConn = this.getDatabaseConnection();
        OraCompoundPredicate splitPredicate = null;
        String attributeName = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        String query = "";
        Hashtable splitRules = new Hashtable();
        query = this.m_buildTransform != null ? DECODE_VIEW_SPLIT_PREDICATE + MessageFormat.format(QRY_DECODE_GET_SPLIT_PREDICATE.replaceAll("'", "''"), this.getXformTableName()) : QRY_GET_SPLIT_PREDICATE;
        try {
            pStmt = dbConn.prepareStatement(query);
            pStmt.setString(ind++, modelName);
            pStmt.setNull(ind++, 4);
            pStmt.setNull(ind++, 12);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 1);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                InternalData it;
                int currentClusterId = rs.getInt(cluster_id);
                attributeName = rs.getString(attribute_name);
                String condOp = rs.getString(conditional_operator);
                double dnumericalValue = rs.getDouble(attribute_num_value);
                Double numericalValue = rs.wasNull() ? null : new Double(dnumericalValue);
                String attributeStrVal = rs.getString(attribute_str_value);
                Integer clId = new Integer(currentClusterId);
                TreeMap<String, InternalData> splitPredicates = (TreeMap<String, InternalData>)splitRules.get(clId);
                if (splitPredicates == null) {
                    splitPredicates = new TreeMap<String, InternalData>();
                    splitRules.put(clId, splitPredicates);
                }
                if ((it = (InternalData)splitPredicates.get(attributeName)) == null) {
                    if (this.m_buildTransform == null) {
                        splitPredicates.put(attributeName, new InternalData(OraPLSQLMappings.getComparisonOperator(condOp), numericalValue, attributeStrVal));
                        continue;
                    }
                    splitPredicates.put(attributeName, new InternalData(OraPLSQLMappings.getComparisonOperator(condOp), null, attributeStrVal));
                    continue;
                }
                it.addCatValue(attributeStrVal);
            }
            if (!splitRules.isEmpty()) {
                Enumeration enumClusterids = splitRules.keys();
                while (enumClusterids.hasMoreElements()) {
                    Integer clId = (Integer)enumClusterids.nextElement();
                    TreeMap splitPredicates = (TreeMap)splitRules.get(clId);
                    if (splitPredicates.isEmpty()) continue;
                    Vector<OraSimplePredicate> predicates = new Vector<OraSimplePredicate>();
                    Set keys = splitPredicates.keySet();
                    Iterator iter = keys.iterator();
                    if (iter.hasNext()) {
                        String attrName = (String)iter.next();
                        InternalData it = (InternalData)splitPredicates.get(attrName);
                        OraSimplePredicate sPredicate = new OraSimplePredicate(this.getConnection(), attrName, it.compOperator, it.numericalValue, it.getCategories());
                        predicates.add(sPredicate);
                    }
                    splitPredicate = new OraCompoundPredicate(this.getConnection(), (Predicate[])predicates.toArray(new SimplePredicate[predicates.size()]), BooleanOperator.and);
                    this.m_splitRules.put(clId, splitPredicate);
                }
            }
            splitPredicate = (OraCompoundPredicate)this.m_splitRules.get(new Integer(clusterId));
        }
        catch (SQLException sqlExp) {
            this.logTrace("Failed Operation: OraClusteringModel.getSplitPredicate: cluster id:" + clusterId + ": Attribute name:" + attributeName, sqlExp);
            splitPredicate = null;
            this.getConnection().createRuntimeException("2002", new Object[]{modelName}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return splitPredicate;
    }

    private class InternalData {
        ComparisonOperator compOperator;
        Double numericalValue;
        Vector catValues = new Vector();

        InternalData(ComparisonOperator compOperator, Double numericalValue, String category) {
            this.compOperator = compOperator;
            this.numericalValue = numericalValue;
            this.addCatValue(category);
        }

        void addCatValue(String category) {
            if (category != null) {
                this.catValues.add(category);
            }
        }

        Object[] getCategories() {
            if (this.catValues.isEmpty()) {
                return null;
            }
            return this.catValues.toArray(new Object[this.catValues.size()]);
        }
    }

    class Centroid {
        String m_attributeName;
        Double m_dblMean;
        String m_modeValue;
        Double m_dValVariance;

        Centroid(String attributeName, Double dblMean, String modeValue, Double dValVariance) {
            this.m_attributeName = attributeName;
            this.m_dblMean = dblMean;
            this.m_modeValue = modeValue;
            this.m_dValVariance = dValVariance;
        }
    }
}

