/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.clustering;

import java.util.Vector;
import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningFunction;
import javax.datamining.clustering.ClusteringApplyContent;
import javax.datamining.clustering.ClusteringApplySettings;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.task.apply.OraApplySettings;

public class OraClusteringApplySettings
extends OraApplySettings
implements ClusteringApplySettings {
    private static final String OP_CLUSTER_ID = "CLUSTER_ID";
    private static final String OP_PROBABILITY = "CLUSTER_PROBABILITY";
    private static final String OP_CLUSTER_SET = "CLUSTER_SET";
    private static final String COLUMN_CLUSTER_ID = "CLUSTER_ID";
    private static final String COLUMN_PROBABILITY = "PROBABILITY";
    private static final String[][] m_contentColumnMap = new String[][]{{ClusteringApplyContent.clusterIdentifier.name(), ClusteringApplyContent.probability.name()}, {"CLUSTER_ID", "PROBABILITY"}};

    protected String getPredictionColName(String destAttrName) {
        String columnName = null;
        try {
            ClusteringApplyContent content = this.getContent(destAttrName);
            String contentType = content.name();
            for (int i = 0; i < m_contentColumnMap[0].length; ++i) {
                if (contentType.compareTo(m_contentColumnMap[0][i]) != 0) continue;
                columnName = m_contentColumnMap[1][i];
            }
        }
        catch (JDMException jDMException) {
            // empty catch block
        }
        return columnName;
    }

    protected String[] toSQL(String modelName) throws JDMException {
        this.m_attrNames = new Vector();
        String[] sqlStats = new String[]{null, null};
        StringBuffer sqlStat = new StringBuffer("select ");
        ClusteringApplyContent[] contents = this.getMappedContents();
        switch (this.m_applyOutputMode) {
            case 2: {
                this.m_attrMapping = 1;
                int[] clusterIds = this.getMappedClusterIdentifiers();
                for (int i = 0; i < clusterIds.length; ++i) {
                    ClusteringApplyContent[] contents2 = this.getContentsByCluster(clusterIds[i]);
                    for (int j = 0; j < contents2.length; ++j) {
                        if (i + j > 0) {
                            sqlStat.append(", ");
                        }
                        if (contents2[j].equals((Object)ClusteringApplyContent.clusterIdentifier)) {
                            sqlStat.append(clusterIds[i]);
                        } else if (contents2[j].equals((Object)ClusteringApplyContent.probability)) {
                            sqlStat.append(OP_PROBABILITY).append("(").append(modelName);
                            sqlStat.append(", ").append(clusterIds[i]).append(" USING *)");
                        } else {
                            this.unsupported("ClusteringApplyContent." + contents2[j].name());
                        }
                        sqlStat.append(" as ").append(this.getMappedDestinationAttrName(new Integer(clusterIds[i]), contents2[j]));
                        this.m_attrNames.add(this.getMappedDestinationAttrName(new Integer(clusterIds[i]), contents2[j]));
                    }
                }
                break;
            }
            case 3: {
                if (this.m_rankContentMap != null) {
                    this.m_attrMapping = 4;
                    sqlStat.append("s.").append("CLUSTER_ID").append(" ");
                    sqlStat.append("CLUSTER_ID").append(", ");
                    sqlStat.append("s.").append(COLUMN_PROBABILITY).append(" ");
                    sqlStat.append(COLUMN_PROBABILITY);
                    sqlStat.append(" from (select ").append(OP_CLUSTER_SET).append("(");
                    sqlStat.append(modelName).append(", ").append(this.getRanks().toString());
                    sqlStat.append(" USING *) pset");
                    sqlStats[1] = ") t, TABLE(t.pset) s order by PROBABILITY desc";
                    Integer ranks = this.getRanks();
                    ClusteringApplyContent[] mappedContents = this.getMappedContents();
                    for (int iRank = 1; iRank < ranks + 1; ++iRank) {
                        Vector<String> attrNames = new Vector<String>();
                        for (int jj = 0; jj < mappedContents.length; ++jj) {
                            String attrName = this.getMappedDestinationAttrName(iRank, mappedContents[jj]);
                            if (attrName == null) continue;
                            attrNames.add(attrName);
                        }
                        this.m_attrNames.add(Integer.toString(attrNames.size()));
                        for (int kk = 0; kk < attrNames.size(); ++kk) {
                            this.m_attrNames.add(attrNames.elementAt(kk));
                        }
                    }
                } else {
                    this.m_attrMapping = 1;
                    for (int i = 0; i < contents.length; ++i) {
                        if (i > 0) {
                            sqlStat.append(", ");
                        }
                        String op = null;
                        if (contents[i].equals((Object)ClusteringApplyContent.clusterIdentifier)) {
                            op = "CLUSTER_ID";
                        } else if (contents[i].equals((Object)ClusteringApplyContent.probability)) {
                            op = OP_PROBABILITY;
                        } else {
                            this.unsupported("ClusteringApplyContent." + contents[i].name());
                        }
                        this.m_attrNames.add(this.getMappedDestinationAttrName((Enum)contents[i]));
                        sqlStat.append(op).append("(").append(modelName).append(" USING *) as ");
                        sqlStat.append(this.getMappedDestinationAttrName((Enum)contents[i]));
                    }
                }
                break;
            }
            default: {
                String idCol = "CLUSTER_ID";
                if (this.m_applyOutputMode == 4) {
                    this.m_attrMapping = 3;
                    idCol = this.getMappedBaseDestinationAttributeName(ClusteringApplyContent.clusterIdentifier);
                } else {
                    this.m_attrMapping = 2;
                }
                this.m_attrNames.add(idCol);
                sqlStat.append("s.").append("CLUSTER_ID").append(" ");
                sqlStat.append("CLUSTER_ID").append(", ");
                sqlStat.append("s.").append(COLUMN_PROBABILITY).append(" ");
                sqlStat.append(COLUMN_PROBABILITY);
                String probCol = this.getMappedBaseDestinationAttributeName(ClusteringApplyContent.probability);
                if (this.m_applyOutputMode != 4) {
                    probCol = COLUMN_PROBABILITY;
                }
                if (probCol != null) {
                    this.m_attrNames.add(probCol);
                }
                sqlStat.append(" from (select ").append(OP_CLUSTER_SET).append("(");
                sqlStat.append(modelName).append(" USING *) pset");
                sqlStats[1] = ") t, TABLE(t.pset) s order by PROBABILITY desc";
            }
        }
        sqlStats[0] = sqlStat.toString();
        return sqlStats;
    }

    public void mapByRank(ClusteringApplyContent content, String[] destPhysAttrNameArray, boolean fromTop) throws JDMException {
        super.mapByRank((Enum)content, destPhysAttrNameArray, fromTop);
    }

    public void mapByClusterIdentifier(ClusteringApplyContent content, int clusterIdentifier, String destPhysAttrName) throws JDMException {
        super.mapByCategory((Enum)content, new Integer(clusterIdentifier), destPhysAttrName);
    }

    public void mapClusters(ClusteringApplyContent content, String baseDestPhysAttrName) {
        super.mapPredictions((Enum)content, baseDestPhysAttrName);
    }

    public void mapTopCluster(ClusteringApplyContent content, String destPhysAttrName) {
        super.mapTopPrediction((Enum)content, destPhysAttrName);
    }

    public Integer getRank(String destinationAttrName) throws JDMException {
        try {
            return super.getRank(destinationAttrName);
        }
        catch (JDMException exp) {
            return null;
        }
    }

    public Integer getRanks() {
        return super.getRanks();
    }

    public boolean isFromTop() {
        return super.isFromTop();
    }

    public ClusteringApplyContent getContent(String destPhysAttrName) throws JDMException {
        return (ClusteringApplyContent)super.getContentEnum(destPhysAttrName);
    }

    public ClusteringApplyContent[] getContentsByCluster(int clusterIdentifier) throws JDMException {
        Object[] objs = this.getContentsByCategoryEnums(new Integer(clusterIdentifier));
        ClusteringApplyContent[] enums = null;
        if (objs != null && objs.length > 0) {
            enums = new ClusteringApplyContent[objs.length];
            System.arraycopy(objs, 0, enums, 0, objs.length);
        }
        return enums;
    }

    public ClusteringApplyContent[] getContentsByRank(int rank) throws JDMException {
        this.getValidationHandler().validateNumber(rank, 1, "rank");
        Integer ranks = super.getRanks();
        if (ranks == null) {
            this.getExceptionHandler().createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new Object[]{"rank"}, null);
        }
        this.getValidationHandler().validateNumber(rank, 1, ranks, "rank");
        Object[] contents = super.getContentsByRankEnums(rank);
        if (contents == null) {
            return null;
        }
        ClusteringApplyContent[] clusteringContents = new ClusteringApplyContent[contents.length];
        System.arraycopy(contents, 0, clusteringContents, 0, contents.length);
        return clusteringContents;
    }

    public int[] getMappedClusterIdentifiers() {
        Object[] clusterIdArray = super.getMappedCategories();
        if (clusterIdArray == null) {
            return null;
        }
        int[] intArray = new int[clusterIdArray.length];
        for (int i = 0; i < clusterIdArray.length; ++i) {
            intArray[i] = ((Number)clusterIdArray[i]).intValue();
        }
        return intArray;
    }

    public Integer getMappedClusterIdentifier(String destPhysAttrName) throws JDMException {
        Object clusterIdVal = super.getContentAttrValue(destPhysAttrName);
        if (clusterIdVal == null) {
            return null;
        }
        return new Integer(((Number)clusterIdVal).intValue());
    }

    public String getMappedDestinationAttrName(Integer clusterIdentifier, ClusteringApplyContent contentType) throws JDMException {
        return super.getMappedDestinationAttrName(clusterIdentifier, (Enum)contentType);
    }

    protected OraClusteringApplySettings(OraConnection dmeConn, OraFactory factory) throws JDMException {
        super(dmeConn, factory, MiningFunction.clustering);
    }

    public String getMappedBaseDestinationAttributeName(ClusteringApplyContent content) {
        return super.getMappedBaseDestinationAttributeName((Enum)content);
    }

    public String[] getMappedDestinationAttributeNames(ClusteringApplyContent content) {
        return super.getMappedDestinationAttributeNames((Enum)content);
    }

    public ClusteringApplyContent[] getMappedContents() {
        Object[] objs = super.getMappedContentsEnums();
        ClusteringApplyContent[] enums = null;
        if (objs != null && objs.length > 0) {
            enums = new ClusteringApplyContent[objs.length];
            System.arraycopy(objs, 0, enums, 0, objs.length);
        }
        return enums;
    }

    public String getMappedDestinationAttrName(int clusterRank, ClusteringApplyContent contentType) throws JDMException {
        return super.getMappedDestinationAttrName(clusterRank, (Enum)contentType);
    }
}

