/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.base;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningFunction;
import javax.datamining.NamedObject;
import javax.datamining.base.BuildSettings;
import javax.datamining.base.Model;
import javax.datamining.base.ModelDetail;
import javax.datamining.data.ModelSignature;
import javax.datamining.resource.Connection;
import javax.datamining.statistics.AttributeStatisticsSet;
import oracle.dmt.jdm.OraMiningFunction;
import oracle.dmt.jdm.OraMiningObject;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.association.OraAssociationModel;
import oracle.dmt.jdm.attributeimportance.OraAttributeImportanceModel;
import oracle.dmt.jdm.base.OraBuildSettings;
import oracle.dmt.jdm.clustering.OraClusteringModel;
import oracle.dmt.jdm.data.OraModelSignature;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionModel;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.classification.OraClassificationModel;
import oracle.dmt.jdm.supervised.regression.OraRegressionModel;
import oracle.dmt.jdm.transform.OraExpressionTransform;
import oracle.dmt.jdm.transform.OraExpressionTransformImpl;
import oracle.dmt.jdm.transform.OraTransformation;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransform;
import oracle.dmt.jdm.utils.OraSQLUtils;
import oracle.dmt.jdm.utils.OraStringUtils;

public abstract class OraModel
extends OraMiningObject
implements Model {
    private String m_uniqueIdentifier = null;
    private String m_jdmVersion = null;
    private String m_majorVersion = null;
    private String m_minorVersion = null;
    private String m_providerName = null;
    private String m_providerVersion = null;
    private String m_applicationName = null;
    private MiningFunction m_function = null;
    private MiningAlgorithm m_algorithm = null;
    private ModelSignature m_signature = null;
    private BuildSettings m_buildSettings = null;
    protected ModelDetail m_modelDetail = null;
    private String m_taskIdentifier = null;
    private Integer m_buildDuration = null;
    private String m_targetAttributeName = null;
    protected OraTransformation m_buildTransform = null;
    private double m_modelSizeInMB = 0.0;
    private static final String CS_DROP_MODEL = "DBMS_DATA_MINING.DROP_MODEL";
    private static final String CS_RENAME_MODEL = "DBMS_DATA_MINING.RENAME_MODEL";
    private static final String P_MODEL_NAME = "MODEL_NAME";
    private static final String P_NEW_MODEL_NAME = "NEW_MODEL_NAME";
    private static final String QRY_GET_BUILD_SETTINGS_102 = "select * from  TABLE(dbms_data_mining.get_model_settings(?))  union all select 'JDMS_TARGET_NAME' as setting_name, target_attribute as setting_value from dm_user_models where name=? and target_attribute is not null";
    private static final String QRY_GET_BUILD_SETTINGS = "select * from  TABLE(dbms_data_mining.get_model_settings(?)) union all select 'JDMS_TARGET_NAME' as setting_name, attribute_name as setting_value from user_mining_model_attributes where model_name=? and target='YES'";
    private static final String QRY_GET_TASK_NAME = "select j.job_name from user_scheduler_jobs j, user_scheduler_job_args a where j.job_name=a.job_name and UPPER(a.value)=? and j.PROGRAM_NAME='BUILD_PROGRAM'";

    public String getUniqueIdentifier() {
        return this.getProviderName() + "_" + this.getVersion() + "_" + this.getCreationDate() + "_" + this.getObjectIdentifier();
    }

    public void setBuildTransformation(OraTransformation buildTransform) throws JDMException {
        if (buildTransform != null) {
            try {
                OraBinningTransform binning = (OraBinningTransform)buildTransform;
                if (binning.getCategoricalBinTable() == null && binning.getNumericalBinTable() == null) {
                    this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{"buildTransform"}, null);
                }
            }
            catch (ClassCastException notBinning) {
                try {
                    OraNormalizeTransform normalize = (OraNormalizeTransform)buildTransform;
                    if (normalize.getNormalizationDefinitionTable() == null) {
                        this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{"buildTransform"}, null);
                    }
                }
                catch (ClassCastException notNormalization) {
                    this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{"buildTransform"}, null);
                }
            }
        }
        this.m_buildTransform = buildTransform;
    }

    public OraTransformation getBuildTransformation() {
        return this.m_buildTransform;
    }

    public String getVersion() {
        return this.getConnection().getMetaData().getVersion();
    }

    public String getMajorVersion() {
        return Integer.toString(this.getConnection().getMetaData().getMajorVersion());
    }

    public String getMinorVersion() {
        return Integer.toString(this.getConnection().getMetaData().getMinorVersion());
    }

    public String getProviderName() {
        return this.getConnection().getMetaData().getProviderName();
    }

    public String getProviderVersion() {
        return this.getConnection().getMetaData().getProviderVersion();
    }

    public String getApplicationName() {
        return null;
    }

    public MiningFunction getMiningFunction() {
        return this.m_function;
    }

    public MiningAlgorithm getMiningAlgorithm() {
        return this.m_algorithm;
    }

    public ModelSignature getSignature() {
        OraModelSignature ms = null;
        try {
            ms = new OraModelSignature(this.getConnection(), this.getName(), this.m_function, this.m_algorithm);
        }
        catch (Exception e) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, null, e);
        }
        return ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildSettings getBuildSettings() {
        if (this.m_buildSettings == null) {
            HashMap<String, String> settingsMap = null;
            Statement pStmt = null;
            ResultSet rs = null;
            try {
                pStmt = this.is102() ? this.getDatabaseConnection().prepareStatement(QRY_GET_BUILD_SETTINGS_102) : this.getDatabaseConnection().prepareStatement(QRY_GET_BUILD_SETTINGS);
                pStmt.setString(1, this.getName());
                pStmt.setString(2, this.getName());
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    settingsMap = new HashMap<String, String>();
                    do {
                        settingsMap.put(rs.getString(1), rs.getString(2));
                    } while (rs.next());
                }
                this.m_buildSettings = OraBuildSettings.createSettings(this.getConnection(), settingsMap, this.m_function, this.getName());
            }
            catch (Exception anyExp) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, null, anyExp);
            }
            finally {
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
                catch (SQLException sqlExp) {}
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sqlExp1) {}
            }
        }
        return this.m_buildSettings;
    }

    public BuildSettings getEffectiveBuildSettings() {
        return this.getBuildSettings();
    }

    public abstract ModelDetail getModelDetail();

    public AttributeStatisticsSet getAttributeStatistics() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTaskIdentifier() {
        if (this.m_taskIdentifier == null) {
            java.sql.Connection dbConn = this.getDatabaseConnection();
            PreparedStatement pStmt = null;
            ResultSet rs = null;
            try {
                pStmt = dbConn.prepareStatement(QRY_GET_TASK_NAME);
                pStmt.setString(1, this.getName());
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    this.m_taskIdentifier = rs.getString(1);
                }
            }
            catch (SQLException sqlExp) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException exp1) {}
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
                catch (SQLException exp2) {}
            }
        }
        return this.m_taskIdentifier;
    }

    public Integer getBuildDuration() {
        return this.m_buildDuration;
    }

    protected OraModel(OraConnection dmeConn, String name, MiningFunction function) throws JDMException {
        super(dmeConn, null, NamedObject.model);
        this.setName(name);
        this.m_function = function;
    }

    public boolean isInputObject() {
        return false;
    }

    public OraExpressionTransform getModelTransformations() {
        OraExpressionTransformImpl xforms = null;
        try {
            xforms = new OraExpressionTransformImpl(this.getConnection(), this.getFactory(), this.getName());
        }
        catch (JDMException anyExp) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, anyExp);
        }
        return xforms;
    }

    protected void saveObjectInDatabase(Connection dmeConn, String name) throws JDMException {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT_TYPE, null, null, "3500", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection retrieveObjectsFromDatabase(OraConnection dmeConn, Date createdAfter, Date createdBefore, Enum minorType) throws JDMException, SQLException {
        if (dmeConn.is102()) {
            return OraModel.retrieveObjectsFromDatabase102(dmeConn, createdAfter, createdBefore, minorType);
        }
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        String sqlSpec = "SELECT name FROM USER_MINING_MODELS";
        String whereClause = "";
        boolean andNeeded = false;
        if (minorType != null) {
            if (minorType instanceof MiningFunction) {
                whereClause = whereClause + " MINING_FUNCTION = '" + OraPLSQLMappings.getPLSQLConstant((MiningFunction)minorType) + "' ";
                andNeeded = true;
            } else if (minorType instanceof MiningAlgorithm) {
                whereClause = whereClause + " ALGORITHM = '" + OraPLSQLMappings.getDBDictionaryName((MiningAlgorithm)minorType) + "' ";
                andNeeded = true;
            } else {
                dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new Object[]{"minorType"}, null, null, null);
            }
        }
        if (createdAfter != null) {
            if (andNeeded) {
                whereClause = whereClause + " AND ";
            }
            whereClause = whereClause + " CREATION_DATE > ?";
            andNeeded = true;
        }
        if (createdBefore != null) {
            if (andNeeded) {
                whereClause = whereClause + " AND ";
            }
            whereClause = whereClause + " CREATION_DATE < ?";
            andNeeded = true;
        }
        if (andNeeded) {
            sqlSpec = sqlSpec + "WHERE " + whereClause;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Object description = null;
        String objectName = null;
        Vector<OraModel> returnedObjects = new Vector<OraModel>();
        try {
            ps = dbConn.prepareStatement(sqlSpec);
            int i = 1;
            if (createdAfter != null) {
                ps.setTimestamp(i++, new Timestamp(createdAfter.getTime()));
            }
            if (createdBefore != null) {
                ps.setTimestamp(i++, new Timestamp(createdBefore.getTime()));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                objectName = rs.getString(P_MODEL_NAME);
                OraModel object = null;
                try {
                    object = OraModel.retrieveObjectFromDatabase(dmeConn, objectName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                returnedObjects.add(object);
            }
        }
        catch (SQLException sqlExp) {
            dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{objectName}, sqlExp, OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e2) {}
        }
        return returnedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection retrieveObjectsFromDatabase102(OraConnection dmeConn, Date createdAfter, Date createdBefore, Enum minorType) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        String sqlSpec = "SELECT name FROM dm_user_models";
        PreparedStatement ps = null;
        ResultSet rs = null;
        Object description = null;
        String objectName = null;
        Vector<OraModel> returnedObjects = new Vector<OraModel>();
        try {
            ps = dbConn.prepareStatement(sqlSpec);
            rs = ps.executeQuery();
            while (rs.next()) {
                objectName = rs.getString("NAME");
                OraModel object = null;
                try {
                    object = OraModel.retrieveObjectFromDatabase(dmeConn, objectName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean addToList = false;
                if (object != null) {
                    if (createdAfter == null & createdBefore == null) {
                        addToList = true;
                    } else if (createdAfter != null && object.getCreationDate().after(createdAfter) & createdBefore == null) {
                        addToList = true;
                    } else if (createdAfter == null & createdBefore != null && object.getCreationDate().before(createdBefore)) {
                        addToList = true;
                    } else if (createdAfter != null && object.getCreationDate().after(createdAfter) & createdBefore != null && object.getCreationDate().before(createdBefore)) {
                        addToList = true;
                    }
                    if (minorType != null && object.getMiningFunction() == minorType) {
                        addToList &= true;
                    } else if (minorType != null && object.getMiningFunction() != minorType) {
                        addToList &= false;
                    }
                }
                if (!addToList) continue;
                returnedObjects.add(object);
            }
        }
        catch (SQLException sqlExp) {
            dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{objectName}, sqlExp, OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e2) {}
        }
        return returnedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OraModel retrieveObjectFromDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String functionName = null;
        String algorithmName = null;
        Timestamp creationDate = null;
        long buildDuration = 0L;
        String targetAttribute = null;
        double modelSizeInMB = 0.0;
        String modelName = OraStringUtils.trimDoubleQuotes(name);
        String comments = null;
        try {
            pStmt = dmeConn.is102() ? dbConn.prepareStatement("SELECT * FROM dm_user_models WHERE NAME= ?") : dbConn.prepareStatement("SELECT * FROM user_mining_models WHERE MODEL_NAME= ?");
            pStmt.setString(1, modelName);
            rs = pStmt.executeQuery();
            if (rs.next()) {
                if (dmeConn.is102()) {
                    functionName = rs.getString("FUNCTION_NAME");
                    algorithmName = rs.getString("ALGORITHM_NAME");
                    creationDate = rs.getTimestamp("CREATION_DATE");
                    buildDuration = rs.getLong("BUILD_DURATION");
                    targetAttribute = rs.getString("TARGET_ATTRIBUTE");
                    modelSizeInMB = rs.getDouble("MODEL_SIZE");
                } else {
                    functionName = rs.getString("MINING_FUNCTION");
                    algorithmName = rs.getString("ALGORITHM");
                    creationDate = rs.getTimestamp("CREATION_DATE");
                    buildDuration = rs.getLong("BUILD_DURATION");
                    modelSizeInMB = rs.getDouble("MODEL_SIZE");
                    comments = rs.getString("COMMENTS");
                    if ("CLASSIFICATION".equalsIgnoreCase(functionName) || "REGRESSION".equalsIgnoreCase(functionName) || "ATTRIBUTE_IMPORTANCE".equalsIgnoreCase(functionName)) {
                        PreparedStatement pStmtTarget = null;
                        ResultSet rsTarget = null;
                        try {
                            pStmtTarget = dbConn.prepareStatement("SELECT ATTRIBUTE_NAME FROM user_mining_model_attributes WHERE MODEL_NAME = ? and TARGET = 'YES'");
                            pStmtTarget.setString(1, modelName);
                            rsTarget = pStmtTarget.executeQuery();
                            if (rsTarget.next()) {
                                targetAttribute = rsTarget.getString("ATTRIBUTE_NAME");
                            }
                        }
                        finally {
                            if (rsTarget != null) {
                                rsTarget.close();
                            }
                            if (pStmtTarget != null) {
                                pStmtTarget.close();
                            }
                        }
                    }
                }
                OraModel model = null;
                MiningFunction function = OraPLSQLMappings.getMiningFunction(functionName);
                MiningAlgorithm algorithm = OraPLSQLMappings.getMiningAlgorithm("ALGO_" + algorithmName);
                if (MiningFunction.classification.equals((Object)function)) {
                    model = new OraClassificationModel(dmeConn, name, targetAttribute);
                    model.m_algorithm = algorithm;
                    model.m_modelSizeInMB = modelSizeInMB;
                } else if (MiningFunction.regression.equals((Object)function)) {
                    model = new OraRegressionModel(dmeConn, name, targetAttribute);
                    if (algorithm == MiningAlgorithm.svmClassification) {
                        algorithm = MiningAlgorithm.svmRegression;
                    }
                    model.m_algorithm = algorithm;
                    model.m_modelSizeInMB = modelSizeInMB;
                } else if (MiningFunction.clustering.equals((Object)function)) {
                    model = new OraClusteringModel(dmeConn, name);
                    model.m_algorithm = algorithm;
                    model.m_modelSizeInMB = modelSizeInMB;
                } else if (MiningFunction.association.equals((Object)function)) {
                    model = new OraAssociationModel(dmeConn, name);
                    model.m_algorithm = algorithm;
                    model.m_modelSizeInMB = modelSizeInMB;
                } else if (MiningFunction.attributeImportance.equals((Object)function)) {
                    model = new OraAttributeImportanceModel(dmeConn, name);
                    model.m_algorithm = algorithm;
                    model.m_modelSizeInMB = modelSizeInMB;
                } else if (OraMiningFunction.featureExtraction.equals((Object)function)) {
                    model = new OraFeatureExtractionModel(dmeConn, name);
                    model.m_algorithm = algorithm;
                    model.m_modelSizeInMB = modelSizeInMB;
                }
                model.setCreationDate(creationDate);
                if (comments != null) {
                    model.setDescription(comments);
                }
                String sqlSpec = "SELECT owner FROM ALL_OBJECTS where OBJECT_NAME = '" + name.toUpperCase() + "'";
                PreparedStatement pStmt2 = null;
                ResultSet rs2 = null;
                String creatorInfo = null;
                try {
                    pStmt2 = dbConn.prepareStatement(sqlSpec);
                    rs2 = pStmt.executeQuery();
                    if (rs2.next()) {
                        creatorInfo = rs2.getString(1);
                    }
                }
                catch (SQLException sqlExp) {
                    dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, sqlExp, OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, null);
                }
                finally {
                    try {
                        if (rs2 != null) {
                            rs2.close();
                        }
                    }
                    catch (Exception e1) {}
                    try {
                        if (pStmt2 != null) {
                            pStmt2.close();
                        }
                    }
                    catch (Exception e2) {}
                }
                model.setCreatorInfo(creatorInfo);
                model.m_buildDuration = new Integer((int)buildDuration * 60);
                OraModel oraModel = model;
                return oraModel;
            }
            dmeConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new String[]{NamedObject.model.name(), name}, null);
        }
        catch (SQLException sqlExp) {
            dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, sqlExp, OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, null);
        }
        finally {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sqlExp) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqlExp2) {}
            }
        }
        return null;
    }

    public static OraModel retrieveObjectFromDatabaseByID(OraConnection dmeConn, String identifier, MiningFunction function) throws JDMException, SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeObjectFromDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        Statement cStmt = null;
        try {
            OraSQLUtils.executeCallableStatement(dmeConn.getDatabaseConnection(), CS_DROP_MODEL, new String[]{P_MODEL_NAME}, new Object[]{OraStringUtils.trimDoubleQuotes(name)}, new int[]{12}, null, dmeConn.getLogger());
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameObjectInDatabase(OraConnection dmeConn, String oldName, String newName) throws JDMException, SQLException {
        Statement cStmt = null;
        try {
            OraSQLUtils.executeCallableStatement(dmeConn.getDatabaseConnection(), CS_RENAME_MODEL, new String[]{P_MODEL_NAME, P_NEW_MODEL_NAME}, new Object[]{oldName, newName}, new int[]{12, 12}, null, dmeConn.getLogger());
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesObjectExistInDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dmeConn.is102() ? dbConn.prepareStatement("SELECT NAME FROM dm_user_models WHERE NAME= ?") : dbConn.prepareStatement("SELECT MODEL_NAME FROM user_mining_models WHERE MODEL_NAME= ?");
            pStmt.setString(1, name);
            rs = pStmt.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sqlExp) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqlExp2) {}
            }
        }
    }
}

