/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.base;

import java.util.HashMap;
import java.util.Map;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.VerificationReport;
import javax.datamining.base.AlgorithmSettings;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.resource.OraConnection;

public class OraAlgorithmSettings
extends OraDMObject
implements AlgorithmSettings {
    private Map m_settingsPair = null;
    private MiningAlgorithm m_algorithm = null;
    protected static String MINING_ALGORITHM = "ALGO_NAME";

    protected OraAlgorithmSettings(OraConnection dmeConn, OraFactory factory, MiningAlgorithm miningAlgorithm, String algoName) throws JDMException {
        super(dmeConn, factory);
        this.m_algorithm = miningAlgorithm;
        this.m_settingsPair = new HashMap();
        this.m_settingsPair.put(MINING_ALGORITHM, algoName);
    }

    protected synchronized void setValue(String key, String value) {
        this.m_settingsPair.put(key, value);
    }

    protected String getValue(String key) {
        if (!this.m_settingsPair.containsKey(key)) {
            // empty if block
        }
        return (String)this.m_settingsPair.get(key);
    }

    public VerificationReport verify() {
        return null;
    }

    public MiningAlgorithm getMiningAlgorithm() {
        return this.m_algorithm;
    }

    Map getAlgorithmSettingsMap() {
        return this.m_settingsPair;
    }

    synchronized void setAlgorithmSettingsMap(Map settingsPair) {
        this.m_settingsPair = settingsPair;
    }
}

