/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.attributeimportance;

import javax.datamining.JDMException;
import javax.datamining.MiningFunction;
import javax.datamining.attributeimportance.AttributeImportanceSettings;
import javax.datamining.base.AlgorithmSettings;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.attributeimportance.OraAttributeImportanceAlgorithmSettings;
import oracle.dmt.jdm.attributeimportance.OraAttributeImportanceSettingsFactory;
import oracle.dmt.jdm.base.OraBuildSettings;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraAttributeImportanceSettings
extends OraBuildSettings
implements AttributeImportanceSettings {
    private static final String TARGET_ATTRIBUTE_NAME = "JDMS_TARGET_NAME";

    OraAttributeImportanceSettings(OraConnection dmeConn, OraAttributeImportanceSettingsFactory factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, MiningFunction.attributeImportance);
    }

    protected boolean isSupported(AlgorithmSettings algoSettings) {
        return algoSettings instanceof OraAttributeImportanceAlgorithmSettings;
    }

    protected AlgorithmSettings getDefaultAlgorithmSettings() {
        OraAttributeImportanceAlgorithmSettings algoSettings = null;
        try {
            algoSettings = new OraAttributeImportanceAlgorithmSettings(this.getConnection(), this.getFactory());
        }
        catch (JDMException jDMException) {
            // empty catch block
        }
        return algoSettings;
    }

    public boolean isSupervised() {
        return this.getTargetAttributeName() != null;
    }

    public void setTargetAttributeName(String targetAttrName) throws JDMException {
        this.getValidationHandler().validateTableColumnName(targetAttrName, "targetAttrName");
        this.setValue(TARGET_ATTRIBUTE_NAME, OraStringUtils.getReplacedString(targetAttrName, "'", "''"));
    }

    public String getTargetAttributeName() {
        return this.getValue(TARGET_ATTRIBUTE_NAME);
    }

    public int getMaxAttributeCount() {
        this.unsupported("AttributeImportanceSettings.getMaxAttributeCount");
        return 0;
    }

    public void setMaxAttributeCount(int maxCount) {
        this.unsupported("AttributeImportanceSettings.setMaxAttributeCount");
    }
}

