/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.attributeimportance;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.MiningFunction;
import javax.datamining.SortOrder;
import javax.datamining.attributeimportance.AttributeImportanceModel;
import javax.datamining.base.ModelDetail;
import javax.datamining.data.ModelSignature;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.data.OraModelSignature;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;

public class OraAttributeImportanceModel
extends OraModel
implements AttributeImportanceModel {
    private int m_attributeCount = 0;
    private int m_maxRank = 0;
    private Vector m_rankedAttributes = null;
    private Vector m_rankedImportance = null;
    private Vector m_attributeRanks = null;
    private boolean m_fromTop = true;
    private OraModelSignature m_modelSignature = null;
    private static String QRY_AI_MODEL_CONSTANTS = "SELECT count(ATTRIBUTE_NAME) attribute_count, max(RANK) max_rank FROM TABLE(dbms_data_mining.get_model_details_ai(?))";
    private static String QRY_AI_ALL = "SELECT * FROM TABLE(dbms_data_mining.get_model_details_ai(?)) ORDER BY rank asc, attribute_name asc";

    public OraAttributeImportanceModel(OraConnection dmeConn, String name) throws JDMException {
        super(dmeConn, name, MiningFunction.attributeImportance);
        this.loadConstants();
    }

    void loadConstants() throws JDMException {
        Connection dbConn = this.getDatabaseConnection();
        CallableStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dbConn.prepareCall(QRY_AI_MODEL_CONSTANTS);
            pStmt.setString(1, this.getName());
            rs = pStmt.executeQuery();
            while (rs.next()) {
                this.m_attributeCount = rs.getInt("ATTRIBUTE_COUNT");
                this.m_maxRank = rs.getInt("MAX_RANK");
            }
        }
        catch (SQLException sqlExp) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {
                // empty catch block
            }
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {
                // empty catch block
            }
            try {
                this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp, "2009", new Object[]{this.getName()});
            }
            catch (Exception jdmExp) {
                throw (JDMException)((Object)jdmExp);
            }
        }
    }

    public ModelDetail getModelDetail() {
        return null;
    }

    public Collection getAttributesByRank(SortOrder ordering) throws JDMException {
        this.getValidationHandler().validateNotNull(ordering, "ordering");
        boolean fromTop = ordering.equals((Object)SortOrder.descending);
        if (this.m_rankedAttributes == null) {
            Connection dbConn = this.getDatabaseConnection();
            CallableStatement pStmt = null;
            ResultSet rs = null;
            try {
                pStmt = dbConn.prepareCall(QRY_AI_ALL);
                pStmt.setString(1, this.getName());
                rs = pStmt.executeQuery();
                this.m_rankedAttributes = new Vector();
                this.m_rankedImportance = new Vector();
                this.m_attributeRanks = new Vector();
                while (rs.next()) {
                    String attrSubName;
                    String attrName = rs.getString("ATTRIBUTE_NAME");
                    if (!this.is102() && (attrSubName = rs.getString("ATTRIBUTE_SUBNAME")) != null && attrSubName.trim().length() > 0) {
                        attrName = attrName + "." + attrSubName;
                    }
                    double importance = rs.getDouble("IMPORTANCE_VALUE");
                    int rank = rs.getInt("RANK");
                    this.m_rankedAttributes.addElement(attrName);
                    this.m_rankedImportance.addElement(new Double(importance));
                    this.m_attributeRanks.addElement(new Integer(rank));
                }
            }
            catch (SQLException sqlExp) {
                this.m_rankedAttributes = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sqlExp1) {
                    // empty catch block
                }
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
                catch (SQLException sqlExp1) {
                    // empty catch block
                }
                try {
                    this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp, "2010", new Object[]{this.getName()});
                }
                catch (Exception jdmExp) {
                    throw (JDMException)((Object)jdmExp);
                }
            }
        }
        if (!fromTop) {
            Vector reverseRanked = new Vector();
            for (int i = this.m_rankedAttributes.size() - 1; i >= 0; --i) {
                reverseRanked.addElement(this.m_rankedAttributes.elementAt(i));
            }
            return reverseRanked;
        }
        return this.m_rankedAttributes;
    }

    public Collection getAttributesByRank(int lowerRank, int upperRank) throws JDMException {
        Vector attributes = (Vector)this.getAttributesByRank(SortOrder.descending);
        this.getValidationHandler().validateNumber(lowerRank, 1, attributes.size(), "lowerRank");
        this.getValidationHandler().validateNumber(upperRank, 1, attributes.size(), "upperRank");
        return this.rearrangeCollection(attributes, lowerRank - 1, upperRank);
    }

    private Collection rearrangeCollection(Vector collection, int beginRank, int lastRank) {
        Vector rearranged = new Vector();
        for (int i = beginRank; i < lastRank; ++i) {
            rearranged.addElement(collection.elementAt(i));
        }
        return rearranged;
    }

    public Collection getAttributesByPercentage(double percent, SortOrder ordering) throws JDMException {
        this.getValidationHandler().validateNumber(percent, 0.0, 100.0, "percent");
        Vector attributes = (Vector)this.getAttributesByRank(ordering);
        int lastRank = (int)((double)attributes.size() * percent / 100.0);
        int beginRank = 0;
        return this.rearrangeCollection(attributes, beginRank, lastRank);
    }

    public int getAttributeCount() {
        return this.m_attributeCount;
    }

    public int getMaxRank() {
        return this.m_maxRank;
    }

    public ModelSignature getSignature() {
        try {
            this.getAttributesByRank(SortOrder.descending);
            this.m_modelSignature = new OraModelSignature(this.getConnection(), this.getName(), this.m_rankedAttributes, this.m_rankedImportance, this.m_attributeRanks);
        }
        catch (Exception e) {
            this.m_modelSignature = null;
            this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, e, "3517", new Object[]{this.getName()});
        }
        return this.m_modelSignature;
    }
}

