/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.association;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.datamining.ComparisonOperator;
import javax.datamining.JDMException;
import javax.datamining.SortOrder;
import javax.datamining.association.RuleComponentOption;
import javax.datamining.association.RuleProperty;
import javax.datamining.association.RulesFilter;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.association.OraRulesFilterFactory;
import oracle.dmt.jdm.resource.OraConnection;

public class OraRulesFilter
extends OraDMObject
implements RulesFilter {
    private int m_orderKey = 0;
    private int m_maxRules = 0;
    private HashMap m_propertyMap = new HashMap();
    private Object[] m_antecedentItems = null;
    private Object[] m_consequentItems = null;

    OraRulesFilter(OraConnection dmeConn, OraRulesFilterFactory factory) {
        super(dmeConn, factory);
    }

    public void setRange(RuleProperty type, double minValue, double maxValue) {
        this.getValidationHandler().validateNotNull(type, "type");
        this.isSupported(type);
        this.getValidationHandler().validateNumber(minValue, maxValue, "minValue", "maxValue");
        if (type.equals((Object)RuleProperty.support) || type.equals((Object)RuleProperty.confidence)) {
            this.getValidationHandler().validateNumber(minValue, 0.0, 100.0, "minValue");
            this.getValidationHandler().validateNumber(maxValue, 0.0, 100.0, "maxValue");
            minValue /= 100.0;
            maxValue /= 100.0;
        } else if (type.equals((Object)RuleProperty.length)) {
            this.getValidationHandler().validateNumber(minValue, 2.0, "minValue");
            this.getValidationHandler().validateNumber(maxValue, 2.0, "maxValue");
            this.getValidationHandler().validateNumber(minValue, maxValue, true, "minValue", "maxValue");
        }
        PropertyFilter filter = (PropertyFilter)this.m_propertyMap.get(type);
        if (filter == null) {
            filter = new PropertyFilter();
        }
        filter.setMinValue(minValue);
        filter.setMaxValue(maxValue);
        this.m_propertyMap.put(type, filter);
    }

    public void setThreshold(RuleProperty type, ComparisonOperator compOp, double thresholdValue) {
        PropertyFilter filter;
        this.getValidationHandler().validateNotNull(type, "type");
        this.getValidationHandler().validateNotNull(compOp, "compOp");
        this.getValidationHandler().validateNumber(thresholdValue, 0.0, "thresholdValue");
        this.isSupported(type);
        if (type.equals((Object)RuleProperty.support) || type.equals((Object)RuleProperty.confidence)) {
            this.getValidationHandler().validateNumber(thresholdValue, 0.0, 100.0, "thresholdValue");
            thresholdValue /= 100.0;
        }
        if ((filter = (PropertyFilter)this.m_propertyMap.get(type)) == null) {
            filter = new PropertyFilter();
        }
        filter.setThreshold(compOp, thresholdValue);
        this.m_propertyMap.put(type, filter);
    }

    public Double getThresholdValue(RuleProperty type) {
        this.getValidationHandler().validateNotNull(type, "type");
        Double thresholdValue = null;
        PropertyFilter filter = (PropertyFilter)this.m_propertyMap.get(type);
        if (filter != null && filter.getComparisonOperator() != null) {
            double threshold = filter.getMinValue();
            if (type.equals((Object)RuleProperty.support) || type.equals((Object)RuleProperty.confidence)) {
                threshold *= 100.0;
            }
            thresholdValue = new Double(threshold);
        }
        return thresholdValue;
    }

    public ComparisonOperator getThresholdOperator(RuleProperty type) {
        this.getValidationHandler().validateNotNull(type, "type");
        PropertyFilter filter = (PropertyFilter)this.m_propertyMap.get(type);
        ComparisonOperator compOp = null;
        if (filter != null) {
            compOp = filter.getComparisonOperator();
        }
        return compOp;
    }

    public Double getMaxValue(RuleProperty type) {
        this.getValidationHandler().validateNotNull(type, "type");
        PropertyFilter filter = (PropertyFilter)this.m_propertyMap.get(type);
        Double maxValue = null;
        if (filter != null) {
            double value = filter.getMaxValue();
            if (value == -1.0) {
                return maxValue;
            }
            if (type.equals((Object)RuleProperty.support) || type.equals((Object)RuleProperty.confidence)) {
                value *= 100.0;
            }
            maxValue = new Double(value);
        }
        return maxValue;
    }

    public Double getMinValue(RuleProperty type) {
        this.getValidationHandler().validateNotNull(type, "type");
        PropertyFilter filter = (PropertyFilter)this.m_propertyMap.get(type);
        Double minValue = null;
        if (filter != null) {
            double value = filter.getMinValue();
            if (value == -1.0) {
                return minValue;
            }
            if (type.equals((Object)RuleProperty.support) || type.equals((Object)RuleProperty.confidence)) {
                value *= 100.0;
            }
            minValue = new Double(value);
        }
        return minValue;
    }

    public Object[] getItems(RuleComponentOption componentOption, boolean included) {
        this.getValidationHandler().validateNotNull(componentOption, "componentOption");
        if (!included) {
            this.unsupported("RulesFilter.getItems(RuleComponentOption, false)");
        }
        if (componentOption.equals((Object)RuleComponentOption.antecedentOrConsequent)) {
            this.unsupported("RulesFilter.getItems(RuleComponentOption.antecedentOrConsequent, boolean)");
        }
        if (componentOption.equals((Object)RuleComponentOption.consequent)) {
            return this.m_consequentItems;
        }
        return this.m_antecedentItems;
    }

    public void setItems(Object[] items, RuleComponentOption componentOption, boolean included) {
        this.getValidationHandler().validateArray(items, "items");
        this.getValidationHandler().validateNotNull(componentOption, "componentOption");
        if (!included) {
            this.unsupported("RulesFilter.setItems(Object[], RuleComponentOption, false)");
        }
        if (componentOption.equals((Object)RuleComponentOption.antecedentOrConsequent)) {
            this.unsupported("RulesFilter.setItems(Object[], RuleComponentOption.antecedentOrConsequent, boolean)");
        }
        if (componentOption.equals((Object)RuleComponentOption.consequent)) {
            this.m_consequentItems = items;
        } else {
            this.m_antecedentItems = items;
        }
    }

    public void setOrderingCondition(RuleProperty[] orderBy, SortOrder[] sortOrder) {
        int i;
        this.getValidationHandler().validateArrays(orderBy, "orderBy", sortOrder, "sortOrder");
        OraRulesFilterFactory factory = (OraRulesFilterFactory)this.getFactory();
        for (i = 0; i < orderBy.length; ++i) {
            this.isSupported(orderBy[i]);
        }
        this.cleanOrdering();
        for (i = 0; i < orderBy.length; ++i) {
            PropertyFilter filter = (PropertyFilter)this.m_propertyMap.get(orderBy[i]);
            if (filter == null) {
                filter = new PropertyFilter();
            }
            filter.setSortOrder(sortOrder[i], this.m_orderKey++);
            this.m_propertyMap.put(orderBy[i], filter);
        }
    }

    private void cleanOrdering() {
        this.m_orderKey = 0;
        if (this.m_propertyMap.isEmpty()) {
            return;
        }
        Set keySet = this.m_propertyMap.keySet();
        for (RuleProperty property : keySet) {
            PropertyFilter filter = (PropertyFilter)this.m_propertyMap.get(property);
            filter.resetOrdering();
        }
    }

    public RuleProperty[] getOrderingConditions() {
        if (this.m_propertyMap.isEmpty()) {
            return null;
        }
        Set keySet = this.m_propertyMap.keySet();
        RuleProperty[] properties = new RuleProperty[keySet.size()];
        Iterator iKey = keySet.iterator();
        int numProperties = 0;
        while (iKey.hasNext()) {
            RuleProperty property = (RuleProperty)iKey.next();
            PropertyFilter filter = (PropertyFilter)this.m_propertyMap.get(property);
            int order = filter.getOrder();
            if (order == -1) continue;
            properties[order] = property;
            ++numProperties;
        }
        RuleProperty[] orderingConditions = null;
        if (numProperties > 0) {
            orderingConditions = new RuleProperty[numProperties];
            for (int i = 0; i < numProperties; ++i) {
                orderingConditions[i] = properties[i];
            }
        }
        return orderingConditions;
    }

    public SortOrder getOrderingCondition(RuleProperty orderBy) {
        this.getValidationHandler().validateNotNull(orderBy, "orderBy");
        PropertyFilter filter = (PropertyFilter)this.m_propertyMap.get(orderBy);
        SortOrder sortOrder = null;
        if (filter != null) {
            sortOrder = filter.getSortOrder();
        }
        return sortOrder;
    }

    public void setMaxNumberOfRules(int maxRules) {
        this.getValidationHandler().validateNumber(maxRules, 1, "maxRules");
        this.m_maxRules = maxRules;
    }

    public int getMaxNumberOfRules() {
        return this.m_maxRules;
    }

    private boolean isSupported(RuleProperty property) {
        OraRulesFilterFactory factory = (OraRulesFilterFactory)this.getFactory();
        try {
            if (!factory.supportsCapability(property)) {
                this.unsupported("RuleProperty." + property.name());
            }
        }
        catch (JDMException jDMException) {
            // empty catch block
        }
        return true;
    }

    private boolean isSupported(SortOrder order) {
        return order.equals((Object)SortOrder.ascending) || order.equals((Object)SortOrder.descending);
    }

    String[] toSQL() {
        return this.toSQL("");
    }

    String[] toSQL(String sourceTable) {
        String[] sqlClauses = new String[]{"", ""};
        boolean whereAdded = false;
        boolean orderByAdded = false;
        RuleProperty[] orderingCond = this.getOrderingConditions();
        if (orderingCond != null) {
            for (int i = 0; i < orderingCond.length; ++i) {
                SortOrder sort;
                if (orderingCond[i].equals((Object)RuleProperty.length)) continue;
                PropertyFilter filter = (PropertyFilter)this.m_propertyMap.get(orderingCond[i]);
                if (this.isSupported(orderingCond[i])) {
                    if (filter.getThreshold() != -1.0) {
                        ComparisonOperator compOp = filter.getComparisonOperator();
                        String op = null;
                        if (compOp.equals((Object)ComparisonOperator.equal)) {
                            op = " = ";
                        } else if (compOp.equals((Object)ComparisonOperator.greaterOrEqual)) {
                            op = " >= ";
                        } else if (compOp.equals((Object)ComparisonOperator.greaterThan)) {
                            op = " > ";
                        } else if (compOp.equals((Object)ComparisonOperator.lessOrEqual)) {
                            op = " <= ";
                        } else if (compOp.equals((Object)ComparisonOperator.lessThan)) {
                            op = " < ";
                        } else if (compOp.equals((Object)ComparisonOperator.notEqual)) {
                            op = " != ";
                        }
                        if (op != null) {
                            double threshold = filter.getThreshold();
                            if (whereAdded) {
                                sqlClauses[0] = sqlClauses[0] + " AND ";
                            }
                            sqlClauses[0] = sqlClauses[0] + sourceTable + this.convert(orderingCond[i]) + op + threshold;
                            whereAdded = true;
                        }
                    } else if (filter.getMaxValue() != -1.0) {
                        double min_value = filter.getMinValue();
                        double max_value = filter.getMaxValue();
                        if (whereAdded) {
                            sqlClauses[0] = sqlClauses[0] + " AND ";
                        }
                        sqlClauses[0] = sqlClauses[0] + sourceTable + this.convert(orderingCond[i]) + " >= " + min_value + " AND " + sourceTable + this.convert(orderingCond[i]) + " <= " + max_value;
                        whereAdded = true;
                    }
                }
                if ((sort = this.getOrderingCondition(orderingCond[i])) == null) {
                    sort = SortOrder.descending;
                }
                if (!this.isSupported(sort) || !this.isSupported(orderingCond[i])) continue;
                if (orderByAdded) {
                    sqlClauses[1] = sqlClauses[1] + ", ";
                }
                sqlClauses[1] = sqlClauses[1] + sourceTable + this.convert(orderingCond[i]) + this.convert(sort);
                orderByAdded = true;
            }
        }
        if (whereAdded) {
            sqlClauses[0] = sqlClauses[0] + " ";
        }
        if (orderByAdded) {
            sqlClauses[1] = sqlClauses[1] + ", ";
        }
        sqlClauses[1] = sqlClauses[1] + sourceTable + "rule_id desc ";
        return sqlClauses;
    }

    String convert(RuleProperty property) {
        if (property.equals((Object)RuleProperty.support)) {
            return "rule_support ";
        }
        if (property.equals((Object)RuleProperty.confidence)) {
            return "rule_confidence ";
        }
        return "";
    }

    String convert(SortOrder sortOrder) {
        if (sortOrder.equals((Object)SortOrder.ascending)) {
            return "asc";
        }
        if (sortOrder.equals((Object)SortOrder.descending)) {
            return "desc";
        }
        return "";
    }

    int getRuleLength() {
        if (this.m_propertyMap.isEmpty()) {
            return 0;
        }
        int rule_length = 0;
        Set keySet = this.m_propertyMap.keySet();
        Vector properties = new Vector(keySet.size());
        for (RuleProperty property : keySet) {
            PropertyFilter filter;
            ComparisonOperator compOp;
            if (!property.equals((Object)RuleProperty.length) || (compOp = (filter = (PropertyFilter)this.m_propertyMap.get(property)).getComparisonOperator()) == null) continue;
            rule_length = (int)filter.getThreshold();
            break;
        }
        return rule_length;
    }

    ComparisonOperator getRuleLengthOperator() {
        if (this.m_propertyMap.isEmpty()) {
            return null;
        }
        ComparisonOperator compOp = null;
        Set keySet = this.m_propertyMap.keySet();
        Vector properties = new Vector(keySet.size());
        for (RuleProperty property : keySet) {
            if (!property.equals((Object)RuleProperty.length)) continue;
            PropertyFilter filter = (PropertyFilter)this.m_propertyMap.get(property);
            compOp = filter.getComparisonOperator();
            break;
        }
        return compOp;
    }

    class PropertyFilter {
        private int m_order;
        private double m_minValue;
        private double m_maxValue;
        private SortOrder m_sortOrder = SortOrder.ascending;
        private ComparisonOperator m_compOp = null;

        public PropertyFilter() {
            this.reset();
        }

        private void reset() {
            this.m_minValue = -1.0;
            this.m_maxValue = -1.0;
            this.m_order = -1;
            this.m_sortOrder = SortOrder.ascending;
            this.m_compOp = null;
        }

        public void setMinValue(double minValue) {
            this.m_minValue = minValue;
        }

        public void setMaxValue(double maxValue) {
            this.m_maxValue = maxValue;
            this.m_compOp = null;
        }

        public double getMinValue() {
            return this.m_minValue;
        }

        public double getMaxValue() {
            return this.m_maxValue;
        }

        public double getThreshold() {
            if (this.m_maxValue != -1.0 && this.m_compOp != null) {
                return this.m_minValue;
            }
            return -1.0;
        }

        public void setThreshold(ComparisonOperator compOp, double threshold) {
            this.m_minValue = threshold;
            this.m_compOp = compOp;
            this.m_maxValue = -1.0;
        }

        public ComparisonOperator getComparisonOperator() {
            return this.m_compOp;
        }

        public void resetOrdering() {
            this.m_order = -1;
        }

        public void setSortOrder(SortOrder sortOrder, int orderIndex) {
            this.m_sortOrder = sortOrder;
            this.m_order = orderIndex;
        }

        public SortOrder getSortOrder() {
            return this.m_sortOrder;
        }

        public int getOrder() {
            return this.m_order;
        }
    }
}

