/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.association;

import java.math.BigDecimal;
import java.util.Vector;
import javax.datamining.association.Itemset;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.resource.OraConnection;

public class OraItemset
extends OraDMObject
implements Itemset {
    private int m_itemsetId;
    private double m_support = 0.0;
    private Vector m_items = new Vector();

    OraItemset(OraConnection dmeConn) {
        super(dmeConn, null);
    }

    void setItemsetId(int itemset_id) {
        this.m_itemsetId = itemset_id;
    }

    public int getItemsetId() {
        return this.m_itemsetId;
    }

    void addItem(Object item) {
        this.m_items.addElement(item);
    }

    void addItem(String attributeName, Double numValue, String strValue) {
        this.m_items.addElement(new OraItem(attributeName, numValue, strValue));
    }

    void setSupport(double support) {
        this.m_support = support;
    }

    public Object[] getItems() {
        return this.m_items.toArray();
    }

    public double getSupport() {
        return this.m_support * 100.0;
    }

    public int getAbsoluteSupport() {
        this.unsupported("Itemset.getAbsoluteSupport");
        return 0;
    }

    public int getSize() {
        return this.m_items.size();
    }

    public static class OraItem {
        private String m_attrName;
        private String m_strValue;
        private Double m_numValue;

        public OraItem(String attributeName, Double numValue, String strValue) {
            this.m_attrName = attributeName;
            this.m_strValue = strValue;
            this.m_numValue = numValue;
        }

        public String getAttributeName() {
            return this.m_attrName;
        }

        public Object getAttributeValue() {
            if (this.m_numValue == null) {
                return this.m_strValue;
            }
            return this.m_numValue;
        }

        public String toString() {
            BigDecimal attrNumValue;
            StringBuffer itemStr = new StringBuffer();
            Object attrValue = this.getAttributeValue();
            String attrStrValue = null;
            attrStrValue = attrValue instanceof String ? (String)attrValue : ((attrNumValue = new BigDecimal((Double)attrValue)).scale() == 0 ? Long.toString(attrNumValue.longValue()) : attrValue.toString());
            itemStr.append(this.getAttributeName()).append("-").append(attrStrValue);
            return itemStr.toString();
        }
    }
}

