/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.association;

import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.association.AssociationCapability;
import javax.datamining.association.AssociationSettings;
import javax.datamining.association.AssociationSettingsFactory;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.OraSupportedEnums;
import oracle.dmt.jdm.association.OraAssociationSettings;

public class OraAssociationSettingsFactory
extends OraFactory
implements AssociationSettingsFactory {
    private static final OraSupportedEnums supportedCapabilities = new OraSupportedEnums(new Enum[]{AssociationCapability.minimumSupport, AssociationCapability.minimumConfidence, AssociationCapability.maximumRuleLength});

    public AssociationSettings create() throws JDMException {
        OraAssociationSettings associationSettings = new OraAssociationSettings(this.m_dmeConn, this);
        return associationSettings;
    }

    public boolean supportsCapability(AssociationCapability capability) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(capability, "capability");
        return supportedCapabilities.isSupported((Enum)capability);
    }

    public boolean supportsCapability(MiningAlgorithm algorithm, AssociationCapability capability) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(algorithm, "algorithm");
        this.m_dmeConn.getValidationHandler().validateNotNull(capability, "capability");
        if (algorithm.equals((Object)OraMiningAlgorithm.aprioriAssociationRules)) {
            return this.supportsCapability(capability);
        }
        return false;
    }
}

