/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.association;

import javax.datamining.JDMException;
import javax.datamining.MiningFunction;
import javax.datamining.association.AssociationSettings;
import javax.datamining.base.AlgorithmSettings;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.association.OraAssociationRulesAlgorithmSettings;
import oracle.dmt.jdm.association.OraAssociationRulesAlgorithmSettingsFactory;
import oracle.dmt.jdm.association.OraAssociationSettingsFactory;
import oracle.dmt.jdm.base.OraBuildSettings;
import oracle.dmt.jdm.resource.OraConnection;

public class OraAssociationSettings
extends OraBuildSettings
implements AssociationSettings {
    private static final double ASSO_DEFAULT_SUPPORT = 0.1;
    private static final double ASSO_DEFAULT_CONFIDENCE = 0.1;
    private static final int ASSO_DEFAULT_MAX_RULE_LENGTH = 4;
    private static final int ASSO_MIN_MAX_RULE_LENGTH = 2;
    private static final int ASSO_MAX_MAX_RULE_LENGTH = 20;

    OraAssociationSettings(OraConnection dmeConn, OraAssociationSettingsFactory factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, MiningFunction.association);
        this.setValue("ASSO_MAX_RULE_LENGTH", Integer.toString(4));
        this.setValue("ASSO_MIN_SUPPORT", Double.toString(0.1));
        this.setValue("ASSO_MIN_CONFIDENCE", Double.toString(0.1));
    }

    protected AlgorithmSettings getDefaultAlgorithmSettings() {
        OraAssociationRulesAlgorithmSettings algo = null;
        try {
            OraAssociationRulesAlgorithmSettingsFactory factory = new OraAssociationRulesAlgorithmSettingsFactory();
            algo = (OraAssociationRulesAlgorithmSettings)factory.create();
        }
        catch (JDMException jDMException) {
            // empty catch block
        }
        return algo;
    }

    protected boolean isSupported(AlgorithmSettings algoSettings) {
        return algoSettings instanceof OraAssociationRulesAlgorithmSettings;
    }

    public Double getMinSupport() {
        String minSupport = this.getValue("ASSO_MIN_SUPPORT");
        return new Double(Double.parseDouble(minSupport) * 100.0);
    }

    public void setMinSupport(double minSupport) {
        this.getValidationHandler().validateNumber(minSupport, 0.0, 100.0, "minSupport");
        this.setValue("ASSO_MIN_SUPPORT", Double.toString(minSupport / 100.0));
    }

    public Double getMinConfidence() {
        String minConfidence = this.getValue("ASSO_MIN_CONFIDENCE");
        return new Double(Double.parseDouble(minConfidence) * 100.0);
    }

    public void setMinConfidence(double minConfidence) {
        this.getValidationHandler().validateNumber(minConfidence, 0.0, 100.0, "minConfidence");
        this.setValue("ASSO_MIN_CONFIDENCE", Double.toString(minConfidence / 100.0));
    }

    public int getMaxRuleLength() {
        String maxRuleLength = this.getValue("ASSO_MAX_RULE_LENGTH");
        return Integer.parseInt(maxRuleLength);
    }

    public void setMaxRuleLength(int maxRuleLength) {
        this.getValidationHandler().validateNumber(maxRuleLength, 2, 20, "maxRuleLength");
        this.setValue("ASSO_MAX_RULE_LENGTH", Integer.toString(maxRuleLength));
    }

    public void setMaxRuleComponentLength(int maxLength, boolean isAntecedent) {
        this.unsupported("AssociationSettings.MaxRuleComponentLength");
    }

    public int getMaxRuleComponentLength(boolean isAntecedent) {
        this.unsupported("AssociationSettings.MaxRuleComponentLength");
        return 0;
    }

    public int getMaxNumberOfRules() {
        this.unsupported("AssociationSettings.MaxNumberOfRules");
        return 0;
    }

    public void setMaxNumberOfRules(int maxRules) {
        this.unsupported("AssociationSettings.MaxNumberOfRules");
    }

    public Object[] getItems(boolean included) {
        this.unsupported("AssociationSettings includedItems and excludedItems");
        return null;
    }

    public void addItem(Object item, boolean included) throws JDMException {
        this.unsupported("AssociationSettings includedItems and excludedItems");
    }

    public void addItems(Object[] items, boolean included) throws JDMException {
        this.unsupported("AssociationSettings includedItems and excludedItems");
    }

    public void removeItem(Object item, boolean included) {
        this.unsupported("AssociationSettings includedItems and excludedItems");
    }

    public void removeItems(Object[] items, boolean included) {
        this.unsupported("AssociationSettings includedItems and excludedItems");
    }

    public void setTaxonomyName(String attributeName, String taxonomyName) throws JDMException {
        this.unsupported("AssociationSettings Taxonomy");
    }

    public String getTaxonomyName(String attributeName) throws JDMException {
        this.unsupported("AssociationSettings Taxonomy");
        return null;
    }
}

