/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.algorithm.tree;

import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.SizeUnit;
import javax.datamining.algorithm.tree.TreeHomogeneityMetric;
import javax.datamining.algorithm.tree.TreeSelectionMethod;
import javax.datamining.algorithm.tree.TreeSettings;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.OraSupervisedAlgorithmSettings;

public class OraTreeSettings
extends OraSupervisedAlgorithmSettings
implements TreeSettings {
    private SizeUnit m_nodeSizeUnit = null;
    private SizeUnit m_nodeSizeUnitSplit = null;

    OraTreeSettings(OraConnection dmeConn, OraFactory factory) throws JDMException {
        super(dmeConn, factory, MiningAlgorithm.decisionTree, "ALGO_DECISION_TREE");
        this.setValue("TREE_TERM_MAX_DEPTH", Integer.toString(7));
        this.setValue("TREE_TERM_MINREC_NODE", Integer.toString(10));
        this.setValue("TREE_TERM_MINPCT_NODE", Double.toString(0.05));
        this.setValue("TREE_TERM_MINREC_SPLIT", Integer.toString(20));
        this.setValue("TREE_TERM_MINPCT_SPLIT", Double.toString(0.1));
        this.setValue("TREE_IMPURITY_METRIC", "TREE_IMPURITY_GINI");
        this.m_nodeSizeUnit = SizeUnit.count;
        this.m_nodeSizeUnitSplit = SizeUnit.count;
    }

    public int getMaxSurrogates() {
        this.unsupported("TreeSettings.getMaxSurrogates");
        return 0;
    }

    public void setMaxSurrogates(int maxSurrogates) {
        this.unsupported("TreeSettings.setMaxSurrogates");
    }

    public int getMaxDepth() {
        String maxDepth = this.getValue("TREE_TERM_MAX_DEPTH");
        return Integer.parseInt(maxDepth);
    }

    public void setMaxDepth(int maxDepth) {
        this.getValidationHandler().validateNumber(maxDepth, 2, 20, "maxDepth");
        this.setValue("TREE_TERM_MAX_DEPTH", Integer.toString(maxDepth));
    }

    public void determineMaxDepth(boolean determineMaxDepth) {
        this.unsupported("TreeSettings.determineMaxDepth");
    }

    public boolean determineMaxDepth() {
        this.unsupported("TreeSettings.determineMaxDepth");
        return true;
    }

    public double getMinNodeSize() {
        String term = "TREE_TERM_MINREC_NODE";
        if (this.m_nodeSizeUnit.equals((Object)SizeUnit.percentage)) {
            term = "TREE_TERM_MINPCT_NODE";
        }
        String minNodeSize = this.getValue(term);
        return Double.parseDouble(minNodeSize);
    }

    public double getMinNodeSize(SizeUnit unit) {
        this.getValidationHandler().validateNotNull(unit, "unit");
        String term = "TREE_TERM_MINREC_NODE";
        if (unit.equals((Object)SizeUnit.percentage)) {
            term = "TREE_TERM_MINPCT_NODE";
        }
        String minNodeSize = this.getValue(term);
        return Double.parseDouble(minNodeSize);
    }

    public SizeUnit getMinNodeSizeUnit() {
        return this.m_nodeSizeUnit;
    }

    public void setMinNodeSize(double size, SizeUnit unit) {
        this.getValidationHandler().validateNotNull(unit, "unit");
        if (unit.equals((Object)SizeUnit.count)) {
            long nodeSize = (long)size;
            this.getValidationHandler().validateNumber(nodeSize, 0L, "size");
            this.m_nodeSizeUnit = unit;
            this.setValue("TREE_TERM_MINREC_NODE", Long.toString(nodeSize));
        } else {
            this.getValidationHandler().validateNumber(size, 0.0, 10.0, "size");
            this.m_nodeSizeUnit = unit;
            this.setValue("TREE_TERM_MINPCT_NODE", Double.toString(size));
        }
    }

    public double getMinDecreaseInImpurity() {
        this.unsupported("TreeSettings.getMinDecreaseInImpurity");
        return 0.0;
    }

    public double getMinNodeSizeForSplit(SizeUnit unit) {
        this.getValidationHandler().validateNotNull(unit, "unit");
        double minNodeSizeForSplit = 0.0;
        if (unit.equals((Object)SizeUnit.percentage)) {
            String minPctSplit = this.getValue("TREE_TERM_MINPCT_SPLIT");
            minNodeSizeForSplit = Double.parseDouble(minPctSplit);
        } else {
            String minRecSplit = this.getValue("TREE_TERM_MINREC_SPLIT");
            minNodeSizeForSplit = Double.parseDouble(minRecSplit);
        }
        return minNodeSizeForSplit;
    }

    public void setMinDecreaseInImpurity(double minImpurity) {
        this.unsupported("TreeSettings.setMinDecreaseInImpurity");
    }

    public void setMinNodeSizeForSplit(double minNodeSize, SizeUnit unit) {
        this.getValidationHandler().validateNotNull(unit, "unit");
        if (unit.equals((Object)SizeUnit.percentage)) {
            this.getValidationHandler().validateNumber(minNodeSize, 0.0, 100.0, "minNodeSize");
            this.setValue("TREE_TERM_MINPCT_SPLIT", Double.toString(minNodeSize));
        } else {
            this.getValidationHandler().validateNumber(minNodeSize, 0.0, "minNodeSize");
            int recordCount = (int)minNodeSize;
            this.setValue("TREE_TERM_MINREC_SPLIT", Integer.toString(recordCount));
        }
        this.m_nodeSizeUnitSplit = unit;
    }

    public TreeSelectionMethod getTreeSelectionMethod() {
        this.unsupported("TreeSettings.getTreeSelectionMethod");
        return null;
    }

    public void setTreeSelectionMethod(TreeSelectionMethod selectionMethod) {
        this.unsupported("TreeSettings.setTreeSelectionMethod");
    }

    public int getMaxSplits() {
        this.unsupported("TreeSettings.getMaxSplits");
        return 0;
    }

    public void setMaxSplits(int maxSplits) {
        this.unsupported("TreeSettings.setMaxSplits");
    }

    public double getMaximumPValue() {
        this.unsupported("TreeSettings.getMaximumPValue");
        return 0.0;
    }

    public void setMaximumPValue(double maxPValue) {
        this.unsupported("TreeSettings.setMaximumPValue");
    }

    public TreeHomogeneityMetric getBuildHomogeneityMetric() {
        String metric = this.getValue("TREE_IMPURITY_METRIC");
        return OraPLSQLMappings.getTreeHomogeneityMetric(metric);
    }

    public void setBuildHomogeneityMetric(TreeHomogeneityMetric buildMetric) {
        this.getValidationHandler().validateNotNull(buildMetric, "buildMetric");
        String metric = OraPLSQLMappings.getPLSQLConstant(buildMetric);
        if (buildMetric.equals((Object)TreeHomogeneityMetric.systemDetermined) || buildMetric.equals((Object)TreeHomogeneityMetric.systemDefault)) {
            metric = "TREE_IMPURITY_GINI";
        } else if (metric == null) {
            this.getExceptionHandler().createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"TreeHomogeneityMetric", buildMetric.name()}, null);
        }
        this.setValue("TREE_IMPURITY_METRIC", metric);
    }

    public TreeHomogeneityMetric getPruningHomogeneityMetric() {
        this.unsupported("TreeSettings.getPruningHomogeneityMetric");
        return null;
    }

    public void setPruningHomogeneityMetric(TreeHomogeneityMetric pruningMetric) {
        this.unsupported("TreeSettings.setPruningHomogeneityMetric");
    }

    public void computeNodeStatistics(boolean computeNodeStatistics) {
        this.unsupported("TreeSettings.computeNodeStatistics");
    }

    public boolean getComputeNodeStatistics() {
        this.unsupported("TreeSettings.getComputeNodeStatistics");
        return true;
    }
}

