/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.algorithm.svm.regression;

import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.algorithm.svm.regression.SVMRegressionCapability;
import javax.datamining.algorithm.svm.regression.SVMRegressionSettings;
import javax.datamining.algorithm.svm.regression.SVMRegressionSettingsFactory;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraSupportedEnums;
import oracle.dmt.jdm.algorithm.svm.regression.OraSVMRegressionSettings;

public class OraSVMRegressionSettingsFactory
extends OraFactory
implements SVMRegressionSettingsFactory {
    private static final KernelFunction default_kernel = KernelFunction.systemDetermined;
    private static final double default_conergence_tolerance = 0.001;
    private static final int default_cache_size = 50000000;
    private static final OraSupportedEnums supportedKernelFunctions = new OraSupportedEnums(new Enum[]{KernelFunction.kGaussian, KernelFunction.kLinear, KernelFunction.systemDefault, KernelFunction.systemDetermined});
    private static final OraSupportedEnums supportedConnectionCapabilities = new OraSupportedEnums(new Enum[]{SVMRegressionCapability.complexityFactor, SVMRegressionCapability.kernelCacheSize, SVMRegressionCapability.standardDeviation, SVMRegressionCapability.tolerance});

    public SVMRegressionSettings create() throws JDMException {
        OraSVMRegressionSettings svmSettings = new OraSVMRegressionSettings(this.m_dmeConn, this);
        svmSettings.setKernelFunction(default_kernel);
        svmSettings.setTolerance(0.001);
        return svmSettings;
    }

    public boolean supportsCapability(SVMRegressionCapability capability) throws JDMException {
        return supportedConnectionCapabilities.isSupported((Enum)capability);
    }

    public boolean supportsCapability(KernelFunction kernelFunction) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(kernelFunction, "kernelFunction");
        return supportedKernelFunctions.isSupported((Enum)kernelFunction);
    }
}

