/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.algorithm.svm.classification;

import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.algorithm.svm.classification.SVMClassificationCapability;
import javax.datamining.algorithm.svm.classification.SVMClassificationSettings;
import javax.datamining.algorithm.svm.classification.SVMClassificationSettingsFactory;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraSupportedEnums;
import oracle.dmt.jdm.algorithm.svm.classification.OraSVMClassificationSettings;

public class OraSVMClassificationSettingsFactory
extends OraFactory
implements SVMClassificationSettingsFactory {
    private static final KernelFunction default_kernel = KernelFunction.systemDetermined;
    private static final double default_conergence_tolerance = 0.001;
    private static final int default_cache_size = 50000000;
    private static final OraSupportedEnums supportedKernelFunctions = new OraSupportedEnums(new Enum[]{KernelFunction.kGaussian, KernelFunction.kLinear, KernelFunction.systemDefault, KernelFunction.systemDetermined});
    private static final OraSupportedEnums supportedConnectionCapabilities = new OraSupportedEnums(new Enum[]{SVMClassificationCapability.complexityFactor, SVMClassificationCapability.kernelCacheSize, SVMClassificationCapability.standardDeviation, SVMClassificationCapability.tolerance});

    public SVMClassificationSettings create() throws JDMException {
        OraSVMClassificationSettings svmSettings = new OraSVMClassificationSettings(this.m_dmeConn, this);
        svmSettings.setKernelFunction(default_kernel);
        svmSettings.setTolerance(0.001);
        return svmSettings;
    }

    public boolean supportsCapability(SVMClassificationCapability capability) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(capability, "capability");
        return supportedConnectionCapabilities.isSupported((Enum)capability);
    }

    public boolean supportsCapability(KernelFunction kernelFunction) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(kernelFunction, "kernelFunction");
        return supportedKernelFunctions.isSupported((Enum)kernelFunction);
    }
}

