/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.algorithm.svm.classification;

import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.algorithm.svm.classification.SVMClassificationSettings;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.algorithm.svm.classification.OraSVMClassificationSettingsFactory;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.OraSupervisedAlgorithmSettings;

public class OraSVMClassificationSettings
extends OraSupervisedAlgorithmSettings
implements SVMClassificationSettings {
    OraSVMClassificationSettings(OraConnection dmeConn, OraFactory factory) throws JDMException {
        super(dmeConn, factory, MiningAlgorithm.svmClassification, "ALGO_SUPPORT_VECTOR_MACHINES");
    }

    public KernelFunction getKernelFunction() {
        if (this.getValue("SVMS_KERNEL_FUNCTION") != null) {
            return OraPLSQLMappings.getKernelFunction(this.getValue("SVMS_KERNEL_FUNCTION"));
        }
        return KernelFunction.systemDefault;
    }

    public void setKernelFunction(KernelFunction kernelFunction) {
        this.getValidationHandler().validateNotNull(kernelFunction, "kernelFunction");
        OraSVMClassificationSettingsFactory factory = (OraSVMClassificationSettingsFactory)this.getFactory();
        boolean supported = false;
        try {
            supported = factory.supportsCapability(kernelFunction);
        }
        catch (JDMException jdmExp) {
            // empty catch block
        }
        if (!supported) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"kernelFunction", kernelFunction.name()}, null);
        }
        this.setValue("SVMS_KERNEL_FUNCTION", OraPLSQLMappings.getPLSQLConstant(kernelFunction));
    }

    public double getCStrategy() {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "OraSVMClassificationSettings.getCStrategy"}, null);
        return -1.0;
    }

    public void setCStrategy(double cValue) {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "OraSVMClassificationSettings.setCStrategy"}, null);
    }

    public double getTolerance() {
        if (this.getValue("SVMS_CONV_TOLERANCE") == null) {
            this.createRuntimeException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"svms_conv_tolerance", "algorithm", "settings"}, null);
        }
        return Double.parseDouble(this.getValue("SVMS_CONV_TOLERANCE"));
    }

    public void setTolerance(double tolerance) {
        this.getValidationHandler().validateNumber(tolerance, 0.0, 0.1, false, true, "tolerance");
        this.setValue("SVMS_CONV_TOLERANCE", Double.toString(tolerance));
    }

    public double getStandardDeviation() {
        if (this.getValue("SVMS_STD_DEV") == null) {
            this.createRuntimeException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"svms_std_dev", "algorithm", "settings"}, null);
        }
        return Double.parseDouble(this.getValue("SVMS_STD_DEV"));
    }

    public void setStandardDeviation(double stdDeviation) {
        if (this.getKernelFunction().equals((Object)KernelFunction.kGaussian)) {
            this.getValidationHandler().validateNumber(stdDeviation, 0.0, Double.MAX_VALUE, false, false, "stdDeviation");
            this.setValue("SVMS_STD_DEV", Double.toString(stdDeviation));
        } else {
            try {
                this.createException(OraJDMBundleKeys.JDM_INCOMPATIBLE_SPECIFICATION, new String[]{"stdDeviation", "", this.getKernelFunction().name(), "kernel function"}, null);
            }
            catch (JDMException e) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"stdDeviation", this.getKernelFunction().name(), "kernel function"}, e);
            }
        }
    }

    public double getComplexityFactor() {
        if (this.getValue("SVMS_COMPLEXITY_FACTOR") == null) {
            try {
                this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"svms_complexity_factor", "algorithm", "settings"}, null);
            }
            catch (JDMException e) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, e);
            }
        }
        return Double.parseDouble(this.getValue("SVMS_COMPLEXITY_FACTOR"));
    }

    public void setComplexityFactor(double complexityFactor) {
        if (this.getValue("SVMS_OUTLIER_RATE") != null) {
            try {
                this.createException(OraJDMBundleKeys.JDM_INCOMPATIBLE_SPECIFICATION, new String[]{"svms_complexity_factor", "", "svms_outlier_rate", ""}, null);
            }
            catch (JDMException e) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{"complexityFactor"}, e);
            }
        }
        this.getValidationHandler().validateNumber(complexityFactor, 0.0, Double.MAX_VALUE, false, true, "complexityFactor");
        this.setValue("SVMS_COMPLEXITY_FACTOR", Double.toString(complexityFactor));
    }

    public int getKernelCacheSize() {
        if (this.getValue("SVMS_KERNEL_CACHE_SIZE") == null) {
            try {
                this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"svms_kernel_cache_size", "algorithm", "settings"}, null);
            }
            catch (JDMException e) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, e);
            }
        }
        return Integer.parseInt(this.getValue("SVMS_KERNEL_CACHE_SIZE"));
    }

    public void setKernelCacheSize(int kernelCacheSize) {
        if (this.getKernelFunction().equals((Object)KernelFunction.kGaussian)) {
            this.getValidationHandler().validateNumber(kernelCacheSize, 1, Integer.MAX_VALUE, "cacheSize");
            this.setValue("SVMS_KERNEL_CACHE_SIZE", Integer.toString(kernelCacheSize));
        } else {
            try {
                this.createException(OraJDMBundleKeys.JDM_INCOMPATIBLE_SPECIFICATION, new String[]{"kernelCacheSize", "", this.getKernelFunction().name(), "kernel function"}, null);
            }
            catch (JDMException e) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"kernelCacheSize", this.getKernelFunction().name(), "kernel function"}, e);
            }
        }
    }

    public int getPolynomialDegree() {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "OraSVMClassificationSettings.getPolynomialDegree"}, null);
        return -1;
    }

    public void setPolynomialDegree(int degree) {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "OraSVMClassificationSettings.setPolynomialDegree"}, null);
    }

    public double getOutlierRate() {
        if (this.getValue("SVMS_OUTLIER_RATE") == null) {
            try {
                this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"svms_outlier_rate", "algorithm", "settings"}, null);
            }
            catch (JDMException e) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, e);
            }
        }
        return Double.parseDouble(this.getValue("SVMS_OUTLIER_RATE"));
    }

    public void setOutlierRate(double outlierRate) {
        if (this.getValue("SVMS_COMPLEXITY_FACTOR") != null) {
            try {
                this.createException(OraJDMBundleKeys.JDM_INCOMPATIBLE_SPECIFICATION, new String[]{"svms_outlier_rate", "", "svms_complexity_factor", ""}, null);
            }
            catch (JDMException e) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{"outlierRate"}, e);
            }
        }
        this.getValidationHandler().validateNumber(outlierRate, 0.0, 1.0, false, false, "outlierRate");
        this.setValue("SVMS_OUTLIER_RATE", Double.toString(outlierRate));
    }

    public boolean getActiveLearning() {
        if (this.getValue("SVMS_ACTIVE_LEARNING") != null) {
            return OraPLSQLMappings.getActiveLearning(this.getValue("SVMS_ACTIVE_LEARNING"));
        }
        return true;
    }

    public void setActiveLearning(boolean enable) {
        if (enable) {
            this.setValue("SVMS_ACTIVE_LEARNING", "SVMS_AL_ENABLE");
        } else {
            this.setValue("SVMS_ACTIVE_LEARNING", "SVMS_AL_DISABLE");
        }
    }
}

