/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.algorithm.ocluster;

import javax.datamining.JDMException;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.algorithm.ocluster.OraOClusterSettings;
import oracle.dmt.jdm.clustering.OraClusteringAlgorithmSettings;
import oracle.dmt.jdm.resource.OraConnection;

public class OraOClusterSettingsImpl
extends OraClusteringAlgorithmSettings
implements OraOClusterSettings {
    private static long DEFAULT_MAX_BUFFER = 50000L;
    private static double DEFAULT_SENSITIVITY = 0.5;

    public double getSensitivity() {
        String sensitivity = this.getValue("OCLT_SENSITIVITY");
        return sensitivity == null ? DEFAULT_SENSITIVITY : Double.parseDouble(sensitivity);
    }

    public void setSensitivity(double sensitivity) {
        this.getValidationHandler().validateNumber(sensitivity, 0.0, 1.0, "sensitivity");
        String value = Double.toString(sensitivity);
        this.setValue("OCLT_SENSITIVITY", value);
    }

    public long getBufferSize() {
        String bufferSize = this.getValue("OCLT_MAX_BUFFER");
        return bufferSize == null ? DEFAULT_MAX_BUFFER : Long.parseLong(bufferSize);
    }

    public void setBufferSize(long bufferSize) {
        this.getValidationHandler().validateNumber(bufferSize, 1L, "bufferSize");
        String value = Long.toString(bufferSize);
        this.setValue("OCLT_MAX_BUFFER", value);
    }

    protected OraOClusterSettingsImpl(OraConnection dmeConn, OraFactory factory) throws JDMException {
        super(dmeConn, factory, OraMiningAlgorithm.oCluster, "ALGO_O_CLUSTER");
    }
}

