/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.algorithm.naivebayes;

import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.algorithm.naivebayes.NaiveBayesSettings;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.OraSupervisedAlgorithmSettings;

public class OraNaiveBayesSettings
extends OraSupervisedAlgorithmSettings
implements NaiveBayesSettings {
    private final double DEFAULT_SINGLETON_THRESHOLD = 0.0;
    private final double DEFAULT_PAIRWISE_THRESHOLD = 0.0;

    OraNaiveBayesSettings(OraConnection dmeConn, OraFactory factory) throws JDMException {
        super(dmeConn, factory, MiningAlgorithm.naiveBayes, "ALGO_NAIVE_BAYES");
        this.setSingletonThreshold(0.0);
        this.setPairwiseThreshold(0.0);
    }

    public double getSingletonThreshold() {
        return this.getThreshold("NABS_SINGLETON_THRESHOLD");
    }

    public void setSingletonThreshold(double singletonThreshold) {
        this.getValidationHandler().validateNumber(singletonThreshold, 0.0, 1.0, true, false, "singletonThreshold");
        String thresholdVal = Double.toString(singletonThreshold);
        this.setValue("NABS_SINGLETON_THRESHOLD", thresholdVal);
    }

    public double getPairwiseThreshold() {
        return this.getThreshold("NABS_PAIRWISE_THRESHOLD");
    }

    public void setPairwiseThreshold(double pairwiseThreshold) {
        this.getValidationHandler().validateNumber(pairwiseThreshold, 0.0, 1.0, true, false, "singletonThreshold");
        String thresholdVal = Double.toString(pairwiseThreshold);
        this.setValue("NABS_PAIRWISE_THRESHOLD", thresholdVal);
    }

    private double getThreshold(String key) {
        String threshold = this.getValue(key);
        if (threshold == null) {
            return 0.0;
        }
        return Double.parseDouble(threshold);
    }
}

