/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm;

import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import javax.datamining.ExecutionState;
import javax.datamining.ExecutionStatus;
import javax.datamining.JDMException;
import oracle.dmt.jdm.scheduler.OraJobInfo;

public class OraExecutionStatus
implements ExecutionStatus {
    private static HashMap s_stateMap = null;
    private OraJobInfo m_jobInfo = null;
    private ExecutionState m_state = null;
    private String m_description = null;
    private Date m_timestamp = null;

    public OraExecutionStatus(OraJobInfo jobInfo) throws JDMException {
        this.m_jobInfo = jobInfo;
    }

    public OraExecutionStatus(ExecutionState state, String description) {
        this.m_state = state;
        this.m_description = description;
        this.m_timestamp = new Date();
    }

    public OraExecutionStatus(String jobState, String description) {
        this.m_state = (ExecutionState)s_stateMap.get(jobState);
        this.m_description = description;
        this.m_timestamp = new Date();
    }

    public ExecutionState getState() {
        ExecutionState state = null;
        state = this.m_jobInfo == null ? this.m_state : (ExecutionState)s_stateMap.get(this.m_jobInfo.getState());
        return state;
    }

    public Date getTimestamp() {
        if (this.m_timestamp != null) {
            return this.m_timestamp;
        }
        if (this.m_jobInfo == null) {
            return null;
        }
        if ("SCHEDULED".equals(this.m_jobInfo.getState()) || "RUNNING".equals(this.m_jobInfo.getState()) || "READY TO RUN".equals(this.m_jobInfo.getState())) {
            return this.m_jobInfo.getStartTimestamp();
        }
        return this.m_jobInfo.getEndTimestamp();
    }

    public String getDescription() {
        if (this.m_description != null) {
            return this.m_description;
        }
        String description = null;
        if (this.m_jobInfo == null) {
            return null;
        }
        try {
            description = this.m_jobInfo.getFailureMessage();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return description;
    }

    public boolean containsWarning() {
        return false;
    }

    static {
        s_stateMap = new HashMap(6);
        s_stateMap.put("SCHEDULED", ExecutionState.submitted);
        s_stateMap.put("RUNNING", ExecutionState.executing);
        s_stateMap.put("SUCCEEDED", ExecutionState.success);
        s_stateMap.put("FAILED", ExecutionState.error);
        s_stateMap.put("STOPPED", ExecutionState.terminated);
        s_stateMap.put("READY TO RUN", ExecutionState.submitted);
    }
}

