/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import javax.datamining.ExecutionHandle;
import javax.datamining.ExecutionState;
import javax.datamining.ExecutionStatus;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.OraExecutionStatus;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.scheduler.OraJob;
import oracle.dmt.jdm.scheduler.OraJobInfo;

public class OraExecutionHandle
extends OraDMObject
implements ExecutionHandle {
    private String m_taskName;
    private OraJob m_job;

    public OraExecutionHandle(OraConnection dmeConn, OraJob job) {
        super(dmeConn, null);
        this.m_job = job;
        this.m_taskName = job.getName();
    }

    private void setUp() {
        if (this.m_job == null) {
            // empty if block
        }
    }

    public ExecutionStatus terminate() throws JDMException {
        this.setUp();
        try {
            OraJob.stopJob(this.getDatabaseConnection(), this.m_taskName, this.getLogger(), false);
        }
        catch (SQLException sqlExp) {
            this.createException("2000", new Object[]{"OraExecutionHandle.terminate"}, sqlExp);
        }
        return this.getLatestStatus();
    }

    public ExecutionStatus forceTerminate() throws JDMException {
        this.setUp();
        try {
            OraJob.stopJob(this.getDatabaseConnection(), this.m_taskName, this.getLogger(), true);
        }
        catch (SQLException sqlExp) {
            this.createException("2000", new Object[]{"OraExecutionHandle.terminate"}, sqlExp);
        }
        return this.getLatestStatus();
    }

    public ExecutionStatus getLatestStatus() throws JDMException {
        OraJobInfo jobInfo = null;
        try {
            jobInfo = this.m_job.getJobInfo(this.getDatabaseConnection());
        }
        catch (SQLException sqlExp) {
            this.createException("2000", new Object[]{"OraExecutionHandle.getLatestStatus"}, sqlExp);
        }
        return new OraExecutionStatus(jobInfo);
    }

    public boolean isRunning() throws JDMException {
        ExecutionStatus execStatus = this.getLatestStatus();
        ExecutionState state = execStatus.getState();
        return ExecutionState.executing.equals((Object)state) || ExecutionState.submitted.equals((Object)state);
    }

    public Collection getStatus(Date fromTimestamp) throws JDMException {
        this.unsupported("getStatus(Date fromTimestamp)");
        return null;
    }

    public Date getStartTime() throws JDMException {
        Timestamp startTime = null;
        try {
            startTime = this.m_job.getJobInfo(this.getDatabaseConnection()).getStartTimestamp();
        }
        catch (SQLException sqlExp) {
            this.createException("2000", new Object[]{"OraExecutionHandle.getStartTime"}, sqlExp);
        }
        return startTime;
    }

    public ExecutionStatus waitForCompletion(int timeoutInSeconds) throws JDMException {
        this.getValidationHandler().validateNonNegative(timeoutInSeconds, "timeoutInSeconds");
        OraJobInfo jobInfo = null;
        try {
            jobInfo = this.m_job.waitForCompletion(this.getDatabaseConnection(), timeoutInSeconds);
        }
        catch (SQLException sqlExp) {
            this.createException("2000", new Object[]{"OraExecutionHandle.waitForCompletion"}, sqlExp);
        }
        return new OraExecutionStatus(jobInfo);
    }

    public ExecutionStatus waitForCompletion(int timeoutInSeconds, long pollingIntervalTimeInMilliSeconds) throws JDMException {
        this.getValidationHandler().validateNonNegative(pollingIntervalTimeInMilliSeconds, "pollingIntervalTimeInMilliSeconds");
        this.m_job.setStatusPollingInterval(pollingIntervalTimeInMilliSeconds);
        return this.waitForCompletion(timeoutInSeconds);
    }

    public Integer getDurationInSeconds() throws JDMException {
        Integer duration = null;
        try {
            duration = new Integer((int)this.m_job.getJobInfo(this.getDatabaseConnection()).getExecutionDuration());
        }
        catch (SQLException sqlExp) {
            this.createException("2000", new Object[]{"OraExecutionHandle.getStartTime"}, sqlExp);
        }
        return duration;
    }

    public String getTaskName() {
        return this.m_job.getName();
    }

    public ExecutionStatus[] getWarnings() {
        return null;
    }

    public boolean containsWarning() {
        return false;
    }
}

