/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.extension;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.wizard.WelcomeWizardPage;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dmt.dm4j.ConnectionPersistenceInfo;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.CodeGenDataSource;
import oracle.dmt.dm4j.extension.CodeGenExtensionDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transforms.CodeGenState;
import oracle.dmt.dm4j.wizard.transforms.CodeGenWizard;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.component.NewFilePanel;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorUtil;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLPath;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.ide.view.View;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardWelcomePage;
import oracle.javatools.data.HashStructure;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.model.PathsConfiguration;

public abstract class CodeGenerator
extends Wizard
implements Addin,
Controller {
    private static final String m_extension = "sql";
    private static final String m_untitled = "Untitled";
    private static final String m_newFileDialogTitle = "Create SQL File";
    private static final String m_shortLabel = "Data Mining PL/SQL Package";
    public static final String MYSCHEMA = "MYSCHEMA";
    private static Icon largeIcon;
    public static final int SAMPLE_ONE_MENU_COMMAND_ID;

    public void initialize() {
        System.out.println("* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *");
        System.out.println("**           Data Mining CodeGenerator was initialized    ** ");
        System.out.println("* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *");
    }

    public Icon getIcon() {
        if (largeIcon == null) {
            largeIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("plsql_package.gif"));
        }
        return largeIcon;
    }

    public String getShortLabel() {
        return m_shortLabel;
    }

    public boolean invoke(Context context) {
        boolean bl = false;
        String string = null;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 0) {
            if (elementArray[0] instanceof Locatable) {
                if (elementArray[0] instanceof DatabaseConnection) {
                    DatabaseConnection databaseConnection = (DatabaseConnection)elementArray[0];
                    if (databaseConnection.isOpen()) {
                        string = databaseConnection.getConnectionName();
                    }
                } else if (elementArray[0] instanceof ObjectFolder) {
                    ObjectFolder objectFolder = (ObjectFolder)elementArray[0];
                    String string2 = objectFolder.getObjectType();
                    if (!string2.equals("PACKAGE")) {
                        return false;
                    }
                    string = objectFolder.getConnectionName();
                    string = Connections.getConnectionName((String)string);
                }
            }
            if (string != null) {
                bl = this.addNode(context, string);
            }
        }
        return bl;
    }

    private boolean addNode(Context context, String string) {
        CodeGenWizard codeGenWizard = null;
        boolean bl = false;
        try {
            DatabaseConnections databaseConnections = DatabaseConnections.getInstance();
            Properties properties = databaseConnections.getProperties(string);
            String string2 = properties.getProperty("password");
            if (string2 == null) {
                return false;
            }
            String string3 = properties.getProperty("sid");
            boolean bl2 = false;
            if (string3 == null || 0 == string3.length()) {
                string3 = properties.getProperty("serviceName");
                bl2 = true;
            }
            DM4JConnectionManager.initialize((String)properties.getProperty("hostname"), (String)properties.getProperty("port"), (String)string3, (boolean)bl2, (String)properties.getProperty("user"), (char[])string2.toCharArray(), (Locale)Locale.getDefault());
            Hashtable hashtable = this.getAvailableConnections();
            CodeGenExtensionDataSource codeGenExtensionDataSource = hashtable != null ? new CodeGenExtensionDataSource(string, hashtable) : new CodeGenExtensionDataSource(string);
            CodeGenState codeGenState = new CodeGenState(new BrowserContext(null, LaunchPoint.MENU), (CodeGenDataSource)codeGenExtensionDataSource, 1, null);
            codeGenState.setShowConnectionPage(false);
            WelcomeWizardPage welcomeWizardPage = this.createWelcomePage(codeGenState, false);
            codeGenWizard = new CodeGenWizard(codeGenState, welcomeWizardPage, (JFrame)Ide.getMainWindow());
            if (!codeGenWizard.isCancelled()) {
                String string4 = codeGenWizard.getTargetPackageName();
                this.addPackageNode(context, string, string4);
                bl = true;
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Exception)exception);
            bl = false;
        }
        return bl;
    }

    private Hashtable getAvailableConnections() throws Exception {
        Hashtable<String, ConnectionPersistenceInfo> hashtable = null;
        DatabaseConnections databaseConnections = DatabaseConnections.getInstance();
        Collection collection = databaseConnections.listConnections(true);
        if (collection != null) {
            hashtable = new Hashtable<String, ConnectionPersistenceInfo>();
            for (String string : collection) {
                Properties properties = databaseConnections.getProperties(string);
                ConnectionPersistenceInfo connectionPersistenceInfo = new ConnectionPersistenceInfo();
                connectionPersistenceInfo.setHost(properties.getProperty("hostname"));
                connectionPersistenceInfo.setPort(properties.getProperty("port"));
                String string2 = properties.getProperty("sid");
                if (string2 != null && 0 != string2.length()) {
                    connectionPersistenceInfo.setSid(string2);
                } else {
                    String string3 = properties.getProperty("serviceName");
                    if (string3 == null || 0 == string3.length()) continue;
                    connectionPersistenceInfo.setServiceName(string3);
                }
                connectionPersistenceInfo.setUser(properties.getProperty("user"));
                connectionPersistenceInfo.setMigratedPassword(properties.getProperty("password"));
                hashtable.put(string, connectionPersistenceInfo);
            }
        }
        return hashtable;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == SAMPLE_ONE_MENU_COMMAND_ID) {
            this.showMessageBox(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == SAMPLE_ONE_MENU_COMMAND_ID && CodeGenerator.isMenuAvailable(context)) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    private void showMessageBox(Context context) {
        String string = "Sample One was Invoked!";
        Ide.getStatusBar().setText(string);
        String string2 = "Now Edit this code to do something more interesting!";
        JOptionPane.showMessageDialog(null, string2, string, 1);
    }

    public static boolean isMenuAvailable(Context context) {
        return true;
    }

    public URL createNewFile() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Project project = Ide.getActiveProject();
        URL uRL = null;
        String string = null;
        int n = 1;
        String string2 = m_untitled + n;
        try {
            String string3;
            String string4;
            object4 = PathsConfiguration.getInstance((Project)project);
            object3 = object4.getJavaContentSet();
            URLPath uRLPath = object3.getAllRootDirs();
            uRL = uRLPath.getFirstEntry();
            if (uRL == null) {
                uRL = uRLPath.getFirstEntry();
                object2 = object3.nodeIterator(null);
                object = (Node)object2.next();
                string4 = object.getShortLabel();
                string3 = object.getLongLabel();
                int n2 = string3.indexOf(string4);
                try {
                    uRL = new URL(object.getURL().getProtocol(), object.getURL().getHost(), string3.substring(0, n2 - 1));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            object2 = null;
            object = PatternFilters.getInstance((HashStructure)HashStructure.newInstance());
            object.addInclude("**/*.sql");
            object2 = object3.nodeIterator(null, new IntersectedFilters(object));
            while (object2.hasNext()) {
                string4 = (Node)object2.next();
                string3 = string4.getShortLabel();
                if (0 != (string2 + "." + m_extension).compareTo(string3)) continue;
                string2 = m_untitled + ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            uRL = null;
        }
        if (uRL == null) {
            try {
                object4 = project.getURL();
                object3 = project.getShortLabel();
                int n3 = ((URL)object4).getFile().indexOf((String)object3);
                string = ((URL)object4).getFile().substring(0, n3 - 1);
                object2 = ((URL)object4).getProtocol();
                object = ((URL)object4).getHost();
                uRL = new URL((String)object2, (String)object, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object4 = new NewFilePanel();
        object4.setSupportsAutoFill(false);
        object4.setDirectoryURL(uRL);
        object4.setEnforceFileExtension(true);
        object4.setFileExtension(m_extension);
        object4.setShowExtension(true);
        object4.setFileName(string2 + ".");
        object3 = null;
        try {
            object3 = object4.runDialog(m_newFileDialogTitle);
            if (object3 != null) {
                object3 = object4.getFileURL();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object3;
    }

    private void addPackageNode(Context context, String string, String string2) throws DBException, IllegalAccessException, InstantiationException {
        View view;
        Database database = DatabaseConnections.getInstance().getDatabase(string);
        DBObject dBObject = DBObject.getDBObjectForName((String)string2, (Database)database);
        String string3 = dBObject.getObjectName();
        Node node = dBObject.getNode();
        URL uRL = node.getURL();
        String string4 = DBURLFormatHelper.getBaseType((URL)uRL);
        String string5 = "PACKAGE".equals(string4) ? "PACKAGE BODY" : ("TYPE".equals(string4) ? "TYPE BODY" : null);
        String string6 = database.getUserName();
        String string7 = Connections.getInstance().getConnectionName(database);
        URL uRL2 = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string7, null, (String)string6, (String)"PACKAGE");
        URL uRL3 = DBURLFormatHelper.getURL((URL)uRL2, (String)string2);
        URL uRL4 = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)DBURLFormatHelper.getConnectionName((URL)uRL), (String)DBURLFormatHelper.getCatalog((URL)uRL), (String)DBURLFormatHelper.getSchema((URL)uRL), (String)string5), (String)string3);
        Node node2 = NodeFactory.findOrCreate((URL)uRL2);
        final Node node3 = NodeFactory.findOrCreate((URL)uRL3);
        Node node4 = NodeFactory.findOrCreate((URL)uRL4);
        UpdateMessage.fireChildAdded((Subject)node3, (Element)node4);
        UpdateMessage.fireChildAdded((Subject)node2, (Element)node3);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditorUtil.openDefaultEditorInFrame((Node)node3);
            }
        });
        if (node3 instanceof PlSqlNode && (view = context.getView()) instanceof NavigatorWindow) {
            TreeExplorer treeExplorer = ((NavigatorWindow)view).getTreeExplorer();
            TNode tNode = ExplorerContext.getSingleTNode((Context)context);
            Element element = tNode.getData();
            if (element instanceof ObjectFolder) {
                treeExplorer.addChild((Element)node3, tNode, treeExplorer.getTreeModel());
            } else {
                Enumeration enumeration = tNode.getChildTNodes();
                while (enumeration.hasMoreElements()) {
                    String string8;
                    TNode tNode2 = (TNode)enumeration.nextElement();
                    Element element2 = tNode2.getData();
                    if (!(element2 instanceof ObjectFolder) || !(string8 = ((ObjectFolder)element2).getObjectType()).equals("PACKAGE") || !tNode2.isSet(TNodeConstants.IS_OPENED)) continue;
                    treeExplorer.addChild((Element)node3, tNode2, treeExplorer.getTreeModel());
                }
            }
        }
    }

    private WelcomeWizardPage createWelcomePage(CodeGenState codeGenState, boolean bl) throws Exception {
        String string = ResourceUtilities.getUILabel((String)"WELCOME_CODE_GEN_INTRO");
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append("\n");
        stringBuffer.append(ResourceUtilities.getUILabel((String)"WELCOME_CODE_GEN_LINE1"));
        stringBuffer.append(" ");
        stringBuffer.append(ResourceUtilities.getUILabel((String)"WELCOME_CODE_GEN_LINE2"));
        stringBuffer.append("\n\n");
        if (bl) {
            stringBuffer.append(ResourceUtilities.getUILabel((String)"WELCOME_CODE_GEN_CLOSER_OFFLINE"));
        } else {
            stringBuffer.append(ResourceUtilities.getUILabel((String)"WELCOME_CODE_GEN_CLOSER_ONLINE"));
        }
        stringBuffer.append("\n\n");
        stringBuffer.append(ResourceUtilities.getUILabel((String)"CLICK_NEXT"));
        stringBuffer.append("\n");
        codeGenState.setImage(ImageUtils.getImageResource(Class.forName("oracle.dmt.dm4j.wizard.transforms.CodeGenWizard"), (String)"transform_discretize.gif"));
        WizardWelcomePage wizardWelcomePage = new WizardWelcomePage(codeGenState.getImage(), string, stringBuffer.toString());
        HelpSystem.getHelpSystem().registerTopic((JComponent)wizardWelcomePage.getContent(), "dm4j_xform_codegen_welcome_html");
        return wizardWelcomePage;
    }

    static {
        SAMPLE_ONE_MENU_COMMAND_ID = Ide.createCmdID((String)"MyMenu.SAMPLE_ONE_MENU_COMMAND");
    }
}

