/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.migration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.naming.Referenceable;
import oracle.jdeveloper.db.migration.CMConnectionsReader;
import oracle.jdevimpl.db.migration.AbstractConnMigrator;

public class CMConnMigrator
extends AbstractConnMigrator {
    private static final String CM_CONNECTIONS_FILE = "IDEConnections.xml";
    private static final Map<String, String> s_databaseConnectionType = new HashMap<String, String>();

    static {
        s_databaseConnectionType.put("JDBC", "Oracle (JDBC)");
        s_databaseConnectionType.put("JDBC_ODBC", "JDBC_ODBC_NAME");
        s_databaseConnectionType.put("BI_JDBC", "BI (JDBC)");
        s_databaseConnectionType.put("FTP", "FTP");
        s_databaseConnectionType.put("JNDI", "JNDI");
        s_databaseConnectionType.put("ORACLE_LITE", "Oracle Lite");
        s_databaseConnectionType.put("OTHER_JDBC", "Third Party JDBC Driver");
    }

    protected String getExtensionID() {
        return "oracle.jdeveloper.db.connection";
    }

    private File getOldConnectionsFile(File sourceDir) {
        return this.findExtensionFile(sourceDir, new String[]{"oracle.onlinedb", "oracle.j2ee"}, CM_CONNECTIONS_FILE);
    }

    public boolean canMigrate(int category, File sourceDir) {
        return this.getOldConnectionsFile(sourceDir) != null;
    }

    public String[] migrate(File sourceDir, File destDir) {
        String[] result = new String[]{};
        File src = this.getOldConnectionsFile(sourceDir);
        if (src == null) {
            this.getLogger().fine("No database connections found to migrate");
            return result;
        }
        CMConnectionsReader reader = new CMConnectionsReader(src.getAbsolutePath(), true);
        try {
            Map<String, Referenceable> map = reader.getMigratedConnections();
            for (Map.Entry<String, Referenceable> entry : map.entrySet()) {
                this.addConnection(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Error migrating connections", ex);
        }
        return result;
    }
}

