/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.migration;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;
import oracle.ide.migration.Migrator;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractDBMigrator
implements Migrator {
    protected static final String OLD_ONLINEDB_EXT = "oracle.onlinedb";
    protected static final String J2EE_EXT = "oracle.j2ee";
    private boolean m_selected;

    protected final Logger getLogger() {
        return DBLog.getAndInitialiseLogger((String)"oracle.jdeveloper.db.migration");
    }

    public String getDescription(int category) {
        return null;
    }

    public int[] getMigrationCategories() {
        return new int[69];
    }

    public boolean isSelected(int category) {
        return this.m_selected;
    }

    public void setSelected(int category, boolean selected) {
        this.m_selected = selected;
    }

    protected abstract String getExtensionID();

    protected File findExtensionFile(File sourceDir, String fileName) {
        return this.findExtensionFile(sourceDir, null, fileName);
    }

    protected File findExtensionFile(File sourceDir, String[] oldExtIDs, String fileName) {
        File connFile;
        File connFile2 = new File(sourceDir, fileName);
        if (connFile2.exists() && connFile2.canRead()) {
            return connFile2;
        }
        if (sourceDir.getName().startsWith(this.getExtensionID())) {
            sourceDir = sourceDir.getParentFile();
        }
        if ((connFile = this.searchForFile(sourceDir, this.getExtensionID(), fileName)) != null) {
            return connFile;
        }
        if (ModelUtil.hasNonNullElement((Object[])oldExtIDs)) {
            return this.findOldExtensionFile(sourceDir, oldExtIDs, fileName);
        }
        return null;
    }

    protected File findOldExtensionFile(File sourceDir, String[] oldExtIDs, String fileName) {
        if (sourceDir.getName().startsWith(this.getExtensionID())) {
            sourceDir = sourceDir.getParentFile();
        }
        if (oldExtIDs != null) {
            int i = 0;
            while (i < oldExtIDs.length) {
                File connFile = this.searchForFile(sourceDir, oldExtIDs[i], fileName);
                if (connFile != null) {
                    return connFile;
                }
                ++i;
            }
        }
        return null;
    }

    protected File searchForFile(File sysDir, String extID, String fileName) {
        File[] kids = sysDir.listFiles(new 1(this, extID));
        Arrays.sort(kids, new 2());
        int i = 0;
        while (i < kids.length) {
            File connFile;
            if (kids[i].isDirectory() && (connFile = new File(kids[i], fileName)).exists() && connFile.canRead()) {
                return connFile;
            }
            ++i;
        }
        return null;
    }

    final class 1
    implements FilenameFilter {
        private final /* synthetic */ String v$extID;
        final /* synthetic */ AbstractDBMigrator this$0;

        public boolean accept(File dir, String name) {
            return name.startsWith(this.v$extID);
        }

        public 1(AbstractDBMigrator abstractDBMigrator, String string) {
            this.v$extID = string;
            this.this$0 = abstractDBMigrator;
        }
    }

    final class 2
    implements Comparator {
        public int compare(File f1, File f2) {
            return f2.getName().compareTo(f1.getName());
        }
    }
}

