/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.migration;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.jdeveloper.db.adapter.DatabaseContextManager;
import oracle.jdevimpl.db.migration.AbstractDBMigrator;

public abstract class AbstractConnMigrator
extends AbstractDBMigrator
implements IdeListener {
    private Map<String, Referenceable> m_migConns;

    protected void addConnection(String name, Referenceable ref) {
        if (this.m_migConns == null) {
            this.m_migConns = new HashMap<String, Referenceable>();
            Ide.addIdeListener((IdeListener)this);
        }
        this.getLogger().fine("Cached migrated connection " + name);
        this.m_migConns.put(name, ref);
    }

    public final void addinsLoaded(IdeEvent e) {
        try {
            try {
                if (this.m_migConns == null || this.m_migConns.size() == 0) {
                    this.getLogger().fine("Nothing to do!");
                } else {
                    Context context = DatabaseContextManager.getDatabaseContext();
                    if (context != null) {
                        StringBuilder done = new StringBuilder();
                        for (Map.Entry<String, Referenceable> entry : this.m_migConns.entrySet()) {
                            String name = entry.getKey();
                            try {
                                context.bind(name, (Object)entry.getValue());
                                done.append(name);
                            }
                            catch (NamingException ne) {
                                this.getLogger().log(Level.WARNING, "Couldn't migrate connection {0}: {1}", new Object[]{name, ne.getMessage()});
                            }
                        }
                        if (done.length() > 0) {
                            this.getLogger().info("Migrated connections: " + done.toString());
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.getLogger().log(Level.WARNING, "Error migrating connections", ex);
            }
        }
        finally {
            Ide.removeIdeListener((IdeListener)this);
        }
    }

    public final void mainWindowOpened(IdeEvent e) {
    }

    public final void mainWindowClosing(IdeEvent e) {
    }
}

