/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.xml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import oracle.ide.Version;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Encodings;
import oracle.ide.xml.SAXParserDoneException;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLPrinter;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.PrintDriver;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLUtil {
    public static StartElementPacket getXMLRootElement(URL url) throws FileNotFoundException {
        try {
            StartElementPacket startElementPacket = XMLUtil.getXMLRootElement(URLFileSystem.openInputStream((URL)url));
            return startElementPacket;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            StartElementPacket startElementPacket = null;
            return startElementPacket;
        }
    }

    public static StartElementPacket getXMLRootElement(InputStream in) {
        return XMLUtil.getXMLRootElementImpl(in, null);
    }

    public static StartElementPacket getXMLRootElement(Reader reader) {
        return XMLUtil.getXMLRootElementImpl(null, reader);
    }

    public static XSLStylesheet loadXSLT(URL xslt) throws IOException, SAXException, XSLException {
        DOMParser xslDom = new DOMParser();
        xslDom.setPreserveWhitespace(false);
        xslDom.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
        xslDom.parse(xslt);
        XMLDocument xslDoc = xslDom.getDocument();
        Element xslRootElem = xslDoc.getDocumentElement();
        NodeList xslOutputNodes = xslRootElem.getElementsByTagNameNS("http://www.w3.org/1999/XSL/Transform", "output");
        int n = xslOutputNodes.getLength();
        int i = 0;
        while (i < n) {
            Node node = xslOutputNodes.item(i);
            if (node.getNodeType() == 1) {
                Element elem = (Element)node;
                elem.setAttribute("encoding", Encodings.getDefaultIanaEncoding());
            }
            ++i;
        }
        return new XSLProcessor().newXSLStylesheet(xslDoc);
    }

    public static void transformXML(URL xml, URL xslt) throws IOException, SAXException, XSLException {
        XSLStylesheet style = XMLUtil.loadXSLT(xslt);
        DOMParser domParser = new DOMParser();
        domParser.setPreserveWhitespace(false);
        domParser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
        domParser.parse(xml);
        XSLProcessor xslp = new XSLProcessor();
        OutputStream out = null;
        try {
            out = URLFileSystem.openOutputStream((URL)xml);
            xslp.processXSL(style, domParser.getDocument(), out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static void writeXML(XMLDocument xmlDocument, URL url) throws IOException {
        OutputStream out = URLFileSystem.openOutputStream((URL)url);
        XMLUtil.writeXML(xmlDocument, out);
    }

    public static void writeXML(XMLDocument xmlDocument, OutputStream out) throws IOException {
        if (xmlDocument == null || out == null) {
            return;
        }
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(out);
            xmlDocument.print((OutputStream)bos);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void writeXML(XMLDocument xmlDocument, PrintWriter printWriter) throws IOException {
        XMLUtil.writeXML(xmlDocument, printWriter, -1);
    }

    public static void writeXML(XMLDocument xmlDocument, PrintWriter printWriter, int indentIncr) throws IOException {
        XMLUtil.writeXML(xmlDocument, printWriter, indentIncr, false, 8);
    }

    public static void writeXML(XMLDocument xmlDocument, PrintWriter printWriter, int indentIncr, boolean useTabs, int tabSize) throws IOException {
        if (xmlDocument == null || printWriter == null) {
            return;
        }
        try {
            if (indentIncr >= 0) {
                xmlDocument.print((PrintDriver)new XMLPrinter(printWriter, indentIncr, useTabs, tabSize));
            } else {
                xmlDocument.print(printWriter);
            }
        }
        finally {
            printWriter.close();
        }
    }

    public static String toNamespaceURI(String documentID) {
        StringBuffer buf = new StringBuffer(Version.BASE_NAMESPACE_URI);
        buf.append(documentID);
        return buf.toString();
    }

    public static String toString(XMLDocument xmlDocument) {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            xmlDocument.print(printWriter);
            stringWriter.close();
            String string = stringWriter.toString();
            return string;
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
    }

    public static String getElementValue(URL url, String element) {
        try {
            String string = XMLUtil.getElementValue(new InputSource(url.openStream()), element);
            return string;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public static String getElementValue(File file, String element) {
        try {
            String string = XMLUtil.getElementValue(file.toURL(), element);
            return string;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private static StartElementPacket getXMLRootElementImpl(InputStream in, Reader reader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getElementValue(InputSource inSrc, String element) {
        ElementValueHandler handler = new ElementValueHandler(null);
        handler.setTargetElement(element);
        try {
            SAXParser parser = new SAXParser();
            parser.setContentHandler((ContentHandler)handler);
            parser.parse(inSrc);
        }
        catch (SAXParserDoneException e) {
            String string = handler.getValue();
            return string;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    private XMLUtil() {
    }

    private static class ElementValueHandler
    extends DefaultHandler {
        private String _targetElement;
        private String _currentElement;
        private String _value;

        public void startElement(String nsURI, String localName, String qName, Attributes attributes) {
            this._currentElement = localName;
        }

        public void characters(char[] text, int s, int l) throws SAXException {
            String value = new String(text, s, l);
            if (this._currentElement.equals(this._targetElement)) {
                this._value = value;
                throw new SAXParserDoneException();
            }
        }

        public String getValue() {
            return this._value;
        }

        public void setTargetElement(String target) {
            this._targetElement = target;
        }

        private ElementValueHandler() {
        }

        ElementValueHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

