/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.CommitNotifier;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.MetaTraversable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMStateInfo;
import oracle.ide.wizard.FSMTransitionException;
import oracle.ide.wizard.FSMWizardListener;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WizardArb;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;

public final class FSMWizard
extends Wizard
implements CommitNotifier {
    private final FSM _fsm;
    private final Namespace _data;
    private final WizardCallbacks _wc;
    private WizardDialog _dialog;
    private FSMStateInfo _curFsmStateInfo;
    private EventListenerList _commitListeners;
    private ArrayList<FSMWizardListener> _wizardListeners;
    private boolean _skipCurStep;
    private String _wizardTitle;
    private int _direction;
    private boolean _dontSelect;
    private Map _pagePool;
    private FSMStateInfo _gotoStateInfo;

    private void $init$() {
        this._dontSelect = true;
        this._pagePool = new HashMap();
    }

    public FSMWizard(Step[] steps, Namespace data) {
        this(FSMBuilder.newFSM(steps), data);
    }

    public FSMWizard(FSM fsm, Namespace data) {
        this.$init$();
        if (fsm == null) {
            throw new IllegalArgumentException(WizardArb.getString(34));
        }
        if (data == null) {
            throw new IllegalArgumentException("FSMWizard data cannot be null.");
        }
        fsm.reset();
        this._fsm = fsm;
        this._data = data;
        this._wc = new WC(null);
        this._populatePages();
        fsm.reset();
        this.selectPage(this.getPageAt(0));
        this.setRoadmapVisible(true);
    }

    public void setWizardTitle(String wizardTitle) {
        this._wizardTitle = wizardTitle;
        if (this._dialog != null) {
            this._dialog.setWizardTitle(wizardTitle);
        }
    }

    public void setShowStepNumber(boolean showStepNumber) {
    }

    public boolean getShowStepNumber() {
        return true;
    }

    public void setWelcomePageAdded(boolean pageAdded) {
    }

    public void setFinishPageAdded(boolean pageAdded) {
    }

    public void addCommitListener(CommitListener commitListener) {
        if (this._commitListeners == null) {
            this._commitListeners = new EventListenerList();
        }
        this._commitListeners.add(CommitListener.class, commitListener);
    }

    public void removeCommitListener(CommitListener commitListener) {
        if (this._commitListeners != null) {
            this._commitListeners.remove(CommitListener.class, commitListener);
        }
    }

    public void addFSMWizardListener(FSMWizardListener listener) {
        if (listener != null) {
            if (this._wizardListeners == null) {
                this._wizardListeners = new ArrayList();
            }
            this._wizardListeners.add(listener);
        }
    }

    public void removeFSMWizardListener(FSMWizardListener listener) {
        if (listener != null && this._wizardListeners != null) {
            this._wizardListeners.remove(listener);
        }
    }

    public void updateImage(Image newImage) {
    }

    public WizardDialog getDialog(Frame parent) {
        return this.getDialogImpl(parent, null);
    }

    public WizardDialog getDialog(Dialog parent) {
        return this.getDialogImpl(null, parent);
    }

    public void setDialog(WizardDialog dialog) {
        this._dialog = dialog;
    }

    public void reset() {
        super.reset();
        this._fsm.reset();
        this._curFsmStateInfo = null;
    }

    protected void doPrevious() {
        WizardPage previous = this.getPreviousPage(this.getSelectedPage());
        if (previous != null) {
            this.selectPage(previous, true);
        }
    }

    protected void doNext() {
        WizardPage next = this.getNextPage(this.getSelectedPage());
        if (next != null) {
            this.selectPage(next, true);
        }
    }

    protected void doFinish() {
        this._direction = 1;
        if (this._validateFSMState(true)) {
            super.doFinish();
        }
    }

    protected void doCancel() {
        if (this._commitListeners != null) {
            ApplyEvent commitEvent = null;
            CommitListener[] listeners = (CommitListener[])this._commitListeners.getListeners(CommitListener.class);
            int i = listeners.length - 1;
            while (i >= 0) {
                if (commitEvent == null) {
                    TraversableContext tc = new TraversableContext(this._data, 2);
                    tc.setWizardCallbacks(this._wc);
                    commitEvent = new ApplyEvent(tc);
                }
                try {
                    listeners[i].cancel(commitEvent);
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)re);
                }
                --i;
            }
        }
        super.doCancel();
    }

    protected void selectPage(WizardPage page, boolean doValidate) {
        if (this._dontSelect) {
            return;
        }
        if (page == null) {
            super.selectPage(page, doValidate);
            return;
        }
        WizardPage selectedPage = this.getSelectedPage();
        if (selectedPage == null || page == this.getNextPage(selectedPage)) {
            this._direction = 1;
        } else if (page == this.getPreviousPage(selectedPage)) {
            this._direction = 2;
        } else {
            return;
        }
        this._gotoStateInfo = null;
        if (!this._validateFSMState(false)) {
            return;
        }
        if (selectedPage != null) {
            page = this._direction == 1 ? this.getNextPage(selectedPage) : this.getPreviousPage(selectedPage);
        }
        if (((FSMWizardPage)page).getStateInfo() != this._gotoStateInfo) {
            return;
        }
        super.selectPage(page, doValidate);
        this._checkSkipThisPage(this._direction);
    }

    protected void setSelectedPage(WizardPage page) {
        super.setSelectedPage(page);
        if (page != null) {
            TraversableContext tc = new TraversableContext(this._data, this._direction);
            tc.setWizardCallbacks(this._wc);
            this.gotoPanel(page, this._gotoStateInfo, tc);
        }
    }

    private void _populatePages() {
        try {
            FSMStateInfo stateInfo = null;
            Object transition = null;
            while ((stateInfo = this._fsm.nextState(transition)) != null) {
                this._addPage(stateInfo, null);
                if (!stateInfo.isFinalState()) {
                    transition = stateInfo.getStep().getExpectedTransition();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._dontSelect = false;
    }

    private WizardPage _addPage(FSMStateInfo stateInfo, WizardPage beforePage) {
        FSMWizardPage page;
        String label;
        Step step = stateInfo.getStep();
        String title = step.getPageTitle();
        Traversable tr = stateInfo.getTraversable(this);
        if (title == null && tr instanceof DefaultTraversablePanel) {
            title = ((DefaultTraversablePanel)tr).getDefaultTitle();
        }
        if (title == null) {
            title = stateInfo.getStateID().toString();
        }
        if ((label = step.getStepLabel()) == null || "".equals(label)) {
            label = title;
        }
        if ((page = (FSMWizardPage)((Object)this._pagePool.get(stateInfo))) == null) {
            page = new FSMWizardPage(stateInfo, tr.getComponent(), label, title);
            this._pagePool.put(stateInfo, page);
        } else {
            page.setLabel(label);
            page.setPageTitle(title);
        }
        try {
            Map transitionMap = FSM.getTransitionMap(this._fsm.getStateNode(stateInfo.getStateID()));
            page.setBranching(transitionMap.size() > 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (page.getParent() == this) {
            if (beforePage != null && beforePage.getParent() == this && beforePage.getIndex() - page.getIndex() == 1) {
                return page;
            }
            this.removePage(page);
        }
        return this.addPage(page, beforePage);
    }

    private boolean _validateFSMState(boolean isFinal) {
        boolean valid;
        FSMWizardPage fsmPage = (FSMWizardPage)this.getSelectedPage();
        TraversableContext tc = this.exitCurrentPanel(this._direction);
        boolean bl = valid = tc != null;
        if (valid) {
            valid = isFinal ? this.finishImpl(tc) : this._canTraverseFSM();
        }
        if (fsmPage != null) {
            fsmPage.setValid(valid);
        }
        return valid;
    }

    private TraversableContext exitCurrentPanel(int direction) {
        TraversableContext tc = new TraversableContext(this._data, direction);
        tc.setWizardCallbacks(this._wc);
        if (this._curFsmStateInfo != null) {
            try {
                Traversable oldTraversable = this._curFsmStateInfo.getTraversable(this);
                oldTraversable.onExit(tc);
                if (this._wizardListeners != null) {
                    for (FSMWizardListener listener : this._wizardListeners) {
                        listener.wizardPanelExited(oldTraversable, tc);
                    }
                }
            }
            catch (TraversalException e) {
                e.showMessageDialog((Component)((Object)this));
                TraversableContext traversableContext = null;
                return traversableContext;
            }
        }
        return tc;
    }

    private boolean _canTraverseFSM() {
        try {
            if (this._direction == 1) {
                Object transition;
                if (this._curFsmStateInfo != null) {
                    Traversable traversable = this._curFsmStateInfo.getTraversable(this);
                    transition = traversable.getExitTransition();
                    this.updateExpectedTransition(transition);
                } else {
                    transition = null;
                }
                this._gotoStateInfo = this._fsm.nextState(transition);
            } else {
                this._gotoStateInfo = this._fsm.previousState();
            }
        }
        catch (FSMTransitionException e) {
            this.handleFSMTransitionException(e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private void gotoPanel(WizardPage page, FSMStateInfo newStateInfo, TraversableContext tc) {
        this.enableButtons(null, null, true);
        Traversable newTraversable = newStateInfo.getTraversable(this);
        this._skipCurStep = false;
        this._curFsmStateInfo = newStateInfo;
        this.updatePageTitle(page, newStateInfo);
        try {
            newTraversable.onEntry(tc);
            if (this._wizardListeners != null) {
                for (FSMWizardListener listener : this._wizardListeners) {
                    listener.wizardPanelEntered(newTraversable, tc);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Component newComp = newTraversable.getComponent();
        if (page.getContent() != newComp) {
            page.setContent(newComp);
        }
        this.updateHelpID(page, newStateInfo.getStep(), newTraversable);
    }

    private void _checkSkipThisPage(int direction) {
        if (this._skipCurStep) {
            this._skipCurStep = false;
            WizardPage selectedPage = this.getSelectedPage();
            switch (direction) {
                case 1: {
                    if (this._fsm.isHalted()) break;
                    if (this.getNextPage(selectedPage) == null) {
                        this.doPrevious();
                    } else {
                        this.doNext();
                    }
                    return;
                }
                case 2: {
                    if (this._fsm.isStarting()) break;
                    if (this.getPreviousPage(selectedPage) == null) {
                        this.doNext();
                    } else {
                        this.doPrevious();
                    }
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private void enableButtons(Boolean back, Boolean next, Boolean finish) {
        WizardPage page = this.getSelectedPage();
        if (page == null) {
            return;
        }
        boolean enableback = back == null ? this._fsm.getStepNumber() > 1 : back;
        page.setCanGoBack(enableback);
        boolean enablenext = next == null ? this._fsm.inFinalState() ^ true : next;
        boolean enablefinish = finish == null ? this._fsm.inFinalState() : finish.booleanValue();
        page.setCanAdvance(enablenext || enablefinish);
        this.setMustFinish(enablefinish ^ true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean finishImpl(TraversableContext tc) {
        try {
            int j;
            TraversalException ex2;
            if (this._commitListeners == null) return true;
            ApplyEvent commitEvent = null;
            CommitListener[] listeners = (CommitListener[])this._commitListeners.getListeners(CommitListener.class);
            int i = listeners.length - 1;
            while (true) {
                if (i < 0) {
                    int i2 = listeners.length - 1;
                    try {
                        while (i2 >= 0) {
                            try {
                                listeners[i2].commit(commitEvent);
                            }
                            catch (RuntimeException re) {
                                ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)re);
                            }
                            --i2;
                        }
                        return true;
                    }
                    catch (TraversalException ex2) {
                        j = i2 + 1;
                        break;
                    }
                }
                if (commitEvent == null) {
                    commitEvent = new ApplyEvent(tc);
                }
                try {
                    listeners[i].checkCommit(commitEvent);
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)re);
                }
                --i;
            }
            while (true) {
                if (j >= listeners.length) {
                    throw ex2;
                }
                try {
                    listeners[j].rollback(commitEvent);
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)re);
                }
                ++j;
            }
        }
        catch (TraversalException ex) {
            ex.showMessageDialog((Component)((Object)this));
            return false;
        }
    }

    private void updateHelpID(WizardPage page, Step step, Traversable traversable) {
        JComponent helpTarget = (JComponent)page.getContent();
        HelpUtils.setHelpID((JComponent)helpTarget, null);
        String helpID = MetaTraversable.findHelpID(step, traversable);
        HelpUtils.setHelpID((JComponent)helpTarget, (String)helpID);
    }

    private void updateAccessibleDescription(String desc) {
        WizardPage page = this.getSelectedPage();
        if (page != null) {
            page.setAccessibleDescription(desc);
        }
    }

    private void updatePageTitle(WizardPage page, FSMStateInfo stateInfo) {
        Step step = stateInfo.getStep();
        String title = step.getPageTitle();
        if (!ModelUtil.hasLength((String)title)) {
            Traversable newTraversable = this._curFsmStateInfo.getTraversable(this);
            if (newTraversable instanceof DefaultTraversablePanel) {
                title = ((DefaultTraversablePanel)newTraversable).getDefaultTitle();
            }
            if (!ModelUtil.hasLength((String)title)) {
                // empty if block
            }
        }
        page.setPageTitle(title);
        String label = step.getStepLabel();
        if (label == null || "".equals(label)) {
            page.setLabel(title);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateExpectedTransition(Object transition) {
        block26: {
            if (transition == this._curFsmStateInfo.getStep().getExpectedTransition()) {
                return;
            }
            this._curFsmStateInfo.getStep().setExpectedTransition(transition);
            currPage = this.getSelectedPage();
            try {
                transitionMap = FSM.getTransitionMap(this._fsm.getStateNode(this._curFsmStateInfo.getStateID()));
                currPage.setBranching(transitionMap.size() > 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            fwStepCount = 0;
            newStateInfo = null;
            this.freezeRepaints();
            try {
                while (true) {
                    block27: {
                        newStateInfo = this._fsm.nextState(transition);
                        ++fwStepCount;
                        nextPage = this.getNextPage(currPage);
                        removeNext = false;
                        if (nextPage != null) {
                            if (newStateInfo != null && ((FSMWizardPage)nextPage).getStateInfo() == newStateInfo) {
                            }
                            removeNext = true;
                        }
                        if (newStateInfo != null) {
                            currPage = this._addPage(newStateInfo, nextPage);
                        }
                        if (removeNext) {
                            this.removePage(nextPage);
                        }
                        if (newStateInfo != null && !newStateInfo.isFinalState()) break block27;
                        if (currPage == null) break block26;
                        if (true) ** GOTO lbl59
                    }
                    transition = newStateInfo.getStep().getExpectedTransition();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                try {
                    stateInfo = null;
                    while (true) {
                        if (fwStepCount-- <= 0) {
                            return;
                        }
                        newStateInfo = this._fsm.previousState();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            finally {
                this.unfreezeRepaints();
                if (newStateInfo != this._curFsmStateInfo) {
                    throw new IllegalStateException("Invalid State");
                }
            }
        }
        do {
            this.removePage(nextPage);
lbl59:
            // 2 sources

        } while ((nextPage = this.getNextPage(currPage)) != null);
    }

    private void updateInitialFocus(Component comp) {
        WizardPage page = this.getSelectedPage();
        if (page != null) {
            page.setInitialFocus(comp);
        }
    }

    private WizardDialog getDialogImpl(Frame parentFrame, Dialog parentDialog) {
        if (this._dialog == null) {
            this._dialog = parentDialog != null ? new WizardDialog((BaseWizard)this, parentDialog) : (parentFrame != null ? new WizardDialog((BaseWizard)this, parentFrame) : new WizardDialog((BaseWizard)this));
        }
        this._dialog.setWizardTitle(this._wizardTitle);
        return this._dialog;
    }

    private void handleFSMTransitionException(FSMTransitionException e) {
        TraversalException ex = new TraversalException("Internal error in FSM: " + e.getLocalizedMessage());
        FSMWizard parent = this._dialog != null ? (Component)this._dialog : this;
        ExceptionDialog.showExceptionDialog((Component)((Object)parent), (Throwable)ex);
        ex.printStackTrace();
    }

    static void mav$updateInitialFocus(FSMWizard fSMWizard, Component component) {
        fSMWizard.updateInitialFocus(component);
    }

    static void mav$updateExpectedTransition(FSMWizard fSMWizard, Object object) {
        fSMWizard.updateExpectedTransition(object);
    }

    static void mav$updateAccessibleDescription(FSMWizard fSMWizard, String string) {
        fSMWizard.updateAccessibleDescription(string);
    }

    static void wa$_skipCurStep(FSMWizard fSMWizard, boolean bl) {
        fSMWizard._skipCurStep = bl;
    }

    static void mav$enableButtons(FSMWizard fSMWizard, Boolean bl, Boolean bl2, Boolean bl3) {
        fSMWizard.enableButtons(bl, bl2, bl3);
    }

    private class FSMWizardPage
    extends WizardPage {
        private FSMStateInfo _stateInfo;

        public FSMWizardPage(FSMStateInfo stateInfo, Component content, String label, String pageTitle) {
            super(content, label, pageTitle);
            this._stateInfo = stateInfo;
        }

        public FSMStateInfo getStateInfo() {
            return this._stateInfo;
        }
    }

    private final class WC
    extends WizardCallbacks {
        public void addCommitListener(CommitListener commitListener) {
            FSMWizard.this.addCommitListener(commitListener);
        }

        public void removeCommitListener(CommitListener commitListener) {
            FSMWizard.this.removeCommitListener(commitListener);
        }

        public void wizardEnableButtons(Boolean back, Boolean next, Boolean finish) {
            FSMWizard.mav$enableButtons(FSMWizard.this, back, next, finish);
        }

        public void wizardSkipCurrentStep() {
            FSMWizard.wa$_skipCurStep(FSMWizard.this, true);
        }

        public void wizardUpdateAccessibleDescription(String desc) {
            FSMWizard.mav$updateAccessibleDescription(FSMWizard.this, desc);
        }

        public void wizardUpdateImage(Image image) {
            FSMWizard.this.updateImage(image);
        }

        public void wizardUpdateTitle(String title, Boolean showStepNumber) {
            FSMWizardPage page = (FSMWizardPage)FSMWizard.this.getSelectedPage();
            if (page != null) {
                page.setPageTitle(title);
                page.setLabel(title);
            }
        }

        public void wizardUpdateExpectedTransition(Object transition) {
            FSMWizard.mav$updateExpectedTransition(FSMWizard.this, transition);
        }

        public void wizardSetInitialFocus(Component comp) {
            FSMWizard.mav$updateInitialFocus(FSMWizard.this, comp);
        }

        public void nextPage() {
            FSMWizard.this.doNext();
        }

        public void previousPage() {
            FSMWizard.this.doPrevious();
        }

        private WC() {
        }

        WC(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

