/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.AbstractUIContainer;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.ExceptionDialog;

public class TabbedPanel
extends AbstractUIContainer {
    public static final String DEFAULT_TAB_INDEX = "TabbedPanel.DEFAULT_TAB_INDEX";
    private final JTabbedPane _tabbedPane;
    private final ChangeListener _listener;
    private Traversable[] _traversables;
    private transient Image _curImage;
    private transient int _curIndex;

    private void $init$() {
        this._listener = new 1();
        this._traversables = new Traversable[0];
        this._curImage = null;
        this._curIndex = -1;
    }

    public TabbedPanel(Navigable[] rootNavigables) {
        this(rootNavigables, 1);
    }

    public TabbedPanel(Navigable[] rootNavigables, int tabPlacement) {
        this.$init$();
        this.setRootNavigables(rootNavigables);
        this._tabbedPane = new JTabbedPane(tabPlacement);
        this.setLayout(new BorderLayout());
        this.add((Component)this._tabbedPane, "Center");
    }

    public static Navigable createNavigable(String labelText, Navigable[] tabs) {
        return new Navigable(labelText, TabbedPanel.class, new Class[]{Navigable[].class}, new Object[]{tabs}, null);
    }

    public void onEntry(TraversableContext tc) {
        super.onEntry(tc);
        this.maybeRefreshUI(tc);
        Navigable[] rootNavigables = this.getRootNavigables();
        if (rootNavigables != null) {
            int index;
            int n = rootNavigables.length;
            Integer defaultIndexInt = (Integer)tc.getDesignTimeObject(DEFAULT_TAB_INDEX);
            int defaultIndex = 0;
            if (defaultIndexInt != null && (index = defaultIndexInt.intValue()) >= 0 && index < n) {
                defaultIndex = index;
            }
            if (n > 0 && (this._curIndex < 0 || this._curIndex >= n)) {
                this._tabbedPane.setSelectedIndex(defaultIndex);
                this.gotoTab(defaultIndex);
            }
        }
        this.enterCurrentTraversable();
        this._tabbedPane.addChangeListener(this._listener);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this._tabbedPane.removeChangeListener(this._listener);
        super.onExit(tc);
        this.exitCurrentTraversable();
        tc.putDesignTimeObject(DEFAULT_TAB_INDEX, new Integer(this._tabbedPane.getSelectedIndex()));
    }

    public void updateImage(Image image) {
        this._curImage = image;
    }

    protected void refreshUI(TraversableContext tc) {
        this._tabbedPane.removeAll();
        Navigable[] rootNavigables = this.getRootNavigables();
        if (rootNavigables != null) {
            int n = rootNavigables.length;
            if (n >= 0) {
                this._traversables = new Traversable[n];
            }
            int i = 0;
            while (i < n) {
                Navigable nav = rootNavigables[i];
                if (nav != null) {
                    Component content;
                    Traversable traversable;
                    this._traversables[i] = traversable = nav.newTraversable(this);
                    if (this._curImage != null) {
                        ImageWizardPage page = new ImageWizardPage(traversable.getComponent(), this._curImage, null);
                        content = page.getContent();
                    } else {
                        content = traversable.getComponent();
                    }
                    if (content instanceof JComponent) {
                        ((JComponent)content).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    }
                    this._tabbedPane.addTab(nav.getShortLabel(), content);
                    String rawLabel = nav.getRawShortLabel();
                    int mnemIdx = StringUtils.getMnemonicIndex((String)rawLabel);
                    if (mnemIdx != -1) {
                        this._tabbedPane.setDisplayedMnemonicIndexAt(i, mnemIdx);
                        this._tabbedPane.setMnemonicAt(i, StringUtils.getMnemonicKeyCode((String)rawLabel));
                    }
                }
                ++i;
            }
        }
    }

    protected Navigable getCurrentNavigable() {
        if (this._curIndex == -1) {
            return null;
        }
        return this.getRootNavigables()[this._curIndex];
    }

    protected Traversable getCurrentTraversable() {
        if (this._curIndex == -1) {
            return null;
        }
        return this._traversables[this._curIndex];
    }

    private void gotoTab(int index) {
        if (index == this._curIndex) {
            return;
        }
        try {
            this.exitCurrentTraversable();
        }
        catch (TraversalException ex) {
            ex.showMessageDialog(this);
            this._tabbedPane.setSelectedIndex(this._curIndex);
            return;
        }
        this._curIndex = index;
        WaitCursor wc = new WaitCursor(this);
        wc.show();
        this.enterCurrentTraversable();
        wc.hide();
        wc.dispose();
    }

    private void enterCurrentTraversable() {
        if (this._curIndex >= 0 && this._curIndex < this._traversables.length) {
            Traversable traversable = this._traversables[this._curIndex];
            try {
                traversable.onEntry(this.newTraversableContext());
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Component)this, (Throwable)e, (String)"An exception occurred while entering this panel.");
                e.printStackTrace();
            }
        }
    }

    private void exitCurrentTraversable() throws TraversalException {
        if (this._curIndex >= 0 && this._curIndex < this._traversables.length) {
            Traversable oldTrav = this._traversables[this._curIndex];
            try {
                oldTrav.onExit(this.newTraversableContext());
            }
            catch (TraversalException e) {
                throw e;
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Component)this, (Throwable)e, (String)"An exception occurred while exiting this panel.");
                e.printStackTrace();
            }
        }
    }

    static JTabbedPane ra$_tabbedPane(TabbedPanel tabbedPanel) {
        return tabbedPanel._tabbedPane;
    }

    static void mav$gotoTab(TabbedPanel tabbedPanel, int n) {
        tabbedPanel.gotoTab(n);
    }

    final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            TabbedPanel.mav$gotoTab(TabbedPanel.this, TabbedPanel.ra$_tabbedPane(TabbedPanel.this).getSelectedIndex());
        }
    }
}

