/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.event.EventListenerList;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.ApplyNotifier;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TDialog;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.javatools.util.SwingUtils;

public class TDialogLauncher
implements ApplyNotifier {
    private final Component _parent;
    private final String _title;
    private final Traversable _traversable;
    private final TraversableContext _tc;
    private JEWTDialog _jewtDialog;
    private EventListenerList _applyListeners;
    private Dimension _initialSize;
    private boolean _pack;
    private DialogRunnerCallback _dialogCallback;
    private static Dimension _defaultSize = new Dimension(600, 400);
    private DialogHeader _header;

    private void $init$() {
        this._header = null;
    }

    public TDialogLauncher(Component parent, String title, Traversable traversable, Namespace data) {
        this(parent, title, traversable, data, null);
    }

    public TDialogLauncher(Component parent, String title, Traversable traversable, Namespace data, DialogRunnerCallback dialogCallback) {
        this.$init$();
        if (traversable == null) {
            throw new IllegalArgumentException();
        }
        this._dialogCallback = dialogCallback;
        this._parent = parent;
        this._title = title;
        this._traversable = traversable;
        this._tc = data instanceof TraversableContext ? (TraversableContext)data : new TraversableContext(data != null ? data : new Namespace(), 1);
        this._tc.setDialogCallbacks(new DialogCall(null));
        if (this._traversable instanceof ApplyListener) {
            this.addApplyListener((ApplyListener)((Object)this._traversable));
        }
        this._traversable.onEntry(this._tc);
    }

    public void setDialogHeader(DialogHeader header) {
        this._header = header;
    }

    public void addApplyListener(ApplyListener applyListener) {
        if (this._applyListeners == null) {
            this._applyListeners = new EventListenerList();
        }
        this._applyListeners.add(ApplyListener.class, applyListener);
    }

    public void removeApplyListener(ApplyListener applyListener) {
        if (this._applyListeners != null) {
            this._applyListeners.remove(ApplyListener.class, applyListener);
        }
    }

    public Component getParent() {
        return this._parent;
    }

    public String getTitle() {
        return this._title;
    }

    public Dimension getInitialSize() {
        return this._initialSize != null ? this._initialSize : this.getDefaultInitialSize();
    }

    public void setInitialSize(Dimension initialSize) {
        this._initialSize = initialSize;
    }

    public void setInitialSize(int x, int y) {
        this.setInitialSize(new Dimension(x, y));
    }

    public void setPackDialog(boolean pack) {
        this._pack = pack;
    }

    public Dimension getDefaultInitialSize() {
        return TDialogLauncher.getPreferredDefaultInitialSize();
    }

    public static Dimension getPreferredDefaultInitialSize() {
        return new Dimension(_defaultSize);
    }

    public static void setPreferredDefaultInitialSize(Dimension defaultSize) {
        _defaultSize = new Dimension(defaultSize);
    }

    public JEWTDialog initDialog() {
        if (this._jewtDialog == null) {
            this._jewtDialog = this.newDialog();
            if (this._header != null) {
                this._jewtDialog.setDialogHeader((Component)this._header);
            }
            if (this._pack) {
                this._jewtDialog.pack();
            } else {
                this._jewtDialog.setPreferredSize(this.getInitialSize());
            }
        }
        return this._jewtDialog;
    }

    public boolean showDialog() {
        boolean ok;
        JEWTDialog dialog = this.initDialog();
        if (this._dialogCallback != null) {
            this._dialogCallback.dialogAboutToRun((JDialog)dialog);
        }
        if (ok = WizardLauncher.runDialog((JDialog)dialog)) {
            this.fireApply();
        } else {
            this.fireCancel();
        }
        return ok;
    }

    public void dispose() {
        this._tc.setDialogCallbacks(null);
    }

    private JEWTDialog getDialog() {
        return this._jewtDialog;
    }

    protected TraversableContext getTraversableContext() {
        return this._tc;
    }

    protected TDialog newDialog() {
        Window parentWindow = SwingUtils.findAncestorFrameOrDialog((Component)this.getParent());
        if (parentWindow instanceof Dialog) {
            return new TDialog(this, (Dialog)parentWindow);
        }
        return new TDialog(this, (Frame)parentWindow);
    }

    protected void fireApply() {
        if (this._applyListeners == null) {
            return;
        }
        Object[] listeners = this._applyListeners.getListenerList();
        ApplyEvent event = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ApplyListener.class) {
                if (event == null) {
                    event = new ApplyEvent(this.getTraversableContext());
                }
                ((ApplyListener)listeners[i + 1]).apply(event);
            }
            i -= 2;
        }
    }

    protected void fireCancel() {
        if (this._applyListeners == null) {
            return;
        }
        Object[] listeners = this._applyListeners.getListenerList();
        ApplyEvent event = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ApplyListener.class) {
                if (event == null) {
                    event = new ApplyEvent(this.getTraversableContext());
                }
                ((ApplyListener)listeners[i + 1]).cancel(event);
            }
            i -= 2;
        }
    }

    final Traversable getTraversable() {
        return this._traversable;
    }

    private void enableOK(boolean ok) {
        JEWTDialog dialog = this.getDialog();
        if (dialog != null) {
            dialog.setOKButtonEnabled(ok);
        }
    }

    static void mav$enableOK(TDialogLauncher tDialogLauncher, boolean bl) {
        tDialogLauncher.enableOK(bl);
    }

    private final class DialogCall
    extends DialogCallbacks {
        public void enableOKButton(boolean ok) {
            TDialogLauncher.mav$enableOK(TDialogLauncher.this, ok);
        }

        private DialogCall() {
        }

        DialogCall(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

