/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.event.EventListenerList;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.MetaTraversable;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.NavigableUIContainer;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;

abstract class AbstractUIContainer
extends DefaultTraversablePanel
implements NavigableUIContainer,
ApplyListener {
    private EventListenerList _listeners;
    private Navigable[] _rootNavigables;
    private boolean _refreshNeeded;
    private transient TraversableContext _lastKnownTC;

    public void onEntry(TraversableContext tc) {
        this._lastKnownTC = tc;
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this._lastKnownTC = tc;
    }

    public String getHelpID() {
        Traversable trav;
        Navigable nav = this.getCurrentNavigable();
        String helpID = MetaTraversable.findHelpID(nav, trav = this.getCurrentTraversable());
        if (helpID == null) {
            helpID = super.getHelpID();
        }
        return helpID;
    }

    public void addApplyListener(ApplyListener applyListener) {
        this.addListener(ApplyListener.class, applyListener);
    }

    public void removeApplyListener(ApplyListener applyListener) {
        this.removeListener(ApplyListener.class, applyListener);
    }

    public void apply(ApplyEvent e) {
        this.fireApply(e);
    }

    public void cancel(ApplyEvent e) {
        this.fireCancel(e);
    }

    public void setRootNavigables(Navigable[] rootNavigables) {
        this._rootNavigables = rootNavigables;
        this._refreshNeeded = true;
    }

    public boolean displayDetailNodesAsChildren() {
        return true;
    }

    protected void addListener(Class eventClass, EventListener listener) {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        this._listeners.add(eventClass, listener);
    }

    protected void removeListener(Class eventClass, EventListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(eventClass, listener);
        }
    }

    protected Navigable[] getRootNavigables() {
        return this._rootNavigables;
    }

    protected final void maybeRefreshUI(TraversableContext tc) {
        if (this._refreshNeeded) {
            this._refreshNeeded = false;
            this.refreshUI(tc);
        }
    }

    protected abstract void refreshUI(TraversableContext var1);

    protected abstract Navigable getCurrentNavigable();

    protected abstract Traversable getCurrentTraversable();

    protected TraversableContext newTraversableContext() {
        TraversableContext tc;
        Navigable nav = this.getCurrentNavigable();
        Namespace navScope = nav.getDataScope();
        if (navScope != null) {
            tc = new TraversableContext((MetaTraversable)nav, navScope, 0);
            tc.setDesignTimeParent(this._lastKnownTC);
        } else {
            tc = new TraversableContext((MetaTraversable)nav, this._lastKnownTC, 0);
        }
        tc.putDesignTimeObject("navigable-ui-container", this);
        return tc;
    }

    protected Iterator getListenerIterator(Class listenerClass) {
        if (this._listeners == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        Object[] listeners = this._listeners.getListenerList();
        return new 1I(this, listeners, listenerClass);
    }

    protected void fireApply(ApplyEvent event) {
        Iterator iter = this.getListenerIterator(ApplyListener.class);
        while (iter.hasNext()) {
            ((ApplyListener)iter.next()).apply(event);
        }
    }

    protected void fireCancel(ApplyEvent event) {
        Iterator iter = this.getListenerIterator(ApplyListener.class);
        while (iter.hasNext()) {
            ((ApplyListener)iter.next()).cancel(event);
        }
    }

    AbstractUIContainer() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class 1I
    implements Iterator {
        int _i;
        private final /* synthetic */ Object[] v$listeners;
        private final /* synthetic */ Class v$listenerClass;
        final /* synthetic */ AbstractUIContainer this$0;

        1I(AbstractUIContainer abstractUIContainer, Object[] objectArray, Class clazz) {
            this.v$listenerClass = clazz;
            this.v$listeners = objectArray;
            this.this$0 = abstractUIContainer;
            this._i = objectArray != null ? objectArray.length : -1;
            this.gotoNext();
        }

        @Override
        public boolean hasNext() {
            return this._i >= 0;
        }

        public Object next() {
            if (this._i < 0) {
                throw new NoSuchElementException();
            }
            Object listener = this.v$listeners[this._i + 1];
            this.gotoNext();
            return listener;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void gotoNext() {
            this._i -= 2;
            while (this._i >= 0) {
                if (this.v$listeners[this._i] == this.v$listenerClass) break;
                this._i -= 2;
            }
        }
    }
}

