/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.ide.marshal.xml.URL2Dom;
import oracle.ide.marshal.xml.XMLObjectStore;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.StringComparator;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.Structure;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

abstract class StructureIO
extends XMLObjectStore {
    private final String _rootQname;
    private final String _nsURI;
    private final String _propagatedXmlns;
    private final StringComparator _stringComparator;
    private HashSet _xpathsToFlatten;
    private boolean _lastLoadUsedFallback;
    private URL _documentURL;
    private static final boolean USE_SAX = true;
    private static SAXParserFactory _parserFactory = null;

    private void $init$() {
        this._stringComparator = new StringComparator();
        this._lastLoadUsedFallback = false;
    }

    StructureIO(String nsURI, String rootQname) {
        this.$init$();
        this._nsURI = nsURI;
        this._rootQname = rootQname;
        this._propagatedXmlns = rootQname != null && rootQname.indexOf(58) < 0 ? nsURI : null;
    }

    public void addXpathToFlatten(String xpath) {
        if (xpath != null) {
            if (this._xpathsToFlatten == null) {
                this._xpathsToFlatten = new HashSet();
            }
            this._xpathsToFlatten.add(xpath);
        }
    }

    public boolean isLastLoadUsedFallback() {
        return this._lastLoadUsedFallback;
    }

    void setDocumentURL(URL documentURL) {
        this._documentURL = documentURL;
    }

    void loadImpl(URL url, HashStructure rootHash, ListStructure rootList) throws IOException {
        this.setDocumentURL(url);
        try {
            this.loadUsingSAX(url, rootHash, rootList);
            return;
        }
        catch (IOException e) {
            if (URLFileSystem.getLength((URL)url) > 0L) {
                throw e;
            }
            return;
        }
    }

    private void loadUsingDOM(URL url, HashStructure rootHash, ListStructure rootList) throws IOException {
        XMLDocument doc = this.parseWithDOM(url);
        Element rootElement = doc.getDocumentElement();
        Class defaultClass = rootHash != null ? HashStructure.class : ListStructure.class;
        Element migratedElement = rootElement;
        try {
            migratedElement = this.applyTransforms(rootElement, defaultClass, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (rootHash != null) {
            this.elem2HashStructure(migratedElement, rootHash);
        } else {
            this.elem2ListStructure(migratedElement, rootList);
        }
    }

    private void loadUsingSAX(URL url, HashStructure rootHash, ListStructure rootList) throws IOException {
        HashStructure root = rootHash;
        if (rootHash == null) {
            root = rootList;
        }
        BufferedInputStream is = null;
        try {
            try {
                is = new BufferedInputStream(URLFileSystem.openInputStream((URL)url));
                StructureIO.saxParser().parse((InputStream)is, (DefaultHandler)new StructureHandler((Structure)root));
            }
            catch (NotAStructureException nse) {
                this.loadUsingDOM(url, rootHash, rootList);
            }
            catch (SAXException e) {
                try {
                    root.clear();
                    StructureIO.saxParser().parse(new InputSource(new StringReader(this.fixCVSConflicts(url))), (DefaultHandler)new StructureHandler((Structure)root));
                }
                catch (SAXException e2) {
                    IOException ioe = new IOException();
                    ioe.initCause(e2);
                    throw ioe;
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static SAXParserFactory saxParserFactory() {
        if (_parserFactory != null) {
            return _parserFactory;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        _parserFactory = factory;
        return _parserFactory;
    }

    private static SAXParser saxParser() {
        try {
            SAXParser sAXParser = StructureIO.saxParserFactory().newSAXParser();
            return sAXParser;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    void elem2HashStructure(Element elem, HashStructure hash) {
        NodeList children = elem.getChildNodes();
        int n = children.getLength();
        int i = 0;
        while (i < n) {
            Element childElem;
            Attr propNameAttr;
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 1 && (propNameAttr = (childElem = (Element)childNode).getAttributeNode("n")) != null) {
                String propName = propNameAttr.getValue();
                String localName = childElem.getLocalName();
                if (localName == "value") {
                    hash.putString(propName, this.elem2string(childElem));
                } else if (localName == "hash") {
                    HashStructure childStruct = hash.getHashStructure(propName);
                    if (childStruct == null) {
                        childStruct = HashStructure.newInstance();
                        hash.putHashStructure(propName, childStruct);
                    }
                    this.elem2HashStructure(childElem, childStruct);
                } else if (localName == "url") {
                    hash.putURL(propName, this.elem2url(childElem));
                } else if (localName == "list") {
                    ListStructure childList = hash.getListStructure(propName);
                    if (childList != null) {
                        childList.clear();
                    } else {
                        childList = ListStructure.newInstance();
                        hash.putListStructure(propName, childList);
                    }
                    this.elem2ListStructure(childElem, childList);
                }
            }
            ++i;
        }
    }

    private String elem2string(Element elem) {
        Attr valueAttr = elem.getAttributeNode("v");
        return valueAttr != null ? valueAttr.getValue() : null;
    }

    private URL elem2url(Element elem) {
        return URL2Dom.toURL(elem, this._documentURL);
    }

    private void elem2ListStructure(Element elem, ListStructure list) {
        NodeList children = elem.getChildNodes();
        int n = children.getLength();
        int i = 0;
        while (i < n) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 1) {
                Element childElem = (Element)childNode;
                String localName = childElem.getLocalName();
                if (localName == "string") {
                    list.add((Object)childElem.getAttribute("v"));
                } else if (localName == "boolean") {
                    list.add((Object)Boolean.valueOf(childElem.getAttribute("v")));
                } else if (localName == "int") {
                    list.add((Object)Integer.valueOf(childElem.getAttribute("v")));
                } else if (localName == "long") {
                    list.add((Object)Long.valueOf(childElem.getAttribute("v")));
                } else if (localName == "float") {
                    list.add((Object)Float.valueOf(childElem.getAttribute("v")));
                } else if (localName == "double") {
                    list.add((Object)Double.valueOf(childElem.getAttribute("v")));
                } else if (localName == "null") {
                    list.add(null);
                } else if (localName == "hash") {
                    HashStructure childStruct = HashStructure.newInstance();
                    this.elem2HashStructure(childElem, childStruct);
                    list.add((Object)childStruct);
                } else if (localName == "url") {
                    list.add((Object)this.elem2url(childElem));
                } else if (localName == "list") {
                    ListStructure childList = ListStructure.newInstance();
                    this.elem2ListStructure(childElem, childList);
                    list.add((Object)childList);
                }
            }
            ++i;
        }
    }

    private XMLDocument parseWithDOM(URL url) throws IOException {
        DOMParser domParser = new DOMParser();
        domParser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
        try {
            try {
                InputStream inputStream = null;
                BufferedInputStream bis = null;
                try {
                    inputStream = URLFileSystem.openInputStream((URL)url);
                    bis = new BufferedInputStream(inputStream);
                    domParser.parse((InputStream)bis);
                    this._lastLoadUsedFallback = false;
                }
                finally {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (XMLParseException xpe) {
                domParser.parse((Reader)new StringReader(this.fixCVSConflicts(url)));
            }
            XMLDocument xMLDocument = domParser.getDocument();
            return xMLDocument;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    private String fixCVSConflicts(URL url) throws IOException {
        InputStream inputStream = null;
        BufferedReader br = null;
        try {
            inputStream = URLFileSystem.openInputStream((URL)url);
            InputStreamReader isr = new InputStreamReader(inputStream, "UTF-8");
            br = new BufferedReader(isr);
            StringBuilder buf = new StringBuilder();
            String eol = System.getProperty("line.separator");
            int conflictSection = 0;
            block17: while (br.ready()) {
                String line = br.readLine();
                switch (conflictSection) {
                    case 0: {
                        if (!line.startsWith("<<<<<<<")) break;
                        conflictSection = 1;
                        continue block17;
                    }
                    case 1: {
                        if (!line.startsWith("=======")) break;
                        conflictSection = 2;
                        continue block17;
                    }
                    case 2: {
                        if (!line.startsWith(">>>>>>>")) continue block17;
                        conflictSection = 0;
                        continue block17;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                buf.append(line).append(eol);
            }
            this._lastLoadUsedFallback = true;
            String string = buf.toString();
            return string;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    void saveImpl(URL url, HashStructure hash, ListStructure list) throws IOException {
        XMLDocument doc = new XMLDocument();
        doc.setVersion("1.0");
        doc.setEncoding("UTF-8");
        Element rootElem = doc.createElementNS(this._nsURI, this._rootQname);
        doc.appendChild((Node)rootElem);
        this.setDocumentURL(url);
        if (hash != null) {
            this.hashStructure2elem(hash, rootElem);
        } else {
            this.listStructure2elem(list, rootElem);
        }
        if (this._xpathsToFlatten != null) {
            Iterator iter = this._xpathsToFlatten.iterator();
            while (iter.hasNext()) {
                String xpath = iter.next().toString();
                try {
                    NodeList nodeList = doc.selectNodes(xpath);
                    if (nodeList == null) continue;
                    int n = nodeList.getLength();
                    int i = 0;
                    while (i < n) {
                        Node node = nodeList.item(i);
                        if (node.hasChildNodes()) {
                            Node child = node.getFirstChild();
                            while (child != null) {
                                Node curChild = child;
                                child = child.getNextSibling();
                                short nodeType = curChild.getNodeType();
                                if (nodeType != 1) continue;
                                Text emptyText = curChild.getOwnerDocument().createTextNode("");
                                node.insertBefore(emptyText, curChild);
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        XMLUtil.writeXML(doc, url);
    }

    void hashStructure2elem(HashStructure hash, Element elem) {
        Object[] keyArray = hash.persistentKeySet().toArray();
        Arrays.sort(keyArray, this._stringComparator);
        Iterator<Object> iter = Arrays.asList(keyArray).iterator();
        while (iter.hasNext()) {
            String name = iter.next().toString();
            Object valueObj = hash.getObject(name);
            if (valueObj == null) {
                this.createChildElem(elem, "value", name);
                continue;
            }
            Class<?> type = valueObj.getClass();
            if (type == String.class) {
                this.string2elem(valueObj.toString(), this.createChildElem(elem, "value", name));
                continue;
            }
            if (valueObj instanceof HashStructure) {
                this.hashStructure2elem((HashStructure)valueObj, this.createChildElem(elem, "hash", name));
                continue;
            }
            if (type == URL.class) {
                this.url2elem((URL)valueObj, this.createChildElem(elem, "url", name));
                continue;
            }
            if (type != ListStructure.class) continue;
            this.listStructure2elem((ListStructure)valueObj, this.createChildElem(elem, "list", name));
        }
    }

    private Element createChildElem(Element parent, String childElemName, String name) {
        Element childElem = this.createChildElem(parent, childElemName);
        childElem.setAttribute("n", name);
        return childElem;
    }

    private void string2elem(String str, Element elem) {
        elem.setAttribute("v", str);
    }

    private void url2elem(URL url, Element elem) {
        URL2Dom.toElement(url, this._documentURL, elem);
    }

    private void listStructure2elem(ListStructure list, Element elem) {
        for (Object obj : list) {
            if (obj == null) {
                this.createChildElem(elem, "null");
                continue;
            }
            Class<?> type = obj.getClass();
            String valueElemName = StructureIO.getValueElemName(type);
            if (valueElemName != null) {
                Element itemElem = this.createChildElem(elem, valueElemName);
                itemElem.setAttribute("v", obj.toString());
                continue;
            }
            if (obj instanceof HashStructure) {
                this.hashStructure2elem((HashStructure)obj, this.createChildElem(elem, "hash"));
                continue;
            }
            if (type == URL.class) {
                this.url2elem((URL)obj, this.createChildElem(elem, "url"));
                continue;
            }
            if (type != ListStructure.class) continue;
            this.listStructure2elem((ListStructure)obj, this.createChildElem(elem, "list"));
        }
    }

    private static String getValueElemName(Class type) {
        if (type == String.class) {
            return "string";
        }
        if (type == Boolean.class) {
            return "boolean";
        }
        if (type == Integer.class) {
            return "int";
        }
        if (type == Long.class) {
            return "long";
        }
        if (type == Float.class) {
            return "float";
        }
        if (type == Double.class) {
            return "double";
        }
        return null;
    }

    private Element createChildElem(Element parent, String childElemName) {
        Element childElem = parent.getOwnerDocument().createElementNS(this._propagatedXmlns, childElemName);
        parent.appendChild(childElem);
        return childElem;
    }

    static URL ra$_documentURL(StructureIO structureIO) {
        return structureIO._documentURL;
    }

    private class NotAStructureException
    extends RuntimeException {
        private NotAStructureException() {
        }

        NotAStructureException(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class StructureHandler
    extends DefaultHandler {
        private final List<Structure> _currentStructureStack;
        private boolean rootElement;

        private void $init$() {
            this._currentStructureStack = new ArrayList<Structure>();
            this.rootElement = true;
        }

        StructureHandler(Structure rootStructure) {
            this.$init$();
            this.push(rootStructure);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.rootElement) {
                if (attributes.getValue("nselem") != null) {
                    throw new NotAStructureException(null);
                }
                this.rootElement = false;
            }
            if (this.isProcessingHash()) {
                this.startHashElement(localName, attributes);
            } else if (this.isProcessingList()) {
                this.startListElement(localName, attributes);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("hash".equals(localName) || "list".equals(localName)) {
                this.pop();
            }
        }

        private void startListElement(String localName, Attributes attributes) {
            String value = attributes.getValue("v");
            if ("string".equals(localName)) {
                this.peekList().add((Object)value);
            } else if ("boolean".equals(localName)) {
                this.peekList().add((Object)Boolean.valueOf(value));
            } else if ("int".equals(localName)) {
                this.peekList().add((Object)Integer.valueOf(value));
            } else if ("long".equals(localName)) {
                this.peekList().add((Object)Long.valueOf(value));
            } else if ("float".equals(localName)) {
                this.peekList().add((Object)Float.valueOf(value));
            } else if ("double".equals(localName)) {
                this.peekList().add((Object)Double.valueOf(value));
            } else if ("null".equals(localName)) {
                this.peekList().add(null);
            } else if ("url".equals(localName)) {
                this.peekList().add((Object)URL2Dom.toURL(attributes, StructureIO.ra$_documentURL(StructureIO.this)));
            } else if ("hash".equals(localName)) {
                HashStructure child = HashStructure.newInstance();
                this.peekList().add((Object)child);
                this.push((Structure)child);
            } else if ("list".equals(localName)) {
                ListStructure child = ListStructure.newInstance();
                this.peekList().add((Object)child);
                this.push((Structure)child);
            }
        }

        private void startHashElement(String localName, Attributes attributes) {
            String propName = attributes.getValue("n");
            if (propName == null) {
                return;
            }
            if ("value".equals(localName)) {
                this.peekHash().putString(propName, attributes.getValue("v"));
            } else if ("hash".equals(localName)) {
                HashStructure childStruct = this.peekHash().getHashStructure(propName);
                if (childStruct == null) {
                    childStruct = HashStructure.newInstance();
                    this.peekHash().putHashStructure(propName, childStruct);
                }
                this.push((Structure)childStruct);
            } else if ("url".equals(localName)) {
                this.peekHash().putURL(propName, URL2Dom.toURL(attributes, StructureIO.ra$_documentURL(StructureIO.this)));
            } else if ("list".equals(localName)) {
                ListStructure childList = this.peekHash().getListStructure(propName);
                if (childList != null) {
                    childList.clear();
                } else {
                    childList = ListStructure.newInstance();
                    this.peekHash().putListStructure(propName, childList);
                }
                this.push((Structure)childList);
            }
        }

        private HashStructure peekHash() {
            return (HashStructure)this.peek();
        }

        private ListStructure peekList() {
            return (ListStructure)this.peek();
        }

        private boolean isProcessingHash() {
            return this.peek() instanceof HashStructure;
        }

        private boolean isProcessingList() {
            return this.peek() instanceof ListStructure;
        }

        private Structure peek() {
            return this._currentStructureStack.get(this._currentStructureStack.size() - 1);
        }

        private void push(Structure structure) {
            this._currentStructureStack.add(structure);
        }

        private Structure pop() {
            Structure top = this.peek();
            this._currentStructureStack.remove(this._currentStructureStack.size() - 1);
            return top;
        }
    }
}

