/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.tree;

import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.util.TriStateBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMutableTreeNode
extends DefaultMutableTreeNode
implements Comparable {
    protected JTreeCellData _treeCellData;

    public JMutableTreeNode() {
        this((String)null);
    }

    public JMutableTreeNode(String text) {
        this(new JTreeCellData(text));
    }

    public JMutableTreeNode(JTreeCellData treeCellData) {
        this(treeCellData, true);
    }

    public JMutableTreeNode(JTreeCellData treeCellData, boolean allowsChildren) {
        super(treeCellData, allowsChildren);
        this._treeCellData = treeCellData;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JMutableTreeNode)) {
            throw new ClassCastException("In order to sort, all tree nodes must be an instance of JMutableTreeNode.");
        }
        return this.compareTo((JMutableTreeNode)object);
    }

    public void selectDescendants(boolean b) {
        JTreeCellData treeCellData = this.getModel();
        if (treeCellData.getHasRadioButton()) {
            treeCellData.setInternalRadioEnabled(b);
        }
        if (!treeCellData.isEnabled()) {
            return;
        }
        treeCellData.setCheckBoxState(b);
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            TreeNode childObj = children.nextElement();
            if (!(childObj instanceof JMutableTreeNode)) continue;
            ((JMutableTreeNode)childObj).selectDescendants(b);
        }
    }

    public TriStateBoolean descendingUpdateNodes() {
        JTreeCellData actionData = this.getModel();
        if (this.getChildCount() <= 0) {
            if (actionData.getHasRadioButton()) {
                return TriStateBoolean.getState(actionData.isRadioButtonSelected());
            }
            return actionData.getCheckBoxState();
        }
        TriStateBoolean actionNodeState = TriStateBoolean.UNDEF;
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            TreeNode childObj = children.nextElement();
            if (!(childObj instanceof JMutableTreeNode)) continue;
            JMutableTreeNode childNode = (JMutableTreeNode)childObj;
            TriStateBoolean childNodeState = childNode.descendingUpdateNodes();
            if (childNode.getModel().getHasRadioButton()) {
                if (childNodeState.isTrue() && childNode.getModel().isRadioButtonEnabled() && childNode.getModel().isInternalRadioEnabled()) {
                    actionNodeState = TriStateBoolean.TRUE;
                    break;
                }
                actionNodeState = TriStateBoolean.FALSE;
                continue;
            }
            actionNodeState = actionNodeState.aggregate(childNodeState);
        }
        if (actionNodeState.isUndef()) {
            actionNodeState = TriStateBoolean.FALSE;
        }
        actionData.setCheckBoxState(actionNodeState);
        return actionNodeState;
    }

    public void ascendingUpdateNodes() {
        TreeNode curTreeNode = this.getParent();
        TriStateBoolean ancestorState = TriStateBoolean.UNDEF;
        while (curTreeNode != null) {
            if (curTreeNode instanceof JMutableTreeNode) {
                JTreeCellData data;
                JMutableTreeNode node = (JMutableTreeNode)curTreeNode;
                if (!ancestorState.isTriState()) {
                    Enumeration<TreeNode> children = node.children();
                    while (children.hasMoreElements()) {
                        TriStateBoolean childState;
                        JTreeCellData childData;
                        TreeNode childObj = children.nextElement();
                        if (childObj instanceof JMutableTreeNode && (childData = ((JMutableTreeNode)childObj).getModel()).getHasCheckBox() && (ancestorState = ancestorState.aggregate(childState = childData.getCheckBoxState())).isTriState()) break;
                    }
                }
                if ((data = node.getModel()) != null) {
                    data.setCheckBoxState(ancestorState);
                }
            }
            curTreeNode = curTreeNode.getParent();
        }
    }

    public void updateNodes() {
        this.descendingUpdateNodes();
        this.ascendingUpdateNodes();
    }

    public JMutableTreeNode unselectSibling() {
        if (!(this.getParent() instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.getParent();
        TreeNode sibling = parent.getFirstChild();
        while (sibling != null) {
            JTreeCellData siblingData;
            if (sibling instanceof JMutableTreeNode && (siblingData = ((JMutableTreeNode)sibling).getModel()).isRadioButtonSelected()) {
                siblingData.setRadioButtonSelected(false);
                return (JMutableTreeNode)sibling;
            }
            sibling = ((DefaultMutableTreeNode)sibling).getNextSibling();
        }
        return null;
    }

    public int compareTo(JMutableTreeNode otherNode) {
        if (otherNode == null) {
            return 1;
        }
        JTreeCellData otherData = otherNode._treeCellData;
        if (this._treeCellData == null) {
            if (otherData == null) {
                return 0;
            }
            return -1;
        }
        if (otherData == null) {
            return 1;
        }
        return this._treeCellData.compareTo(otherData);
    }

    public JMutableTreeNode add(JTreeCellData childNodeData) {
        JMutableTreeNode childNode = new JMutableTreeNode(childNodeData);
        this.add(childNode);
        return childNode;
    }

    public JTreeCellData getModel() {
        return this._treeCellData;
    }

    public void setModel(JTreeCellData treeCellData) {
        this._treeCellData = treeCellData;
    }

    public void sortChildren() {
        this.sortChildren(0);
    }

    public void sortChildren(int recursionLevel) {
        if (recursionLevel < 0 || this.children == null) {
            return;
        }
        Collections.sort(this.children);
        if (recursionLevel-- > 0) {
            for (Object next : this.children) {
                ((JMutableTreeNode)next).sortChildren(recursionLevel);
            }
        }
    }

    public void sortDescendents() {
        this.sortChildren(Integer.MAX_VALUE);
    }
}

